/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.PlatformUI;

public class MergeAction
extends Action {
    private final String handlerId;
    private final CommonMenuManager manager;
    private final ISynchronizePageConfiguration configuration;
    private IHandler defaultHandler;

    public MergeAction(String handlerId, CommonMenuManager manager, ISynchronizePageConfiguration configuration) {
        Assert.isNotNull((Object)handlerId);
        Assert.isNotNull((Object)((Object)manager));
        Assert.isNotNull((Object)configuration);
        this.handlerId = handlerId;
        this.manager = manager;
        this.configuration = configuration;
    }

    public void runWithEvent(Event event) {
        IHandler handler = this.getHandler();
        if (handler != null && handler.isEnabled()) {
            final SaveableComparison currentBuffer = ((ModelSynchronizeParticipant)this.configuration.getParticipant()).getActiveSaveable();
            if (currentBuffer != null && currentBuffer.isDirty()) {
                SaveableComparison targetBuffer = null;
                if (handler instanceof MergeActionHandler) {
                    MergeActionHandler mah = (MergeActionHandler)handler;
                    targetBuffer = mah.getSaveable();
                }
                final SaveableComparison target = targetBuffer;
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ModelParticipantAction.handleTargetSaveableChange(MergeAction.this.configuration.getSite().getShell(), target, currentBuffer, true, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Utils.handle(e);
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
                ((ModelSynchronizeParticipant)this.configuration.getParticipant()).setActiveSaveable(targetBuffer);
            }
            try {
                handler.execute(new ExecutionEvent(null, Collections.EMPTY_MAP, (Object)event, null));
            }
            catch (ExecutionException e) {
                this.handle(e);
            }
        }
    }

    protected void handle(Throwable exception) {
        IStatus status;
        ExecutionException ee;
        if (exception instanceof ExecutionException && (ee = (ExecutionException)exception).getCause() != null) {
            this.handle(exception.getCause());
        }
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            status = ce.getStatus();
        } else {
            status = new Status(4, "org.eclipse.team.ui", 0, TeamUIMessages.exception, exception);
        }
        ErrorDialog.openError((Shell)this.configuration.getSite().getShell(), null, null, (IStatus)status);
    }

    private IHandler getHandler() {
        IHandler handler = this.manager.getHandler(this.handlerId);
        if (handler == null) {
            if (this.defaultHandler == null) {
                this.defaultHandler = this.getDefaultHandler();
            }
            return this.defaultHandler;
        }
        return handler;
    }

    private IHandler getDefaultHandler() {
        return MergeActionHandler.getDefaultHandler(this.handlerId, this.configuration);
    }

    private boolean calculateEnablement() {
        IHandler handler = this.getHandler();
        return handler != null && handler.isEnabled();
    }

    public void dispose() {
        if (this.defaultHandler != null) {
            this.defaultHandler.dispose();
        }
    }

    public void update() {
        this.setEnabled(this.calculateEnablement());
    }
}

