/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.FuzzFactorAction;
import org.eclipse.team.internal.ui.mapping.GererateRejFileAction;
import org.eclipse.team.internal.ui.mapping.IgnoreLeadingPathSegmentsAction;
import org.eclipse.team.internal.ui.mapping.ReversePatchAction;
import org.eclipse.team.internal.ui.synchronize.IRefreshable;
import org.eclipse.team.internal.ui.synchronize.patch.PatchModelProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.ui.IActionBars;

public class ApplyPatchModelSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String ID = "org.eclipse.team.ui.applyPatchModelParticipant";

    public ApplyPatchModelSynchronizeParticipant(SynchronizationContext context) {
        super(context);
        this.init();
    }

    private void init() {
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
            this.setInitializationData(descriptor);
            this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.setSupportedModes(9);
        configuration.setMode(1);
    }

    @Override
    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new ApplyPatchModelSynchronizeParticipantActionGroup();
    }

    @Override
    public ModelProvider[] getEnabledModelProviders() {
        ModelProvider[] enabledProviders = super.getEnabledModelProviders();
        int i = 0;
        while (i < enabledProviders.length) {
            ModelProvider provider = enabledProviders[i];
            if (provider.getId().equals("org.eclipse.team.ui.patchModelProvider")) {
                return enabledProviders;
            }
            ++i;
        }
        ModelProvider[] extended = new ModelProvider[enabledProviders.length + 1];
        int i2 = 0;
        while (i2 < enabledProviders.length) {
            extended[i2] = enabledProviders[i2];
            ++i2;
        }
        PatchModelProvider provider = PatchModelProvider.getProvider();
        if (provider == null) {
            return enabledProviders;
        }
        extended[extended.length - 1] = provider;
        return extended;
    }

    @Override
    public ICompareInput asCompareInput(Object object) {
        ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(object);
        if (adapter != null) {
            return adapter.asCompareInput(this.getContext(), object);
        }
        if (object instanceof ICompareInput) {
            return (ICompareInput)object;
        }
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IRefreshable.class) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    public class ApplyPatchModelSynchronizeParticipantActionGroup
    extends ModelSynchronizeParticipantActionGroup {
        @Override
        protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
            if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
                return;
            }
            super.addToContextMenu(mergeActionId, action, manager);
        }

        @Override
        public void fillActionBars(IActionBars actionBars) {
            if (actionBars != null) {
                IMenuManager menu = actionBars.getMenuManager();
                ReversePatchAction reversePatchAction = new ReversePatchAction(this.getConfiguration());
                this.appendToGroup((IContributionManager)menu, "preferences", (IAction)reversePatchAction);
                Utils.initAction((IAction)reversePatchAction, "action.reversePatch.");
                FuzzFactorAction fuzzFactor = new FuzzFactorAction(this.getConfiguration());
                this.appendToGroup((IContributionManager)menu, "preferences", (IAction)fuzzFactor);
                Utils.initAction((IAction)fuzzFactor, "action.fuzzFactor.");
                IgnoreLeadingPathSegmentsAction ignoreAction = new IgnoreLeadingPathSegmentsAction(this.getConfiguration());
                this.appendToGroup((IContributionManager)menu, "preferences", (IAction)ignoreAction);
                Utils.initAction((IAction)ignoreAction, "action.ignoreLeadingPathSegments.");
                GererateRejFileAction generateAction = new GererateRejFileAction(this.getConfiguration());
                this.appendToGroup((IContributionManager)menu, "preferences", (IAction)generateAction);
                Utils.initAction((IAction)generateAction, "action.generateRejFile.");
                this.appendToGroup((IContributionManager)menu, "preferences", (IContributionItem)new Separator());
            }
            super.fillActionBars(actionBars);
        }
    }
}

