/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.SaveablePartAdapter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

@Deprecated
public abstract class PageSaveablePart
extends SaveablePartAdapter
implements IContentChangeListener {
    private CompareConfiguration cc;
    Shell shell;
    private boolean fDirty = false;
    private ArrayList fDirtyViewers = new ArrayList();
    private IPropertyChangeListener fDirtyStateListener;
    private CompareViewerSwitchingPane fContentPane;
    private CompareViewerPane fEditionPane;
    private CompareViewerSwitchingPane fStructuredComparePane;
    private Control control;
    private boolean showContentPanes = true;

    protected PageSaveablePart(Shell shell, CompareConfiguration compareConfiguration) {
        this.shell = shell;
        this.cc = compareConfiguration;
        this.fDirtyStateListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                    }
                    PageSaveablePart.this.setDirty(e.getSource(), changed);
                }
            }
        };
    }

    public boolean isDirty() {
        return this.fDirty || this.fDirtyViewers.size() > 0;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.shell = parent.getShell();
        Splitter vsplitter = new Splitter(composite, 512);
        vsplitter.setLayoutData((Object)new GridData(1808));
        Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
        this.fEditionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
        this.fStructuredComparePane = new CompareViewerSwitchingPane((Composite)hsplitter, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return PageSaveablePart.this.findStructureViewer((Composite)this, oldViewer, (ICompareInput)input);
                }
                return null;
            }
        };
        this.fStructuredComparePane.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                PageSaveablePart.this.feedInput2(e.getSelection());
            }
        });
        this.fEditionPane.setText(TeamUIMessages.ParticipantPageSaveablePart_0);
        this.fContentPane = new CompareViewerSwitchingPane((Composite)vsplitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                boolean isNewViewer;
                if (!(input instanceof ICompareInput)) {
                    return null;
                }
                Viewer newViewer = PageSaveablePart.this.findContentViewer((Composite)this, oldViewer, (ICompareInput)input);
                boolean bl = isNewViewer = newViewer != oldViewer;
                if (isNewViewer && newViewer instanceof IPropertyChangeNotifier) {
                    final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
                    dsp.addPropertyChangeListener(PageSaveablePart.this.fDirtyStateListener);
                    Control c = newViewer.getControl();
                    c.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            dsp.removePropertyChangeListener(PageSaveablePart.this.fDirtyStateListener);
                        }
                    });
                    PageSaveablePart.this.hookContentChangeListener((ICompareInput)input);
                }
                return newViewer;
            }
        };
        vsplitter.setWeights(new int[]{30, 70});
        this.control = composite;
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)this.fEditionPane);
        Control c = this.createPage((Composite)this.fEditionPane, toolBarManager);
        this.fEditionPane.setContent(c);
        if (!this.showContentPanes) {
            hsplitter.setMaximizedControl((Control)this.fEditionPane);
        }
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ICompareInput input = PageSaveablePart.this.getCompareInput(event.getSelection());
                if (input != null) {
                    PageSaveablePart.this.prepareCompareInput(input);
                }
                PageSaveablePart.this.setInput(input);
            }
        });
    }

    protected abstract ISelectionProvider getSelectionProvider();

    protected abstract Control createPage(Composite var1, ToolBarManager var2);

    protected void setPageDescription(String title) {
        this.fEditionPane.setText(title);
    }

    protected void setDirty(boolean dirty) {
        boolean confirmSave = true;
        Object o = this.cc.getProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY");
        if (o instanceof Boolean) {
            confirmSave = (Boolean)o;
        }
        if (!confirmSave) {
            this.fDirty = dirty;
            if (!this.fDirty) {
                this.fDirtyViewers.clear();
            }
        }
    }

    private void setDirty(Object source, boolean dirty) {
        Assert.isNotNull((Object)source);
        if (dirty) {
            this.fDirtyViewers.add(source);
        } else {
            this.fDirtyViewers.remove(source);
        }
    }

    private void setInput(Object input) {
        CompareViewerSwitchingPane pane = this.fContentPane;
        if (pane != null && !pane.isDisposed()) {
            this.fContentPane.setInput(input);
        }
        if (this.fStructuredComparePane != null && !this.fStructuredComparePane.isDisposed()) {
            this.fStructuredComparePane.setInput(input);
        }
    }

    private void feedInput2(ISelection sel) {
        ICompareInput input = this.getCompareInput(sel);
        this.prepareCompareInput(input);
        if (input != null) {
            this.fContentPane.setInput((Object)input);
        }
    }

    protected void prepareCompareInput(final ICompareInput input) {
        if (input == null) {
            return;
        }
        ITypedElement left = input.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement lrte = (LocalResourceTypedElement)left;
            lrte.enableSharedDocument(false);
        }
        IProgressService manager = PlatformUI.getWorkbench().getProgressService();
        try {
            manager.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PageSaveablePart.this.prepareInput(input, PageSaveablePart.this.getCompareConfiguration(), monitor);
                    PageSaveablePart.this.hookContentChangeListener(input);
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected abstract void prepareInput(ICompareInput var1, CompareConfiguration var2, IProgressMonitor var3) throws InvocationTargetException;

    private void hookContentChangeListener(ICompareInput node) {
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)left).addContentChangeListener((IContentChangeListener)this);
        }
        if ((right = node.getRight()) instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)right).addContentChangeListener((IContentChangeListener)this);
        }
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void setNavigator(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_NAVIGATOR", new CompareEditorInputNavigator(new Object[]{configuration.getProperty("org.eclipse.team.ui.P_ADVISOR"), this.fStructuredComparePane, this.fContentPane}));
    }

    private Viewer findStructureViewer(Composite parent, Viewer oldViewer, ICompareInput input) {
        return CompareUI.findStructureViewer((Viewer)oldViewer, (ICompareInput)input, (Composite)parent, (CompareConfiguration)this.cc);
    }

    private Viewer findContentViewer(Composite parent, Viewer oldViewer, ICompareInput input) {
        return CompareUI.findContentViewer((Viewer)oldViewer, (ICompareInput)input, (Composite)parent, (CompareConfiguration)this.cc);
    }

    protected ICompareInput getCompareInput(ISelection selection) {
        Object o;
        IStructuredSelection ss;
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof ICompareInput) {
            return (ICompareInput)o;
        }
        return null;
    }

    public void setShowContentPanes(boolean showContentPanes) {
        this.showContentPanes = showContentPanes;
    }

    public Control getControl() {
        return this.control;
    }

    private CompareConfiguration getCompareConfiguration() {
        return this.cc;
    }

    public void doSave(IProgressMonitor monitor) {
        this.flushViewers(monitor);
    }

    private void flushViewers(IProgressMonitor monitor) {
        Iterator iter = this.fDirtyViewers.iterator();
        int i = 0;
        while (i < this.fDirtyViewers.size()) {
            Object element = iter.next();
            IFlushable flushable = (IFlushable)Adapters.adapt(element, IFlushable.class);
            if (flushable != null) {
                flushable.flush(monitor);
            }
            ++i;
        }
    }
}

