/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public abstract class SynchronizationContentProvider
implements ICommonContentProvider,
IDiffChangeListener,
IPropertyChangeListener {
    private Viewer viewer;
    private boolean empty;
    private ICommonContentExtensionSite site;

    public Object[] getChildren(Object parent) {
        return this.internalGetChildren(parent, false);
    }

    public Object[] getElements(Object parent) {
        return this.internalGetChildren(parent, true);
    }

    public Object getParent(Object element) {
        if ((element = this.internalGetElement(element)) instanceof ModelProvider) {
            return null;
        }
        if (element == this.getModelRoot()) {
            return null;
        }
        Object parent = this.getDelegateContentProvider().getParent(element);
        if (parent == this.getModelRoot()) {
            return this.getModelProvider();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.internalHasChildren(element);
    }

    private Object[] internalGetChildren(Object parent, boolean isElement) {
        Object element = this.internalGetElement(parent);
        if (element instanceof ISynchronizationScope) {
            ISynchronizationScope rms = (ISynchronizationScope)element;
            if (rms.getMappings(this.getModelProviderId()).length > 0) {
                this.empty = false;
                return new Object[]{this.getModelProvider()};
            }
            this.empty = true;
            return new Object[0];
        }
        if (element instanceof ISynchronizationContext) {
            ISynchronizationContext context = (ISynchronizationContext)element;
            ISynchronizationContext sc = (ISynchronizationContext)element;
            if (sc.getScope().getMappings(this.getModelProviderId()).length > 0) {
                Object root = this.getModelRoot();
                boolean initialized = this.isInitialized(context);
                if (!initialized || this.getChildrenInContext(sc, root, this.getDelegateChildren(root, isElement)).length > 0) {
                    if (!initialized) {
                        this.requestInitialization(context);
                    }
                    this.empty = false;
                    return new Object[]{this.getModelProvider()};
                }
            }
            this.empty = true;
            return new Object[0];
        }
        if (element == this.getModelProvider()) {
            ISynchronizationContext context = this.getContext();
            if (context != null && !this.isInitialized(context)) {
                return new Object[0];
            }
            element = this.getModelRoot();
            parent = parent instanceof TreePath ? TreePath.EMPTY.createChildPath(element) : element;
        }
        Object[] delegateChildren = this.getDelegateChildren(parent, isElement);
        ISynchronizationContext context = this.getContext();
        if (context == null) {
            ISynchronizationScope scope = this.getScope();
            if (scope == null) {
                return delegateChildren;
            }
            return this.getChildrenInScope(scope, parent, delegateChildren);
        }
        return this.getChildrenInContext(context, parent, delegateChildren);
    }

    protected boolean isInitialized(ISynchronizationContext context) {
        return true;
    }

    protected void requestInitialization(ISynchronizationContext context) {
    }

    protected Object[] getDelegateChildren(Object parent) {
        return this.getDelegateContentProvider().getChildren(this.internalGetElement(parent));
    }

    private Object[] getDelegateChildren(Object parent, boolean isElement) {
        if (isElement) {
            return this.getDelegateContentProvider().getElements(parent);
        }
        return this.getDelegateChildren(parent);
    }

    private boolean internalHasChildren(Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof ModelProvider) {
            element = this.getModelRoot();
        }
        if (this.getDelegateContentProvider().hasChildren(element)) {
            ISynchronizationContext sc = this.getContext();
            if (sc == null) {
                ISynchronizationScope scope = this.getScope();
                if (scope == null) {
                    return true;
                }
                return this.hasChildrenInScope(scope, elementOrPath);
            }
            return this.hasChildrenInContext(sc, elementOrPath);
        }
        ISynchronizationContext sc = this.getContext();
        if (sc != null) {
            return this.hasChildrenInContext(sc, elementOrPath);
        }
        return false;
    }

    protected boolean hasChildrenInScope(ISynchronizationScope scope, Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(this.internalGetElement(element));
        if (mapping != null) {
            ResourceMapping[] mappings = scope.getMappings(mapping.getModelProviderId());
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping sm = mappings[i];
                if (mapping.contains(sm)) {
                    return true;
                }
                if (sm.contains(mapping)) {
                    return this.getDelegateChildren(element).length > 0;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean hasChildrenInContext(ISynchronizationContext context, Object element) {
        ResourceTraversal[] traversals = this.getTraversals(context, element);
        if (traversals == null) {
            return true;
        }
        return context.getDiffTree().getDiffs(traversals).length > 0;
    }

    public void dispose() {
        ISynchronizePageConfiguration configuration;
        ISynchronizationContext context;
        ICommonContentExtensionSite extensionSite = this.getExtensionSite();
        if (extensionSite != null) {
            extensionSite.getExtensionStateModel().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((context = this.getContext()) != null) {
            context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        }
        if ((configuration = this.getConfiguration()) != null) {
            configuration.removePropertyChangeListener(this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.getDelegateContentProvider().inputChanged(viewer, oldInput, newInput);
    }

    public void init(ICommonContentExtensionSite site) {
        ISynchronizationContext context;
        ITreeContentProvider provider;
        this.site = site;
        site.getExtensionStateModel().addPropertyChangeListener((IPropertyChangeListener)this);
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            configuration.addPropertyChangeListener(this);
        }
        if ((provider = this.getDelegateContentProvider()) instanceof ICommonContentProvider) {
            ((ICommonContentProvider)provider).init(site);
        }
        if ((context = this.getContext()) != null) {
            context.getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE")) {
            this.refresh();
        }
    }

    protected boolean includeDirection(int direction) {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            return ((SynchronizePageConfiguration)configuration).includeDirection(direction);
        }
        return true;
    }

    protected ISynchronizationContext getContext() {
        ICommonContentExtensionSite extensionSite = this.getExtensionSite();
        if (extensionSite != null) {
            return (ISynchronizationContext)extensionSite.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationContext");
        }
        return null;
    }

    protected ISynchronizationScope getScope() {
        ICommonContentExtensionSite extensionSite = this.getExtensionSite();
        if (extensionSite != null) {
            return (ISynchronizationScope)extensionSite.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationScope");
        }
        return null;
    }

    protected ISynchronizePageConfiguration getConfiguration() {
        ICommonContentExtensionSite extensionSite = this.getExtensionSite();
        if (extensionSite != null) {
            return (ISynchronizePageConfiguration)extensionSite.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration");
        }
        return null;
    }

    public void restoreState(IMemento aMemento) {
        ITreeContentProvider provider = this.getDelegateContentProvider();
        if (provider instanceof ICommonContentProvider) {
            ((ICommonContentProvider)provider).restoreState(aMemento);
        }
    }

    public void saveState(IMemento aMemento) {
        ITreeContentProvider provider = this.getDelegateContentProvider();
        if (provider instanceof ICommonContentProvider) {
            ((ICommonContentProvider)provider).saveState(aMemento);
        }
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        this.refresh();
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    protected void refresh() {
        Utils.syncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = (TreeViewer)SynchronizationContentProvider.this.getViewer();
                if (SynchronizationContentProvider.this.empty) {
                    treeViewer.refresh();
                } else {
                    treeViewer.refresh((Object)SynchronizationContentProvider.this.getModelProvider());
                }
            }
        }, this.getViewer().getControl());
    }

    protected abstract ITreeContentProvider getDelegateContentProvider();

    protected final ModelProvider getModelProvider() {
        try {
            return ModelProvider.getModelProviderDescriptor((String)this.getModelProviderId()).getModelProvider();
        }
        catch (CoreException e) {
            throw new IllegalStateException();
        }
    }

    protected abstract String getModelProviderId();

    protected abstract Object getModelRoot();

    protected final Viewer getViewer() {
        return this.viewer;
    }

    protected Object[] getChildrenInScope(ISynchronizationScope scope, Object parent, Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (object != null && this.isInScope(scope, parent, object)) {
                result.add(object);
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        if (children.length != 0) {
            children = this.getChildrenInScope(context.getScope(), parent, children);
        }
        if (parent instanceof IResource) {
            IResource resource = (IResource)parent;
            children = this.getChildrenWithPhantoms(context, resource, children);
        }
        if (children.length == 0) {
            return children;
        }
        return this.internalGetChildren(context, parent, children);
    }

    private Object[] getChildrenWithPhantoms(ISynchronizationContext context, IResource resource, Object[] children) {
        Object[] setChildren = context.getDiffTree().members(resource);
        if (setChildren.length == 0) {
            return children;
        }
        if (children.length == 0) {
            return setChildren;
        }
        HashSet<Object> result = new HashSet<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            result.add(children[i]);
            ++i;
        }
        i = 0;
        while (i < setChildren.length) {
            result.add(setChildren[i]);
            ++i;
        }
        return result.toArray();
    }

    private Object[] internalGetChildren(ISynchronizationContext context, Object parent, Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (parent instanceof TreePath) {
                TreePath tp = (TreePath)parent;
                object = tp.createChildPath(object);
            }
            if (this.isVisible(context, object)) {
                result.add(this.internalGetElement(object));
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    protected boolean isVisible(ISynchronizationContext context, Object object) {
        ResourceTraversal[] traversals = this.getTraversals(context, object);
        IDiff[] deltas = context.getDiffTree().getDiffs(traversals);
        boolean visible = false;
        if (this.isVisible(deltas)) {
            visible = true;
        }
        return visible;
    }

    private boolean isVisible(IDiff[] diffs) {
        if (diffs.length > 0) {
            int j = 0;
            while (j < diffs.length) {
                IDiff diff = diffs[j];
                if (this.isVisible(diff)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected boolean isVisible(IDiff diff) {
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            return this.includeDirection(twd.getDirection());
        }
        return diff.getKind() != 0;
    }

    protected abstract ResourceTraversal[] getTraversals(ISynchronizationContext var1, Object var2);

    protected void handleException(CoreException e) {
        TeamPlugin.log((CoreException)e);
    }

    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(this.internalGetElement(element));
        if (mapping != null) {
            ResourceMapping[] mappings = scope.getMappings(mapping.getModelProviderId());
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping sm = mappings[i];
                if (mapping.contains(sm)) {
                    return true;
                }
                if (sm.contains(mapping)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ICommonContentExtensionSite getExtensionSite() {
        return this.site;
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    protected final boolean isFlatLayout() {
        ISynchronizePageConfiguration c = this.getConfiguration();
        if (c != null) {
            String p = (String)c.getProperty("org.eclipse.team.ui.pageLayout");
            return p != null && p.equals("org.eclipse.team.ui.flatLayout");
        }
        return false;
    }
}

