/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.QueryManager;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class SearchViewManager {
    private IQueryListener fNewQueryListener = new IQueryListener(){

        @Override
        public void queryAdded(ISearchQuery query) {
            SearchViewManager.this.showNewSearchQuery(query);
        }

        @Override
        public void queryRemoved(ISearchQuery query) {
        }

        @Override
        public void queryStarting(ISearchQuery query) {
        }

        @Override
        public void queryFinished(ISearchQuery query) {
        }
    };
    private int fViewCount = 0;
    private LinkedList<SearchView> fLRUSearchViews;

    public SearchViewManager(QueryManager queryManager) {
        queryManager.addQueryListener(this.fNewQueryListener);
        this.fLRUSearchViews = new LinkedList();
    }

    public void dispose(QueryManager queryManager) {
        queryManager.removeQueryListener(this.fNewQueryListener);
    }

    protected boolean showNewSearchQuery(ISearchQuery query) {
        if (!this.fLRUSearchViews.isEmpty()) {
            SearchView view = this.fLRUSearchViews.getFirst();
            view.showSearchResult(query.getSearchResult());
            return true;
        }
        return false;
    }

    public ISearchResultViewPart activateSearchView(boolean avoidPinnedViews) {
        return this.activateSearchView(avoidPinnedViews, false);
    }

    public ISearchResultViewPart activateSearchView(boolean avoidPinnedViews, boolean openInNew) {
        IWorkbenchWindow window;
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        String defaultPerspectiveId = NewSearchUI.getDefaultPerspectiveId();
        if (defaultPerspectiveId != null && (window = activePage.getWorkbenchWindow()) != null && window.getShell() != null && !window.getShell().isDisposed()) {
            try {
                activePage = PlatformUI.getWorkbench().showPerspective(defaultPerspectiveId, window);
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        if (activePage != null) {
            try {
                ISearchResultViewPart viewPart = null;
                if (!openInNew) {
                    viewPart = this.findLRUSearchResultView(activePage, avoidPinnedViews);
                }
                String secondaryId = null;
                if (viewPart == null) {
                    if (activePage.findViewReference("org.eclipse.search.ui.views.SearchView") != null) {
                        secondaryId = String.valueOf(++this.fViewCount);
                    }
                } else {
                    if (!SearchPreferencePage.isViewBroughtToFront()) {
                        return viewPart;
                    }
                    secondaryId = viewPart.getViewSite().getSecondaryId();
                }
                return (ISearchResultViewPart)activePage.showView("org.eclipse.search.ui.views.SearchView", secondaryId, 1);
            }
            catch (PartInitException ex) {
                ExceptionHandler.handle((CoreException)ex, SearchMessages.Search_Error_openResultView_title, SearchMessages.Search_Error_openResultView_message);
            }
        }
        return null;
    }

    public boolean isShown(ISearchQuery query) {
        for (SearchView view : this.fLRUSearchViews) {
            ISearchResult currentSearchResult = view.getCurrentSearchResult();
            if (currentSearchResult == null || query != currentSearchResult.getQuery()) continue;
            return true;
        }
        return false;
    }

    public void activateSearchView(ISearchResultViewPart viewPart) {
        try {
            IWorkbenchPage activePage = viewPart.getSite().getPage();
            String secondaryId = viewPart.getViewSite().getSecondaryId();
            activePage.showView("org.eclipse.search.ui.views.SearchView", secondaryId, 1);
        }
        catch (PartInitException ex) {
            ExceptionHandler.handle((CoreException)ex, SearchMessages.Search_Error_openResultView_title, SearchMessages.Search_Error_openResultView_message);
        }
    }

    private ISearchResultViewPart findLRUSearchResultView(IWorkbenchPage page, boolean avoidPinnedViews) {
        boolean viewFoundInPage = false;
        for (SearchView view : this.fLRUSearchViews) {
            if (!page.equals(view.getSite().getPage())) continue;
            if (!avoidPinnedViews || !view.isPinned()) {
                return view;
            }
            viewFoundInPage = true;
        }
        if (!viewFoundInPage) {
            IViewReference[] viewReferences = page.getViewReferences();
            int i = 0;
            while (i < viewReferences.length) {
                SearchView view;
                IViewReference curr = viewReferences[i];
                if ("org.eclipse.search.ui.views.SearchView".equals(curr.getId()) && page.equals(curr.getPage()) && (view = (SearchView)curr.getView(true)) != null && (!avoidPinnedViews || !view.isPinned())) {
                    return view;
                }
                ++i;
            }
        }
        return null;
    }

    public void searchViewActivated(SearchView view) {
        this.fLRUSearchViews.remove(view);
        this.fLRUSearchViews.addFirst(view);
    }

    public void searchViewClosed(SearchView view) {
        this.fLRUSearchViews.remove(view);
    }

    public ISearchResultViewPart getActiveSearchView() {
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        if (activePage != null) {
            return this.findLRUSearchResultView(activePage, false);
        }
        return null;
    }
}

