/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class GoToMatchingTagAction
extends TextEditorAction {
    private static final String ANNOTATION_TYPE = "org.eclipse.wst.xml.ui.matching.tag";
    private ISelectionChangedListener fUpdateListener = new UpdateListener();
    static final boolean DEBUG = false;

    GoToMatchingTagAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    void removeAnnotation(boolean allMatching) {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        Iterator annotationIterator = annotationModel.getAnnotationIterator();
        ArrayList<Annotation> oldAnnotations = new ArrayList<Annotation>();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!ANNOTATION_TYPE.equals(annotation.getType())) continue;
            annotation.markDeleted(true);
            try {
                annotationIterator.remove();
            }
            catch (UnsupportedOperationException e) {
                oldAnnotations.add(annotation);
            }
            if (!allMatching) break;
        }
        if (!oldAnnotations.isEmpty()) {
            int size = oldAnnotations.size();
            int i = 0;
            while (i < size) {
                annotationModel.removeAnnotation((Annotation)oldAnnotations.get(i));
                ++i;
            }
        }
    }

    public void runWithEvent(Event event) {
        Object o;
        super.runWithEvent(event);
        if (this.getTextEditor() == null) {
            return;
        }
        ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && selection instanceof ITextSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IDOMNode) {
            int offset = ((ITextSelection)selection).getOffset();
            IStructuredDocumentRegion matchRegion = null;
            if (((Node)o).getNodeType() == 2) {
                o = ((Attr)o).getOwnerElement();
            }
            int targetOffset = -1;
            if (o instanceof IDOMNode) {
                IDOMNode node = (IDOMNode)o;
                IStructuredDocumentRegion startStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
                if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.containsOffset(offset)) {
                    matchRegion = ((IDOMNode)o).getEndStructuredDocumentRegion();
                    if (matchRegion != null) {
                        targetOffset = matchRegion.getStartOffset() + 2;
                    }
                } else {
                    IStructuredDocumentRegion endStructuredDocumentRegion = node.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.containsOffset(offset) && (matchRegion = ((IDOMNode)o).getStartStructuredDocumentRegion()) != null) {
                        targetOffset = matchRegion.getStartOffset() + 1;
                    }
                }
            }
            if (targetOffset >= 0) {
                this.getTextEditor().getSelectionProvider().setSelection((ISelection)new TextSelection(targetOffset, 0));
            }
        }
    }

    public void setEditor(ITextEditor editor) {
        ISelectionProvider selectionProvider;
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor != null) {
            this.removeAnnotation(true);
            selectionProvider = textEditor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.fUpdateListener);
            }
        }
        super.setEditor(editor);
        if (editor != null) {
            selectionProvider = editor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.fUpdateListener);
            }
            this.updateFor(selectionProvider.getSelection());
        }
    }

    public void update() {
        this.setEnabled(true);
    }

    void updateFor(ISelection selection) {
        Object o;
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
        if (annotationModel == null || !(annotationModel instanceof IAnnotationModelExtension)) {
            return;
        }
        ArrayList<Annotation> oldAnnotations = new ArrayList<Annotation>(2);
        Iterator annotationIterator = annotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!ANNOTATION_TYPE.equals(annotation.getType())) continue;
            annotation.markDeleted(true);
            oldAnnotations.add(annotation);
        }
        HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && selection instanceof ITextSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IDOMNode) {
            int offset = ((ITextSelection)selection).getOffset();
            IStructuredDocumentRegion matchRegion = null;
            if (((Node)o).getNodeType() == 2) {
                o = ((Attr)o).getOwnerElement();
            }
            Position pStart = null;
            Position pEnd = null;
            String tag = "";
            if (o instanceof IDOMNode) {
                IDOMNode node = (IDOMNode)o;
                IStructuredDocumentRegion startStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
                if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.containsOffset(offset)) {
                    ITextRegion nameRegion;
                    if (startStructuredDocumentRegion.getNumberOfRegions() > 1) {
                        nameRegion = startStructuredDocumentRegion.getRegions().get(1);
                        pStart = new Position(startStructuredDocumentRegion.getStartOffset(nameRegion), nameRegion.getTextLength());
                        tag = startStructuredDocumentRegion.getText(nameRegion);
                    }
                    if ((matchRegion = ((IDOMNode)o).getEndStructuredDocumentRegion()) != null && matchRegion.getNumberOfRegions() > 1) {
                        nameRegion = matchRegion.getRegions().get(1);
                        pEnd = new Position(matchRegion.getStartOffset(nameRegion), nameRegion.getTextLength());
                    }
                } else {
                    IStructuredDocumentRegion endStructuredDocumentRegion = node.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.containsOffset(offset)) {
                        ITextRegion nameRegion;
                        if (endStructuredDocumentRegion.getNumberOfRegions() > 1) {
                            nameRegion = endStructuredDocumentRegion.getRegions().get(1);
                            pEnd = new Position(endStructuredDocumentRegion.getStartOffset(nameRegion), nameRegion.getTextLength());
                            tag = endStructuredDocumentRegion.getText(nameRegion);
                        }
                        if ((matchRegion = ((IDOMNode)o).getStartStructuredDocumentRegion()) != null && matchRegion.getNumberOfRegions() > 1) {
                            nameRegion = matchRegion.getRegions().get(1);
                            pStart = new Position(matchRegion.getStartOffset(nameRegion), nameRegion.getTextLength());
                        }
                    }
                }
            }
            if (pStart != null && pEnd != null) {
                Annotation annotation = new Annotation(ANNOTATION_TYPE, false, NLS.bind((String)XMLUIMessages.gotoMatchingTag_start, (Object)tag));
                newAnnotations.put(annotation, pStart);
                annotation = new Annotation(ANNOTATION_TYPE, false, NLS.bind((String)XMLUIMessages.gotoMatchingTag_end, (Object)tag));
                newAnnotations.put(annotation, pEnd);
            }
        }
        ((IAnnotationModelExtension)annotationModel).replaceAnnotations(oldAnnotations.toArray(new Annotation[oldAnnotations.size()]), newAnnotations);
    }

    private class UpdateListener
    implements ISelectionChangedListener {
        private UpdateListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            GoToMatchingTagAction.this.updateFor(event.getSelection());
        }
    }
}

