/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;

public class XMLCatalogTableViewer
extends TableViewer {
    protected static Image dtdFileImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/dtdfile.png");
    protected static String ERROR_STATE_KEY = "errorstatekey";
    protected static Image errorImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/ovr16/error_ovr.gif");
    protected static Image unknownFileImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/text.png");
    protected static Image xsdFileImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/XSDFile.png");

    public XMLCatalogTableViewer(Composite parent, String[] columnProperties) {
        super(parent, 67584);
        Table table = this.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnProperties.length) {
            TableColumn column = new TableColumn(table, i);
            column.setText(columnProperties[i]);
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
            ++i;
        }
        table.setLayout((Layout)layout);
        table.setLinesVisible(false);
        this.setColumnProperties(columnProperties);
        this.setContentProvider((IContentProvider)new CatalogEntryContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CatalogEntryLabelProvider());
    }

    public Collection getXMLCatalogEntries() {
        return null;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        Action action = new Action("hello"){

            public void run() {
                System.out.println("run!");
            }
        };
        menuManager.add((IAction)action);
    }

    public void setFilterExtensions(String[] extensions) {
        this.resetFilters();
        this.addFilter(new XMLCatalogTableViewerFilter(extensions));
    }

    public class CatalogEntryContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object element) {
            Object[] array = XMLCatalogTableViewer.this.getXMLCatalogEntries().toArray();
            Comparator comparator = new Comparator(this){
                final /* synthetic */ CatalogEntryContentProvider this$1;
                {
                    this.this$1 = catalogEntryContentProvider;
                }

                public int compare(Object o1, Object o2) {
                    int result = 0;
                    if (o1 instanceof ICatalogEntry && o2 instanceof ICatalogEntry) {
                        ICatalogEntry mappingInfo1 = (ICatalogEntry)o1;
                        ICatalogEntry mappingInfo2 = (ICatalogEntry)o2;
                        result = Collator.getInstance().compare(mappingInfo1.getKey(), mappingInfo2.getKey());
                    }
                    return result;
                }
            };
            Arrays.sort(array, comparator);
            return array;
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }

    public class CatalogEntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int columnIndex) {
            Image result = null;
            if (columnIndex == 0) {
                ICatalogEntry catalogEntry;
                String uri;
                Image base = null;
                if (object instanceof ICatalogEntry && (base = (uri = (catalogEntry = (ICatalogEntry)object).getURI()).endsWith("dtd") ? dtdFileImage : (uri.endsWith("xsd") ? xsdFileImage : unknownFileImage)) != null) {
                    result = URIHelper.isReadableURI((String)uri, (boolean)false) ? base : base;
                }
            }
            return result;
        }

        public String getColumnText(Object object, int columnIndex) {
            String result = null;
            if (object instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)object;
                result = columnIndex == 0 ? catalogEntry.getKey() : catalogEntry.getURI();
                result = URIHelper.removePlatformResourceProtocol((String)result);
            }
            return result != null ? result : "";
        }
    }

    class XMLCatalogTableViewerFilter
    extends ViewerFilter {
        protected String[] extensions;

        public XMLCatalogTableViewerFilter(String[] extensions) {
            this.extensions = extensions;
        }

        public boolean isFilterProperty(Object element, Object property) {
            return false;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean result = false;
            if (element instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)element;
                int i = 0;
                while (i < this.extensions.length) {
                    if (catalogEntry.getURI().endsWith(this.extensions[i])) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            }
            return result;
        }
    }
}

