/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.ui.IWorkbenchPart;

public class DiscardChangesActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.mySelection = DiscardChangesActionHandler.getSelection(event);
        try {
            IWorkbenchPart part = this.getPart(event);
            String question = UIText.DiscardChangesAction_confirmActionMessage;
            ILaunchConfiguration launch = LaunchFinder.getRunningLaunchConfiguration(Arrays.asList(this.getRepositories()), null);
            question = launch != null ? MessageFormat.format(question, "\n\n" + MessageFormat.format(UIText.LaunchFinder_RunningLaunchMessage, launch.getName())) : MessageFormat.format(question, "");
            boolean performAction = this.openConfirmationDialog(event, question);
            if (!performAction) {
                return null;
            }
            final DiscardChangesOperation operation = this.createOperation(part, event);
            if (operation == null) {
                return null;
            }
            String jobname = UIText.DiscardChangesAction_discardChanges;
            WorkspaceJob job = new WorkspaceJob(jobname){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        operation.execute(monitor);
                    }
                    catch (CoreException e) {
                        return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (JobFamilies.DISCARD_CHANGES.equals(family)) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            job.setUser(true);
            job.setRule(operation.getSchedulingRule());
            job.schedule();
            return null;
        }
        finally {
            this.mySelection = null;
        }
    }

    private boolean openConfirmationDialog(ExecutionEvent event, String question) throws ExecutionException {
        MessageDialog dlg = new MessageDialog(this.getShell(event), UIText.DiscardChangesAction_confirmActionTitle, null, question, 5, new String[]{UIText.DiscardChangesAction_discardChangesButtonText, IDialogConstants.CANCEL_LABEL}, 0);
        return dlg.open() == 0;
    }

    @Override
    public boolean isEnabled() {
        Repository[] repositories = this.getRepositories();
        if (repositories.length == 0) {
            return false;
        }
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private DiscardChangesOperation createOperation(IWorkbenchPart part, ExecutionEvent event) throws ExecutionException {
        IResource[] resourcesInScope;
        String revision;
        IResource[] selectedResources = this.gatherResourceToOperateOn(event);
        try {
            revision = this.gatherRevision(event);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        try {
            resourcesInScope = GitScopeUtil.getRelatedChanges(part, selectedResources);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return new DiscardChangesOperation(resourcesInScope, revision);
    }

    protected IResource[] gatherResourceToOperateOn(ExecutionEvent event) throws ExecutionException {
        return this.getSelectedResources(event);
    }

    protected String gatherRevision(ExecutionEvent event) throws ExecutionException {
        return null;
    }
}

