/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class LaunchFinder {
    private LaunchFinder() {
    }

    @Nullable
    public static ILaunchConfiguration getRunningLaunchConfiguration(final Collection<Repository> repositories, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        final ILaunchConfiguration[] result = new ILaunchConfiguration[1];
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                HashSet<IProject> projects = new HashSet<IProject>();
                for (Repository repository : repositories) {
                    projects.addAll(Arrays.asList(ProjectUtil.getProjects((Repository)repository)));
                }
                result[0] = LaunchFinder.findLaunch(projects, m);
            }
        };
        try {
            if (ModalContext.isModalContextThread((Thread)Thread.currentThread())) {
                operation.run((IProgressMonitor)progress);
            } else {
                ModalContext.run((IRunnableWithProgress)operation, (boolean)true, (IProgressMonitor)progress, (Display)PlatformUI.getWorkbench().getDisplay());
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    private static ILaunchConfiguration findLaunch(Set<IProject> projects, IProgressMonitor monitor) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)UIText.LaunchFinder_SearchLaunchConfiguration, (int)launches.length);
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (progress.isCanceled()) break;
            if (launch.isTerminated()) {
                progress.worked(1);
            } else {
                ISourceLocator locator = launch.getSourceLocator();
                if (locator instanceof ISourceLookupDirector) {
                    ISourceLookupDirector director = (ISourceLookupDirector)locator;
                    ISourceContainer[] containers = director.getSourceContainers();
                    if (LaunchFinder.isAnyProjectInSourceContainers(containers, projects, (IProgressMonitor)progress.newChild(1))) {
                        return launch.getLaunchConfiguration();
                    }
                } else {
                    progress.worked(1);
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean isAnyProjectInSourceContainers(ISourceContainer[] containers, Set<IProject> projects, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)containers.length);
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectSourceContainer projectContainer;
            ISourceContainer container = iSourceContainerArray[n2];
            if (progress.isCanceled()) break;
            if (container instanceof ProjectSourceContainer && projects.contains((projectContainer = (ProjectSourceContainer)container).getProject())) {
                progress.worked(1);
                return true;
            }
            try {
                boolean found = LaunchFinder.isAnyProjectInSourceContainers(container.getSourceContainers(), projects, (IProgressMonitor)progress.newChild(1));
                if (found) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return false;
    }

    public static boolean shouldCancelBecauseOfRunningLaunches(Repository repository, IProgressMonitor monitor) {
        return LaunchFinder.shouldCancelBecauseOfRunningLaunches(Collections.singleton(repository), monitor);
    }

    public static boolean shouldCancelBecauseOfRunningLaunches(Collection<Repository> repositories, IProgressMonitor monitor) {
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!store.getBoolean("show_running_launch_on_checkout_warning")) {
            return false;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        final ILaunchConfiguration launchConfiguration = LaunchFinder.getRunningLaunchConfiguration(repositories, (IProgressMonitor)progress);
        if (launchConfiguration != null) {
            final boolean[] dialogResult = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    dialogResult[0] = LaunchFinder.showContinueDialogInUI(store, launchConfiguration);
                }
            });
            return dialogResult[0];
        }
        return false;
    }

    private static boolean showContinueDialogInUI(IPreferenceStore store, ILaunchConfiguration launchConfiguration) {
        String[] buttons = new String[]{UIText.BranchOperationUI_Continue, IDialogConstants.CANCEL_LABEL};
        String message = String.valueOf(NLS.bind((String)UIText.LaunchFinder_RunningLaunchMessage, (Object)launchConfiguration.getName())) + ' ' + UIText.LaunchFinder_ContinueQuestion;
        MessageDialogWithToggle continueDialog = new MessageDialogWithToggle(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), UIText.LaunchFinder_RunningLaunchTitle, null, message, 0, buttons, 0, UIText.LaunchFinder_RunningLaunchDontShowAgain, false);
        int result = continueDialog.open();
        if (result == 1 || result == -1) {
            return true;
        }
        boolean dontWarnAgain = continueDialog.getToggleState();
        if (dontWarnAgain) {
            store.setValue("show_running_launch_on_checkout_warning", false);
        }
        return false;
    }
}

