/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CommitSelectionDialog
extends TitleAreaDialog {
    private static final int BATCH_SIZE = 256;
    private final Repository repository;
    private final IResource[] filterResources;
    private CommitGraphTable table;
    private SWTCommitList allCommits;
    private RevFlag highlightFlag;
    private ObjectId commitId;

    public CommitSelectionDialog(Shell parentShell, Repository repository) {
        this(parentShell, repository, null);
    }

    public CommitSelectionDialog(Shell parentShell, Repository repository, IResource[] filterResources) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.filterResources = filterResources;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
        UIUtils.hookDisposal((Widget)main, (ResourceManager)resources);
        this.table = new CommitGraphTable(main, null, (ResourceManager)resources, false);
        this.table.getTableView().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitSelectionDialog.this.commitId = null;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    CommitSelectionDialog.this.commitId = ((SWTCommit)((Object)sel.getFirstElement())).getId();
                }
                CommitSelectionDialog.this.getButton(0).setEnabled(CommitSelectionDialog.this.commitId != null);
            }
        });
        this.table.getTableView().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (CommitSelectionDialog.this.getButton(0).isEnabled()) {
                    CommitSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 400).applyTo(this.table.getControl());
        this.allCommits = new SWTCommitList(this.table.getControl(), (ResourceManager)resources);
        return main;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.CommitSelectionDialog_WindowTitle);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(UIText.CommitSelectionDialog_BuildingCommitListMessage, -1);
                        SWTWalk currentWalk = new SWTWalk(CommitSelectionDialog.this.repository);
                        currentWalk.setTreeFilter(CommitSelectionDialog.this.createTreeFilter());
                        currentWalk.sort(RevSort.COMMIT_TIME_DESC, true);
                        currentWalk.sort(RevSort.BOUNDARY, true);
                        CommitSelectionDialog.this.highlightFlag = currentWalk.newFlag("highlight");
                        CommitSelectionDialog.this.allCommits.source((RevWalk)currentWalk);
                        try {
                            if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_show_all_branches")) {
                                CommitSelectionDialog.this.markStartAllRefs((RevWalk)currentWalk, "refs/heads/");
                                CommitSelectionDialog.this.markStartAllRefs((RevWalk)currentWalk, "refs/remotes/");
                            } else {
                                currentWalk.markStart(currentWalk.parseCommit((AnyObjectId)CommitSelectionDialog.this.repository.resolve("HEAD")));
                            }
                            while (true) {
                                int oldsz = CommitSelectionDialog.this.allCommits.size();
                                CommitSelectionDialog.this.allCommits.fillTo(oldsz + 256 - 1);
                                if (!monitor.isCanceled() && oldsz != CommitSelectionDialog.this.allCommits.size()) {
                                    String taskName = NLS.bind((String)UIText.CommitSelectionDialog_FoundCommitsMessage, (Object)CommitSelectionDialog.this.allCommits.size());
                                    monitor.setTaskName(taskName);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        CommitSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CommitSelectionDialog.this.updateUi();
                            }
                        });
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getCause().getMessage());
        }
        catch (InterruptedException interruptedException) {
            this.setMessage(UIText.CommitSelectionDialog_IncompleteListMessage, 2);
        }
    }

    public ObjectId getCommitId() {
        return this.commitId;
    }

    private void updateUi() {
        this.setTitle(NLS.bind((String)UIText.CommitSelectionDialog_DialogTitle, (Object)this.allCommits.size(), (Object)this.repository.getDirectory().toString()));
        this.setMessage(UIText.CommitSelectionDialog_DialogMessage);
        this.table.setInput(this.highlightFlag, this.allCommits, (SWTCommit[])this.allCommits.toArray((Object[])new SWTCommit[this.allCommits.size()]), null, true);
    }

    private void markStartAllRefs(RevWalk currentWalk, String prefix) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        for (Map.Entry refEntry : this.repository.getRefDatabase().getRefs(prefix).entrySet()) {
            Ref ref = (Ref)refEntry.getValue();
            if (ref.isSymbolic()) continue;
            currentWalk.markStart(currentWalk.parseCommit((AnyObjectId)ref.getObjectId()));
        }
    }

    private TreeFilter createTreeFilter() {
        if (this.filterResources == null) {
            return TreeFilter.ALL;
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        IResource[] iResourceArray = this.filterResources;
        int n = this.filterResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null) {
                DiffConfig diffConfig = (DiffConfig)mapping.getRepository().getConfig().get(DiffConfig.KEY);
                String path = mapping.getRepoRelativePath(resource);
                if (path != null && !"".equals(path)) {
                    if (resource.getType() == 1) {
                        filters.add(FollowFilter.create((String)path, (DiffConfig)diffConfig));
                    } else {
                        filters.add(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
                    }
                }
            }
            ++n2;
        }
        if (filters.isEmpty()) {
            return TreeFilter.ALL;
        }
        if (filters.size() == 1) {
            return (TreeFilter)filters.get(0);
        }
        return OrTreeFilter.create(filters);
    }
}

