/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.make.core.makefile.IAutomaticVariable;
import org.eclipse.cdt.make.core.makefile.IBuiltinFunction;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.text.WordPartDetector;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class MakefileCompletionProcessor
implements IContentAssistProcessor {
    protected IContextInformationValidator fValidator = new Validator();
    protected Image imageFunction = MakeUIImages.getImage("icons/obj16/builtin_func.png");
    protected Image imageVariable = CDTSharedImages.getImage((String)"icons/tobj16/variable_obj.png");
    protected Image imageAutomaticVariable = MakeUIImages.getImage("icons/obj16/var_auto.png");
    protected Image imageTarget = MakeUIImages.getImage("icons/obj16/target_obj.gif");
    protected IEditorPart fEditor;
    protected IWorkingCopyManager fManager;
    private Comparator<IDirective> directivesComparator = new Comparator<IDirective>(){

        @Override
        public int compare(IDirective o1, IDirective o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public MakefileCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        this.fManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>();
        IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        WordPartDetector wordPart = new WordPartDetector(viewer.getDocument(), documentOffset);
        if (wordPart.isMacro()) {
            IAutomaticVariable[] automaticVariables = makefile.getAutomaticVariables();
            proposalList.addAll(this.createCompletionProposals(wordPart, automaticVariables));
            IMacroDefinition[] macroDefinitions = makefile.getMacroDefinitions();
            Arrays.sort(macroDefinitions, this.directivesComparator);
            proposalList.addAll(this.createCompletionProposals(wordPart, macroDefinitions));
            IBuiltinFunction[] builtinFunctions = makefile.getBuiltinFunctions();
            Arrays.sort(builtinFunctions, this.directivesComparator);
            proposalList.addAll(this.createCompletionProposals(wordPart, builtinFunctions));
        } else {
            ITargetRule[] targetRules = makefile.getTargetRules();
            Arrays.sort(targetRules, this.directivesComparator);
            proposalList.addAll(this.createCompletionProposals(wordPart, targetRules));
        }
        return proposalList.toArray(new ICompletionProposal[proposalList.size()]);
    }

    private String macro(String name, BracketHandler bracket) {
        if (bracket.found) {
            name = String.valueOf(bracket.open) + name + bracket.closed;
        }
        return String.valueOf('$') + name;
    }

    private ArrayList<ICompletionProposal> createCompletionProposals(WordPartDetector wordPart, IAutomaticVariable[] autoVars) {
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>(autoVars.length);
        String wordPartName = wordPart.getName();
        BracketHandler bracket = new BracketHandler(wordPartName);
        String partialName = bracket.followingText;
        IAutomaticVariable[] iAutomaticVariableArray = autoVars;
        int n = autoVars.length;
        int n2 = 0;
        while (n2 < n) {
            IAutomaticVariable autoVar = iAutomaticVariableArray[n2];
            String name = autoVar.getName();
            if (name.startsWith(partialName)) {
                String replacement = bracket.found ? String.valueOf(name) + bracket.closed : name;
                CompletionProposal proposal = new CompletionProposal(replacement, wordPart.getOffset(), partialName.length(), replacement.length(), this.imageAutomaticVariable, String.valueOf(this.macro(name, bracket)) + " - " + autoVar.getValue().toString(), null, autoVar.getValue().toString());
                proposalList.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
        return proposalList;
    }

    private ArrayList<ICompletionProposal> createCompletionProposals(WordPartDetector wordPart, IMacroDefinition[] macros) {
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>(macros.length);
        String wordPartName = wordPart.getName();
        BracketHandler bracket = new BracketHandler(wordPartName);
        String partialName = bracket.followingText;
        IMacroDefinition[] iMacroDefinitionArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            IMacroDefinition macro = iMacroDefinitionArray[n2];
            String name = macro.getName();
            if (name.startsWith(partialName)) {
                String replacement = bracket.found ? String.valueOf(name) + bracket.closed : String.valueOf(bracket.open) + name + bracket.closed;
                String displayString = name;
                CompletionProposal proposal = new CompletionProposal(replacement, wordPart.getOffset(), partialName.length(), replacement.length(), this.imageVariable, displayString, null, macro.getValue().toString());
                proposalList.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
        return proposalList;
    }

    private ArrayList<ICompletionProposal> createCompletionProposals(WordPartDetector wordPart, IBuiltinFunction[] builtinFuns) {
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>(builtinFuns.length);
        String wordPartName = wordPart.getName();
        BracketHandler bracket = new BracketHandler(wordPartName);
        String partialName = bracket.followingText;
        IBuiltinFunction[] iBuiltinFunctionArray = builtinFuns;
        int n = builtinFuns.length;
        int n2 = 0;
        while (n2 < n) {
            int cursorPosition;
            IBuiltinFunction builtinFun = iBuiltinFunctionArray[n2];
            String name = builtinFun.getName();
            String replacement = bracket.found ? String.valueOf(name) + bracket.closed : String.valueOf(bracket.open) + name + bracket.closed;
            int indexComma = replacement.indexOf(44);
            int n3 = cursorPosition = indexComma >= 0 ? indexComma : replacement.length() - 1;
            if (name.startsWith(partialName)) {
                CompletionProposal proposal = new CompletionProposal(replacement, wordPart.getOffset(), partialName.length(), cursorPosition, this.imageFunction, "$" + bracket.open + name + bracket.closed, null, builtinFun.getValue().toString());
                proposalList.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
        return proposalList;
    }

    private ArrayList<ICompletionProposal> createCompletionProposals(WordPartDetector wordPart, ITargetRule[] targets) {
        ArrayList<ICompletionProposal> proposalList = new ArrayList<ICompletionProposal>(targets.length);
        String partialName = wordPart.getName();
        ITargetRule[] iTargetRuleArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetRule target = iTargetRuleArray[n2];
            String name = target.getTarget().toString();
            if (name.startsWith(partialName)) {
                String replacement = name;
                CompletionProposal proposal = new CompletionProposal(replacement, wordPart.getOffset(), partialName.length(), replacement.length(), this.imageTarget, name, null, null);
                proposalList.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
        return proposalList;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        WordPartDetector wordPart = new WordPartDetector(viewer.getDocument(), documentOffset);
        IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        ArrayList<String> contextList = new ArrayList<String>();
        ArrayList<ContextInformation> contextInformationList = new ArrayList<ContextInformation>();
        if (wordPart.isMacro()) {
            String value;
            String name;
            IMacroDefinition statement;
            IMacroDefinition[] statements;
            IMacroDefinition[] iMacroDefinitionArray = statements = makefile.getMacroDefinitions();
            int n = statements.length;
            int n2 = 0;
            while (n2 < n) {
                statement = iMacroDefinitionArray[n2];
                if (statement instanceof IMacroDefinition && (name = statement.getName()) != null && name.equals(wordPart.getName()) && (value = statement.getValue().toString()) != null && value.length() > 0) {
                    contextList.add(value);
                    contextInformationList.add(new ContextInformation(this.imageVariable, wordPart.getName(), value));
                }
                ++n2;
            }
            iMacroDefinitionArray = statements = makefile.getBuiltinMacroDefinitions();
            n = statements.length;
            n2 = 0;
            while (n2 < n) {
                statement = iMacroDefinitionArray[n2];
                if (statement instanceof IMacroDefinition && (name = statement.getName()) != null && name.equals(wordPart.getName()) && (value = statement.getValue().toString()) != null && value.length() > 0) {
                    contextList.add(value);
                    contextInformationList.add(new ContextInformation(this.imageAutomaticVariable, wordPart.getName(), value));
                }
                ++n2;
            }
        }
        IContextInformation[] result = contextInformationList.toArray(new IContextInformation[contextInformationList.size()]);
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    private class BracketHandler {
        private char open;
        private char closed;
        private boolean found;
        private String followingText;

        public BracketHandler(String input) {
            char firstChar = input.length() > 0 ? input.charAt(0) : (char)'\u0000';
            this.open = (char)(firstChar == '{' ? 123 : 40);
            this.closed = (char)(firstChar == '{' ? 125 : 41);
            this.found = firstChar == this.open;
            this.followingText = this.found ? input.substring(1) : input;
        }
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

