/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser.browsers;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;

public class BrowserLog {
    private static BrowserLog instance;
    private String logFileName;
    private boolean newSession;
    DateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
    String LN = System.getProperty("line.separator");

    private BrowserLog() {
        try {
            this.newSession = true;
            this.logFileName = WebBrowserUIPlugin.getInstance().getStateLocation().append("browser.log").toOSString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BrowserLog getInstance() {
        if (instance == null) {
            instance = new BrowserLog();
        }
        return instance;
    }

    public static synchronized void log(String message) {
        BrowserLog.getInstance().append(message);
    }

    private void append(String message) {
        if (this.logFileName == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFileName, true), StandardCharsets.UTF_8));){
                if (this.newSession) {
                    this.newSession = false;
                    outWriter.write(String.valueOf(this.LN) + this.formatter.format(new Date()) + " NEW SESSION" + this.LN);
                }
                outWriter.write(String.valueOf(this.formatter.format(new Date())) + " " + message + this.LN);
                ((Writer)outWriter).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

