/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.IResumeAtLineTarget;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class ResumeAtLineActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IWorkbenchPart fActivePart = null;
    private IResumeAtLineTarget fPartTarget = null;
    private IAction fAction = null;
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void run(IAction action) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.resumeAtLine(this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.fActivePart.getSite().getWorkbenchWindow().getShell(), (String)ActionMessages.getString("ResumeAtLineActionDelegate.1"), (String)ActionMessages.getString("ResumeAtLineActionDelegate.2"), (IStatus)e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ISelectionProvider selectionProvider;
                IWorkbenchPartSite site;
                boolean enabled = false;
                if (ResumeAtLineActionDelegate.this.fPartTarget != null && ResumeAtLineActionDelegate.this.fTargetElement != null && (site = ResumeAtLineActionDelegate.this.fActivePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
                    ISelection selection = selectionProvider.getSelection();
                    enabled = ResumeAtLineActionDelegate.this.fTargetElement.isSuspended() && ResumeAtLineActionDelegate.this.fPartTarget.canResumeAtLine(ResumeAtLineActionDelegate.this.fActivePart, selection, ResumeAtLineActionDelegate.this.fTargetElement);
                }
                ResumeAtLineActionDelegate.this.fAction.setEnabled(enabled);
            }
        };
        CDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.init(action);
        this.bindTo((IWorkbenchPart)targetEditor);
    }

    public void init(IViewPart view) {
        this.bindTo((IWorkbenchPart)view);
    }

    private void bindTo(IWorkbenchPart part) {
        IDebugContextManager manager = DebugUITools.getDebugContextManager();
        if (this.fActivePart != null && !this.fActivePart.equals(part)) {
            manager.getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        }
        this.fPartTarget = null;
        this.fActivePart = part;
        if (part != null) {
            IAdapterManager adapterManager;
            IWorkbenchWindow workbenchWindow = part.getSite().getWorkbenchWindow();
            IDebugContextService service = manager.getContextService(workbenchWindow);
            service.addDebugContextListener((IDebugContextListener)this.fContextListener);
            this.fPartTarget = (IResumeAtLineTarget)part.getAdapter(IResumeAtLineTarget.class);
            if (this.fPartTarget == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)part, IResumeAtLineTarget.class.getName())) {
                this.fPartTarget = (IResumeAtLineTarget)adapterManager.loadAdapter((Object)part, IResumeAtLineTarget.class.getName());
            }
            ISelection activeContext = service.getActiveContext();
            this.fContextListener.contextActivated(activeContext);
        }
        this.update();
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IStructuredSelection ss;
            ResumeAtLineActionDelegate.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                ResumeAtLineActionDelegate.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)ss.getFirstElement(), ISuspendResume.class);
            }
            ResumeAtLineActionDelegate.this.update();
        }

        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

