/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.preferences.IC;
import org.osgi.service.prefs.BackingStoreException;

public class ICPreferences {
    public static final String DELIMITER = ",";

    public static void setICs(List<IC> ics) {
        String name = "";
        String host = "";
        String path = "";
        String protocol = "";
        String port = "";
        String enabled = "";
        int i = 0;
        while (i < ics.size()) {
            name = String.valueOf(name) + ics.get(i).getName() + DELIMITER;
            protocol = String.valueOf(protocol) + ics.get(i).getProtocol() + DELIMITER;
            host = String.valueOf(host) + ics.get(i).getHost() + DELIMITER;
            port = String.valueOf(port) + ics.get(i).getPort() + DELIMITER;
            path = String.valueOf(path) + ics.get(i).getPath() + DELIMITER;
            enabled = String.valueOf(enabled) + ics.get(i).isEnabled() + DELIMITER;
            ++i;
        }
        if (ics.size() != 0) {
            name = name.substring(0, name.length() - 1);
            protocol = protocol.substring(0, protocol.length() - 1);
            host = host.substring(0, host.length() - 1);
            port = port.substring(0, port.length() - 1);
            path = path.substring(0, path.length() - 1);
            enabled = enabled.substring(0, enabled.length() - 1);
        }
        ICPreferences.set("org.eclipse.help.base", "remoteHelpName", name);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpHost", host);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpPath", path);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpProtocol", protocol);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpPort", port);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpICEnabled", enabled);
        HelpPlugin.getTocManager().clearCache();
    }

    public static List<IC> getICs() {
        return ICPreferences.prefsToICs(ICPreferences.get("org.eclipse.help.base", "remoteHelpName").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpProtocol").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpHost").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpPort").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpPath").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpICEnabled").split(DELIMITER));
    }

    public static List<IC> prefsToICs(String[] names, String[] protocols, String[] hosts, String[] ports, String[] paths, String[] states) {
        ArrayList<IC> ics = new ArrayList<IC>();
        int i = 0;
        while (i < names.length) {
            if (!names[i].equals("")) {
                try {
                    IC ic = new IC(names[i], String.valueOf(protocols.length > i ? protocols[i] : "http") + "://" + hosts[i] + ":" + ports[i] + paths[i], "true".equalsIgnoreCase(states[i]));
                    ics.add(ic);
                }
                catch (MalformedURLException e) {
                    HelpUIPlugin.logError(e.getMessage(), e);
                }
            }
            ++i;
        }
        return ics;
    }

    public static List<IC> getDefaultICs() {
        return ICPreferences.prefsToICs(ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpName").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpProtocol").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpHost").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpPort").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpPath").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpICEnabled").split(DELIMITER));
    }

    public static String getDefault(String plugin, String name) {
        return ICPreferences.getDefaultNode(plugin).get(name, "");
    }

    public static void setRemoteHelp(boolean enabled) {
        ICPreferences.set("org.eclipse.help.base", "remoteHelpOn", String.valueOf(enabled));
        HelpPlugin.getTocManager().clearCache();
    }

    public static void setRemoteHelpPreferred(boolean remotePreferred) {
        ICPreferences.set("org.eclipse.help.base", "remoteHelpPreferred", String.valueOf(remotePreferred));
        HelpPlugin.getTocManager().clearCache();
    }

    public static void set(String plugin, String name, String value) {
        ICPreferences.set(ICPreferences.getNode(plugin), name, value);
    }

    public static void set(IEclipsePreferences node, String name, String value) {
        node.put(name, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static String get(String plugin, String name) {
        return ICPreferences.getNode(plugin).get(name, "");
    }

    public static IEclipsePreferences getNode(String plugin) {
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(plugin);
        return p;
    }

    public static IEclipsePreferences getDefaultNode(String plugin) {
        IEclipsePreferences p = DefaultScope.INSTANCE.getNode(plugin);
        return p;
    }
}

