/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.StatusInfo;

public abstract class AbstractPreferenceTab
implements IPreferenceTab {
    Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractPreferenceTab.this.fOverlayStore.setValue((String)AbstractPreferenceTab.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private PreferencePage fMainPreferencePage;
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AbstractPreferenceTab.this.numberFieldChanged((Text)e.widget);
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    OverlayPreferenceStore fOverlayStore;
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            AbstractPreferenceTab.this.fOverlayStore.setValue((String)AbstractPreferenceTab.this.fTextFields.get(text), text.getText());
        }
    };
    Map fTextFields = new HashMap();

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels((Control)textControl, textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    protected Text addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return this.getTextControl(this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber));
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                this.fMainPreferencePage.setMessage(message, 0);
                this.fMainPreferencePage.setErrorMessage(null);
                break;
            }
            case 2: {
                this.fMainPreferencePage.setMessage(message, 2);
                this.fMainPreferencePage.setErrorMessage(null);
                break;
            }
            case 1: {
                this.fMainPreferencePage.setMessage(message, 1);
                this.fMainPreferencePage.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                this.fMainPreferencePage.setMessage(null);
                this.fMainPreferencePage.setErrorMessage(message);
            }
        }
    }

    private int convertWidthInCharsToPixels(Control testControl, int chars) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    protected PreferencePage getMainPreferencePage() {
        return this.fMainPreferencePage;
    }

    protected OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    private Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    protected void initializeFields() {
        String key;
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
    }

    void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    protected void setMainPreferencePage(PreferencePage mainPreferencePage) {
        this.fMainPreferencePage = mainPreferencePage;
    }

    protected void setOverlayStore(OverlayPreferenceStore overlayStore) {
        this.fOverlayStore = overlayStore;
    }

    protected void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = s.getSeverity() > status.getSeverity() ? s : status;
                ++i;
            }
        }
        this.fMainPreferencePage.setValid(!status.matches(4));
        this.applyToStatusLine(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(SSEUIMessages.StructuredTextEditorPreferencePage_37);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(String.valueOf(number) + SSEUIMessages.StructuredTextEditorPreferencePage_38);
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(String.valueOf(number) + SSEUIMessages.StructuredTextEditorPreferencePage_38);
            }
        }
        return status;
    }
}

