/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.menus.CommandMessages;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.keys.IBindingService;

public class CommandElement
extends QuickAccessElement {
    private ParameterizedCommand command;
    private String id;

    CommandElement(ParameterizedCommand command, String id, CommandProvider commandProvider) {
        super(commandProvider);
        this.id = id;
        this.command = command;
    }

    @Override
    public void execute() {
        CommandProvider provider;
        QuickAccessProvider o = this.getProvider();
        if (o instanceof CommandProvider && (provider = (CommandProvider)o).getHandlerService() != null && provider.getContextSnapshot() != null) {
            try {
                provider.getHandlerService().executeCommandInContext(this.command, null, provider.getContextSnapshot());
            }
            catch (Exception ex) {
                StatusUtil.handleStatus(ex, 3);
            }
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IHandlerService handlerService = (IHandlerService)window.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(this.command, null);
            }
            catch (Exception ex) {
                StatusUtil.handleStatus(ex, 3);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        ICommandImageService imgService = ((CommandProvider)this.getProvider()).getCommandImageService();
        return imgService == null ? null : imgService.getImageDescriptor(this.getId());
    }

    public String getCommand() {
        StringBuilder label = new StringBuilder();
        try {
            Command nestedCommand = this.command.getCommand();
            label.append(this.command.getName());
            if (nestedCommand != null && nestedCommand.getDescription() != null && nestedCommand.getDescription().length() != 0) {
                label.append(" - ").append(nestedCommand.getDescription());
            }
        }
        catch (NotDefinedException e) {
            label.append(this.command.toString());
        }
        return label.toString();
    }

    @Override
    public String getLabel() {
        String command = this.getCommand();
        String binding = this.getBinding();
        if (binding != null) {
            return NLS.bind((String)CommandMessages.Tooltip_Accelerator, (Object)command, (Object)binding);
        }
        return command;
    }

    public String getBinding() {
        BindingService service = (BindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] triggerSeq = service.getBindingManager().getActiveBindingsDisregardingContextFor(this.command);
        if (triggerSeq != null && triggerSeq.length > 0) {
            return triggerSeq[0].format();
        }
        return null;
    }

    @Override
    public String getSortLabel() {
        try {
            return this.command.getName();
        }
        catch (NotDefinedException e) {
            return this.command.toString();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandElement other = (CommandElement)obj;
        return !(this.command == null ? other.command != null : !this.command.equals((Object)other.command));
    }
}

