/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.TerminateToggleValue;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;

public class LaunchShortcutAction
extends Action {
    private String fMode;
    private LaunchShortcutExtension fShortcut;

    public LaunchShortcutAction(String mode, LaunchShortcutExtension shortcut) {
        super(shortcut.getLabel(), shortcut.getImageDescriptor());
        this.fShortcut = shortcut;
        this.fMode = mode;
        this.updateEnablement();
    }

    public void run() {
        this.runInternal(false);
    }

    private void runInternal(boolean isShift) {
        IStructuredSelection ss = SelectedResourceManager.getDefault().getCurrentSelection();
        Object o = ss.getFirstElement();
        if (o instanceof IEditorPart) {
            DebugUITools.storeLaunchToggleTerminate(o, isShift);
            this.fShortcut.launch((IEditorPart)o, this.fMode);
            DebugUITools.removeLaunchToggleTerminate(o);
        } else {
            DebugUITools.storeLaunchToggleTerminate(ss, new TerminateToggleValue(isShift, this.fShortcut));
            this.fShortcut.launch((ISelection)ss, this.fMode);
            DebugUITools.removeLaunchToggleTerminate(ss);
        }
    }

    public void runWithEvent(Event event) {
        if ((event.stateMask & SWT.MOD1) > 0) {
            Set<String> types = this.fShortcut.getAssociatedConfigurationTypes();
            if (!types.isEmpty()) {
                ILaunchConfiguration config;
                LaunchingResourceManager lrm = DebugUIPlugin.getDefault().getLaunchingResourceManager();
                IStructuredSelection selection = SelectedResourceManager.getDefault().getCurrentSelection();
                ArrayList<LaunchShortcutExtension> shortcuts = new ArrayList<LaunchShortcutExtension>();
                shortcuts.add(this.fShortcut);
                IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
                if (resource == null) {
                    resource = lrm.getLaunchableResource(shortcuts, selection);
                }
                List<ILaunchConfiguration> configs = lrm.getParticipatingLaunchConfigurations(selection, resource, shortcuts, this.fMode);
                LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
                ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType((String)types.toArray()[0]);
                String groupid = null;
                ILaunchGroup group = lcm.getLaunchGroup(type, this.fMode);
                if (group != null) {
                    groupid = group.getIdentifier();
                }
                if ((config = lcm.getMRUConfiguration(configs, group, resource)) == null && configs.size() > 0) {
                    config = configs.get(0);
                }
                if (config != null) {
                    selection = new StructuredSelection((Object)config);
                } else if (type != null) {
                    selection = new StructuredSelection((Object)type);
                }
                DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), selection, groupid);
            } else {
                this.run();
            }
        } else {
            this.runInternal((event.stateMask & 0x20000) > 0);
        }
    }

    private void updateEnablement() {
        boolean enabled = false;
        IStructuredSelection ss = SelectedResourceManager.getDefault().getCurrentSelection();
        Object o = ss.getFirstElement();
        if (o instanceof IEditorPart) {
            enabled = true;
        } else {
            try {
                Expression expression = this.fShortcut.getShortcutEnablementExpression();
                if (expression == null) {
                    enabled = !ss.isEmpty();
                } else {
                    List list = ss.toList();
                    IEvaluationContext context = DebugUIPlugin.createEvaluationContext(list);
                    context.addVariable("selection", (Object)list);
                    enabled = this.fShortcut.evalEnablementExpression(context, expression);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.setEnabled(enabled);
    }
}

