/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.memory.provisional;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;

public abstract class AbstractAsyncTextRendering
extends AbstractAsyncTableRendering {
    private String fCodePage;

    public AbstractAsyncTextRendering(String renderingId) {
        super(renderingId);
    }

    public AbstractAsyncTextRendering(String renderingId, String codePage) {
        super(renderingId);
        this.fCodePage = codePage;
    }

    public void setCodePage(String codePage) {
        this.fCodePage = codePage;
    }

    public String getCodePage() {
        return this.fCodePage;
    }

    @Override
    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        String paddedStr;
        block9: {
            paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
            if (this.fCodePage != null) break block9;
            return "";
        }
        try {
            boolean[] invalid = new boolean[data.length];
            boolean hasInvalid = false;
            byte[] byteArray = new byte[data.length];
            int i = 0;
            while (i < data.length) {
                if (!data[i].isReadable()) {
                    invalid[i] = true;
                    hasInvalid = true;
                }
                byteArray[i] = data[i].getValue();
                ++i;
            }
            if (hasInvalid) {
                StringBuffer strBuf = new StringBuffer();
                int i2 = 0;
                while (i2 < data.length) {
                    if (invalid[i2]) {
                        strBuf.append(paddedStr);
                    } else {
                        strBuf.append(new String(new byte[]{byteArray[i2]}, this.fCodePage));
                    }
                    ++i2;
                }
                return strBuf.toString();
            }
            return new String(byteArray, this.fCodePage);
        }
        catch (UnsupportedEncodingException e) {
            return "-- error --";
        }
    }

    @Override
    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        try {
            if (this.fCodePage == null) {
                return new byte[0];
            }
            byte[] bytes = data.getBytes(this.fCodePage);
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }
}

