/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.search.MethodReferenceMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CuCollectingSearchRequestor;

class MethodOccurenceCollector
extends CuCollectingSearchRequestor {
    private final String fName;

    public MethodOccurenceCollector(String methodName) {
        this.fName = methodName;
    }

    public void acceptSearchMatch(IJavaScriptUnit unit, SearchMatch match) throws CoreException {
        if (match instanceof MethodReferenceMatch && ((MethodReferenceMatch)match).isSuperInvocation() && match.getAccuracy() == 1) {
            return;
        }
        if (match.isImplicit()) {
            this.collectMatch(match);
            return;
        }
        int start = match.getOffset();
        int length = match.getLength();
        String matchText = unit.getBuffer().getText(start, length);
        if (this.fName.equals(matchText)) {
            this.collectMatch(match);
            return;
        }
        IScanner scanner = this.getScanner(unit);
        scanner.setSource(matchText.toCharArray());
        int simpleNameStart = -1;
        int simpleNameEnd = -1;
        try {
            int token = scanner.getNextToken();
            while (token != 158 && token != 7) {
                if (token == 5) {
                    simpleNameStart = scanner.getCurrentTokenStartPosition();
                    simpleNameEnd = scanner.getCurrentTokenEndPosition();
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        if (simpleNameStart != -1) {
            match.setOffset(start + simpleNameStart);
            match.setLength(simpleNameEnd + 1 - simpleNameStart);
        }
        this.collectMatch(match);
    }
}

