/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

public class ASTNodeDeleteUtil {
    private static ASTNode[] getNodesToDelete(IJavaScriptElement element, JavaScriptUnit cuNode) throws JavaScriptModelException {
        if (element.getElementType() == 8) {
            return new ASTNode[]{ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)element, cuNode)};
        }
        if (element.getElementType() == 7 && ((IType)element).isLocal()) {
            IType type = (IType)element;
            if (type.isAnonymous()) {
                ASTNode node;
                ISourceRange range;
                if (type.getParent().getElementType() == 8 && (range = type.getSourceRange()) != null && (node = ASTNodeSearchUtil.getAstNode(cuNode, range.getOffset(), range.getLength())) instanceof AnonymousClassDeclaration) {
                    return new ASTNode[]{node};
                }
                return new ASTNode[]{ASTNodeSearchUtil.getClassInstanceCreationNode(type, cuNode)};
            }
            ASTNode[] nodes = ASTNodeSearchUtil.getDeclarationNodes(element, cuNode);
            nodes[0] = nodes[0].getParent();
            return nodes;
        }
        return ASTNodeSearchUtil.getDeclarationNodes(element, cuNode);
    }

    private static Set getRemovedNodes(final List removed, CompilationUnitRewrite rewrite) {
        final HashSet result = new HashSet();
        rewrite.getRoot().accept((ASTVisitor)new GenericVisitor(true){

            protected boolean visitNode(ASTNode node) {
                if (removed.contains(node)) {
                    result.add(node);
                }
                return true;
            }
        });
        return result;
    }

    public static void markAsDeleted(IJavaScriptElement[] javaElements, CompilationUnitRewrite rewrite, TextEditGroup group) throws JavaScriptModelException {
        ArrayList removed = new ArrayList();
        int i = 0;
        while (i < javaElements.length) {
            ASTNodeDeleteUtil.markAsDeleted(removed, javaElements[i], rewrite, group);
            ++i;
        }
        ASTNodeDeleteUtil.propagateFieldDeclarationNodeDeletions(removed, rewrite, group);
    }

    private static void markAsDeleted(List list, IJavaScriptElement element, CompilationUnitRewrite rewrite, TextEditGroup group) throws JavaScriptModelException {
        ASTNode[] declarationNodes = ASTNodeDeleteUtil.getNodesToDelete(element, rewrite.getRoot());
        int i = 0;
        while (i < declarationNodes.length) {
            ASTNode node = declarationNodes[i];
            if (node != null) {
                list.add(node);
                rewrite.getASTRewrite().remove(node, group);
                rewrite.getImportRemover().registerRemovedNode(node);
            }
            ++i;
        }
    }

    private static void propagateFieldDeclarationNodeDeletions(List removed, CompilationUnitRewrite rewrite, TextEditGroup group) {
        Set removedNodes = ASTNodeDeleteUtil.getRemovedNodes(removed, rewrite);
        for (ASTNode node : removedNodes) {
            if (!(node instanceof VariableDeclarationFragment)) continue;
            if (node.getParent() instanceof FieldDeclaration) {
                FieldDeclaration fd = (FieldDeclaration)node.getParent();
                if (!removed.contains(fd) && removedNodes.containsAll(fd.fragments())) {
                    rewrite.getASTRewrite().remove((ASTNode)fd, group);
                }
                rewrite.getImportRemover().registerRemovedNode((ASTNode)fd);
                continue;
            }
            if (!(node.getParent() instanceof VariableDeclarationStatement)) continue;
            VariableDeclarationStatement stmt = (VariableDeclarationStatement)node.getParent();
            if (!removed.contains(stmt) && removedNodes.containsAll(stmt.fragments())) {
                rewrite.getASTRewrite().remove((ASTNode)stmt, group);
            }
            rewrite.getImportRemover().registerRemovedNode((ASTNode)stmt);
        }
    }

    private ASTNodeDeleteUtil() {
    }
}

