/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariableGuess;

public abstract class CompilationUnitContext
extends DocumentTemplateContext {
    private final IJavaScriptUnit fCompilationUnit;
    protected boolean fForceEvaluation;
    protected MultiVariableGuess fMultiVariableGuess;
    protected final boolean fIsManaged;

    protected CompilationUnitContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, IJavaScriptUnit compilationUnit) {
        super(type, document, completionOffset, completionLength);
        this.fCompilationUnit = compilationUnit;
        this.fIsManaged = false;
    }

    protected CompilationUnitContext(TemplateContextType type, IDocument document, Position completionPosition, IJavaScriptUnit compilationUnit) {
        super(type, document, completionPosition);
        this.fCompilationUnit = compilationUnit;
        this.fIsManaged = true;
    }

    public final IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IJavaScriptElement findEnclosingElement(int elementType) {
        if (this.fCompilationUnit == null) {
            return null;
        }
        try {
            IJavaScriptElement element = this.fCompilationUnit.getElementAt(this.getStart());
            if (element == null) {
                element = this.fCompilationUnit;
            }
            return element.getAncestor(elementType);
        }
        catch (JavaScriptModelException e) {
            return null;
        }
    }

    public void setForceEvaluation(boolean evaluate) {
        this.fForceEvaluation = evaluate;
    }

    public MultiVariableGuess getMultiVariableGuess() {
        return this.fMultiVariableGuess;
    }

    void setMultiVariableGuess(MultiVariableGuess multiVariableGuess) {
        this.fMultiVariableGuess = multiVariableGuess;
    }

    protected IJavaScriptProject getJavaProject() {
        IJavaScriptUnit compilationUnit = this.getCompilationUnit();
        IJavaScriptProject project = compilationUnit == null ? null : compilationUnit.getJavaScriptProject();
        return project;
    }
}

