/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.List;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaVariable;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;

public class TypeVariableResolver
extends TemplateVariableResolver {
    public void resolve(TemplateVariable variable, TemplateContext context) {
        TemplateVariable refVar;
        if (!(variable instanceof MultiVariable)) {
            super.resolve(variable, context);
            return;
        }
        MultiVariable mv = (MultiVariable)variable;
        List params = variable.getVariableType().getParams();
        if (params.isEmpty()) {
            super.resolve(variable, context);
            return;
        }
        JavaContext jc = (JavaContext)context;
        String reference = (String)params.get(0);
        int index = 0;
        if (params.size() > 1) {
            String indexParam = (String)params.get(1);
            try {
                index = Integer.parseInt(indexParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((refVar = jc.getTemplateVariable(reference)) instanceof JavaVariable) {
            JavaVariable jvar = (JavaVariable)refVar;
            this.resolve(mv, jvar, index, jc);
            return;
        }
        super.resolve(variable, context);
    }

    private void resolve(MultiVariable mv, JavaVariable master, int index, JavaContext context) {
        Object[] choices = master.getChoices();
        if (choices instanceof CompilationUnitCompletion.Variable[]) {
            context.addDependency(master, mv);
            CompilationUnitCompletion.Variable[] variables = (CompilationUnitCompletion.Variable[])choices;
            String type = master.getParamType();
            int i = 0;
            while (i < choices.length) {
                Object[] bounds = variables[i].getTypeArgumentBoundSignatures(type, index);
                int j = 0;
                while (j < bounds.length) {
                    bounds[j] = Signature.getSignatureSimpleName((String)bounds[j]);
                    ++j;
                }
                mv.setChoices(variables[i], bounds);
                ++i;
            }
        } else {
            super.resolve((TemplateVariable)mv, (TemplateContext)context);
            return;
        }
        mv.setKey(master.getCurrentChoice());
    }
}

