/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;

class CopyCallHierarchyAction
extends Action {
    private static final char INDENTATION = '\t';
    private CallHierarchyViewPart fView;
    private CallHierarchyViewer fViewer;
    private final Clipboard fClipboard;

    public CopyCallHierarchyAction(CallHierarchyViewPart view, Clipboard clipboard, CallHierarchyViewer viewer) {
        super(CallHierarchyMessages.CopyCallHierarchyAction_label);
        Assert.isNotNull((Object)clipboard);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_copy_action_context");
        this.fView = view;
        this.fClipboard = clipboard;
        this.fViewer = viewer;
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        return element != null;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fView.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run() {
        block3: {
            StringBuffer buf = new StringBuffer();
            this.addCalls(this.fViewer.getTree().getSelection()[0], 0, buf);
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{CopyCallHierarchyAction.convertLineTerminators(buf.toString())}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getViewSite().getShell(), (String)CallHierarchyMessages.CopyCallHierarchyAction_problem, (String)CallHierarchyMessages.CopyCallHierarchyAction_clipboard_busy)) break block3;
                this.run();
            }
        }
    }

    private void addCalls(TreeItem item, int indent, StringBuffer buf) {
        int i = 0;
        while (i < indent) {
            buf.append('\t');
            ++i;
        }
        buf.append(item.getText());
        buf.append('\n');
        if (item.getExpanded()) {
            TreeItem[] items = item.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                this.addCalls(items[i2], indent + 1, buf);
                ++i2;
            }
        }
    }

    static String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                printWriter.print(line);
                line = bufferedReader.readLine();
                if (line == null || line.length() == 0) continue;
                printWriter.println();
            }
        }
        catch (IOException e) {
            return in;
        }
        return stringWriter.toString();
    }
}

