/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.fix.SaveParticipantMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeFormatingTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CodeStyleTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.UnnecessaryCodeTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public class CleanUpSaveParticipantConfigurationModifyDialog
extends StatusDialog
implements ModifyDialogTabPage.IModificationListener {
    private static final String DS_KEY_PREFERRED_WIDTH = "clean_up_save_particpant_modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "clean_up_save_particpant_modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "clean_up_save_particpant_modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "clean_up_save_particpant_modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "clean_up_save_particpant_modify_dialog.last_focus";
    private static final int APPLY_BUTTON_ID = 1024;
    private final Map fWorkingValues;
    private Map fOrginalValues;
    private final List fTabPages;
    private final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private Button fApplyButton;
    private CleanUpTabPage[] fPages;
    private Label fCountLabel;

    public CleanUpSaveParticipantConfigurationModifyDialog(Shell parentShell, Map settings, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.setTitle(title);
        this.fWorkingValues = settings;
        this.fOrginalValues = new HashMap(settings);
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaScriptPlugin.getDefault().getDialogSettings();
    }

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(DS_KEY_LAST_FOCUS);
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException x) {
            lastFocusNr = 0;
        }
        this.fTabFolder.setSelection(lastFocusNr);
        ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPages = this.createTabPages(this.fWorkingValues);
        this.fCountLabel = new Label(composite, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.updateCountLabel();
        CleanUpSaveParticipantConfigurationModifyDialog.applyDialogFont((Control)composite);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)tabItem.getData();
                CleanUpSaveParticipantConfigurationModifyDialog.this.fDialogSettings.put(CleanUpSaveParticipantConfigurationModifyDialog.DS_KEY_LAST_FOCUS, CleanUpSaveParticipantConfigurationModifyDialog.this.fTabPages.indexOf(page));
                page.makeVisible();
            }
        });
        this.updateStatus(StatusInfo.OK_STATUS);
        return composite;
    }

    protected CleanUpTabPage[] createTabPages(Map workingValues) {
        CleanUpTabPage[] result = new CleanUpTabPage[]{new CodeStyleTabPage(this, workingValues, true), new UnnecessaryCodeTabPage(this, workingValues, true), new CodeFormatingTabPage(this, workingValues, true)};
        this.addTabPage(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_CodeStyle_TabPage, result[0]);
        this.addTabPage(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_UnnecessaryCode_TabPage, result[1]);
        this.addTabPage(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_CodeOrganizing_TabPage, result[2]);
        return result;
    }

    public void updateStatus(IStatus status) {
        int count = 0;
        int i = 0;
        while (i < this.fPages.length) {
            count += this.fPages[i].getSelectedCleanUpCount();
            ++i;
        }
        if (count == 0) {
            super.updateStatus((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_SelectAnAction_Error));
        } else if (status == null) {
            super.updateStatus(StatusInfo.OK_STATUS);
        } else {
            super.updateStatus(status);
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastHeight;
            int lastWidth = this.fDialogSettings.getInt(DS_KEY_PREFERRED_WIDTH);
            if (initialSize.x > lastWidth) {
                lastWidth = initialSize.x;
            }
            if (initialSize.y > (lastHeight = this.fDialogSettings.getInt(DS_KEY_PREFERRED_HEIGHT))) {
                lastHeight = initialSize.x;
            }
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(DS_KEY_PREFERRED_X), this.fDialogSettings.getInt(DS_KEY_PREFERRED_Y));
        }
        catch (NumberFormatException ex) {
            return super.getInitialLocation(initialSize);
        }
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(DS_KEY_PREFERRED_WIDTH, shell.width);
        this.fDialogSettings.put(DS_KEY_PREFERRED_HEIGHT, shell.height);
        this.fDialogSettings.put(DS_KEY_PREFERRED_X, shell.x);
        this.fDialogSettings.put(DS_KEY_PREFERRED_Y, shell.y);
        return super.close();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.applyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void applyPressed() {
        this.fOrginalValues = new HashMap(this.fWorkingValues);
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fApplyButton = this.createButton(parent, 1024, SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_Apply_Button, false);
        this.fApplyButton.setEnabled(false);
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.widthHint = layout.horizontalSpacing;
        label.setLayoutData((Object)data);
        super.createButtonsForButtonBar(parent);
    }

    protected final void addTabPage(String title, ModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        CleanUpSaveParticipantConfigurationModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges() && !status.matches(4));
        }
    }

    private boolean hasChanges() {
        for (String key : this.fWorkingValues.keySet()) {
            if (this.fWorkingValues.get(key).equals(this.fOrginalValues.get(key))) continue;
            return true;
        }
        return false;
    }

    public void valuesModified() {
        this.updateCountLabel();
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    private void updateCountLabel() {
        int size = 0;
        int count = 0;
        int i = 0;
        while (i < this.fPages.length) {
            size += this.fPages[i].getCleanUpCount();
            count += this.fPages[i].getSelectedCleanUpCount();
            ++i;
        }
        this.fCountLabel.setText(Messages.format(SaveParticipantMessages.CleanUpSaveParticipantConfigurationModifyDialog_XofYSelected_Label, new Object[]{count, size}));
    }
}

