/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPostSaveListener;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpSaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.ISaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.SaveParticipantDescriptor;

public final class SaveParticipantRegistry {
    private static final IPostSaveListener[] EMPTY_ARRAY = new IPostSaveListener[0];
    private Map fDescriptors;

    public synchronized SaveParticipantDescriptor[] getSaveParticipantDescriptors() {
        this.ensureRegistered();
        return this.fDescriptors.values().toArray(new SaveParticipantDescriptor[this.fDescriptors.size()]);
    }

    public synchronized SaveParticipantDescriptor getSaveParticipantDescriptor(String id) {
        this.ensureRegistered();
        return (SaveParticipantDescriptor)this.fDescriptors.get(id);
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadDescriptors();
        }
    }

    private void reloadDescriptors() {
        HashMap<String, 1> map = new HashMap<String, 1>();
        SaveParticipantDescriptor desc = new SaveParticipantDescriptor(new CleanUpPostSaveListener()){

            public ISaveParticipantPreferenceConfiguration createPreferenceConfiguration() {
                return new CleanUpSaveParticipantPreferenceConfiguration();
            }
        };
        map.put(desc.getId(), desc);
        this.fDescriptors = map;
    }

    public void dispose() {
    }

    public synchronized boolean hasSettingsInScope(IScopeContext context) {
        this.ensureRegistered();
        for (SaveParticipantDescriptor descriptor : this.fDescriptors.values()) {
            if (!descriptor.getPreferenceConfiguration().hasSettingsInScope(context)) continue;
            return true;
        }
        return false;
    }

    public IPostSaveListener[] getEnabledPostSaveListeners(IProject project) {
        return this.getEnabledPostSaveListeners((IScopeContext)new ProjectScope(project));
    }

    public synchronized IPostSaveListener[] getEnabledPostSaveListeners(IScopeContext context) {
        this.ensureRegistered();
        ArrayList<IPostSaveListener> result = null;
        for (SaveParticipantDescriptor descriptor : this.fDescriptors.values()) {
            if (!descriptor.getPreferenceConfiguration().isEnabled(context)) continue;
            if (result == null) {
                result = new ArrayList<IPostSaveListener>();
            }
            result.add(descriptor.getPostSaveListener());
        }
        if (result == null) {
            return EMPTY_ARRAY;
        }
        return result.toArray(new IPostSaveListener[result.size()]);
    }
}

