/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaPreferencesSettings {
    public static CodeGenerationSettings getCodeGenerationSettings(IJavaScriptProject project) {
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.createComments = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.javadoc", project));
        res.useKeywordThis = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.keywordthis", project));
        res.overrideAnnotation = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.overrideannotation", project));
        res.importOrder = JavaPreferencesSettings.getImportOrderPreference(project);
        res.importThreshold = JavaPreferencesSettings.getImportNumberThreshold(project);
        res.staticImportThreshold = JavaPreferencesSettings.getStaticImportNumberThreshold(project);
        res.importIgnoreLowercase = Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ignorelowercasenames", project));
        res.tabWidth = CodeFormatterUtil.getTabWidth(project);
        res.indentWidth = CodeFormatterUtil.getIndentWidth(project);
        return res;
    }

    public static CodeGenerationSettings getCodeGenerationSettings() {
        return JavaPreferencesSettings.getCodeGenerationSettings(null);
    }

    public static int getImportNumberThreshold(IJavaScriptProject project) {
        String thresholdStr = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ondemandthreshold", project);
        try {
            int threshold = Integer.parseInt(thresholdStr);
            if (threshold < 0) {
                threshold = Integer.MAX_VALUE;
            }
            return threshold;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static int getStaticImportNumberThreshold(IJavaScriptProject project) {
        String thresholdStr = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.ondemandthreshold", project);
        try {
            int threshold = Integer.parseInt(thresholdStr);
            if (threshold < 0) {
                threshold = Integer.MAX_VALUE;
            }
            return threshold;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static String[] getImportOrderPreference(IJavaScriptProject project) {
        String str = PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.importorder", project);
        if (str != null) {
            return JavaPreferencesSettings.unpackList(str, ";");
        }
        return new String[0];
    }

    public static int getImportNumberThreshold(IPreferenceStore prefs) {
        int threshold = prefs.getInt("org.eclipse.wst.jsdt.ui.ondemandthreshold");
        if (threshold < 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    public static String[] getImportOrderPreference(IPreferenceStore prefs) {
        String str = prefs.getString("org.eclipse.wst.jsdt.ui.importorder");
        if (str != null) {
            return JavaPreferencesSettings.unpackList(str, ";");
        }
        return new String[0];
    }

    private static String[] unpackList(String str, String separator) {
        StringTokenizer tok = new StringTokenizer(str, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }
}

