/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringSaveHelper;

public class RefactoringExecutionHelper {
    private final Refactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fStopSeverity;
    private final int fSaveMode;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSeverity, int saveMode, Shell parent, IRunnableContext context) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)context);
        this.fRefactoring = refactoring;
        this.fStopSeverity = stopSeverity;
        this.fParent = parent;
        this.fExecContext = context;
        this.fSaveMode = saveMode;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(boolean fork, boolean cancelable) throws InterruptedException, InvocationTargetException {
        void var4_6;
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        final IJobManager manager = Job.getJobManager();
        if (this.fRefactoring instanceof IScheduledRefactoring) {
            ISchedulingRule iSchedulingRule = ((IScheduledRefactoring)this.fRefactoring).getSchedulingRule();
        } else {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        try {
            try {
                Runnable r = new Runnable((ISchedulingRule)var4_6){
                    private final /* synthetic */ ISchedulingRule val$rule;
                    {
                        this.val$rule = iSchedulingRule;
                    }

                    public void run() {
                        manager.beginRule(this.val$rule, null);
                    }
                };
                BusyIndicator.showWhile((Display)this.fParent.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(this.fSaveMode);
            if (!saveHelper.saveEditors(this.fParent)) {
                throw new InterruptedException();
            }
            Operation op = new Operation(fork);
            this.fRefactoring.setValidationContext((Object)this.fParent);
            try {
                class OperationRunner
                extends WorkbenchRunnableAdapter
                implements IThreadListener {
                    private final /* synthetic */ IJobManager val$manager;

                    public OperationRunner(IWorkspaceRunnable runnable, ISchedulingRule schedulingRule, IJobManager iJobManager) {
                        this.val$manager = iJobManager;
                        super(runnable, schedulingRule);
                    }

                    public void threadChange(Thread thread) {
                        this.val$manager.transferRule(this.getSchedulingRule(), thread);
                    }
                }
                this.fExecContext.run(fork, cancelable, (IRunnableWithProgress)new OperationRunner(op, (ISchedulingRule)var4_6, manager));
                if (fork && op.fPerformChangeOperation != null) {
                    this.fExecContext.run(false, false, (IRunnableWithProgress)new OperationRunner((IWorkspaceRunnable)op.fPerformChangeOperation, (ISchedulingRule)var4_6, manager));
                }
                if (op.fPerformChangeOperation == null) {
                }
                RefactoringStatus validationStatus = op.fPerformChangeOperation.getValidationStatus();
                if (validationStatus == null) {
                }
                if (validationStatus.hasFatalError()) {
                    MessageDialog.openError((Shell)this.fParent, (String)this.fRefactoring.getName(), (String)Messages.format(RefactoringMessages.RefactoringExecutionHelper_cannot_execute, validationStatus.getMessageMatchingSeverity(4)));
                    return;
                }
            }
            catch (InvocationTargetException e) {
                PerformChangeOperation pco = op.fPerformChangeOperation;
                if (pco == null) throw e;
                if (!pco.changeExecutionFailed()) throw e;
                ChangeExceptionHandler handler = new ChangeExceptionHandler(this.fParent, this.fRefactoring);
                Throwable inner = e.getTargetException();
                if (inner instanceof RuntimeException) {
                    handler.handle(pco.getChange(), (RuntimeException)inner);
                    return;
                }
                if (!(inner instanceof CoreException)) throw e;
                handler.handle(pco.getChange(), (CoreException)inner);
                return;
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            finally {
                saveHelper.triggerBuild();
            }
        }
        finally {
            manager.endRule((ISchedulingRule)var4_6);
            this.fRefactoring.setValidationContext(null);
        }
    }

    private class Operation
    implements IWorkspaceRunnable {
        public Change fChange;
        public PerformChangeOperation fPerformChangeOperation;
        private final boolean fForked;

        public Operation(boolean forked) {
            this.fForked = forked;
        }

        public void run(IProgressMonitor pm) throws CoreException {
            try {
                pm.beginTask("", this.fForked ? 7 : 11);
                pm.subTask("");
                final RefactoringStatus status = RefactoringExecutionHelper.this.fRefactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                if (status.getSeverity() >= RefactoringExecutionHelper.this.fStopSeverity) {
                    final boolean[] canceled = new boolean[1];
                    if (this.fForked) {
                        RefactoringExecutionHelper.this.fParent.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                canceled[0] = Operation.this.showStatusDialog(status);
                            }
                        });
                    } else {
                        canceled[0] = this.showStatusDialog(status);
                    }
                    if (canceled[0]) {
                        throw new OperationCanceledException();
                    }
                }
                this.fChange = RefactoringExecutionHelper.this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                this.fChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                this.fPerformChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)this.fChange);
                this.fPerformChangeOperation.setUndoManager(RefactoringCore.getUndoManager(), RefactoringExecutionHelper.this.fRefactoring.getName());
                if (RefactoringExecutionHelper.this.fRefactoring instanceof IScheduledRefactoring) {
                    this.fPerformChangeOperation.setSchedulingRule(((IScheduledRefactoring)RefactoringExecutionHelper.this.fRefactoring).getSchedulingRule());
                }
                if (!this.fForked) {
                    this.fPerformChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                }
            }
            finally {
                pm.done();
            }
        }

        private boolean showStatusDialog(RefactoringStatus status) {
            Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)RefactoringExecutionHelper.this.fParent, (String)RefactoringExecutionHelper.this.fRefactoring.getName(), (boolean)false);
            return dialog.open() == 1;
        }
    }
}

