/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public final class MoveInstanceMethodAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public MoveInstanceMethodAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public MoveInstanceMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.MoveInstanceMethodAction_Move_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveMethodAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveMethodAvailable(selection));
        }
        catch (CoreException e) {
            this.setEnabled(false);
        }
    }

    private static IFunction getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IFunction)) {
            return null;
        }
        return (IFunction)first;
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isMoveMethodAvailable(selection));
            IFunction method = MoveInstanceMethodAction.getSingleSelectedMethod(selection);
            Assert.isNotNull((Object)method);
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaScriptElement)method)) {
                return;
            }
            RefactoringExecutionStarter.startMoveMethodRefactoring(method, this.getShell());
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.MoveInstanceMethodAction_dialog_title, RefactoringMessages.MoveInstanceMethodAction_unexpected_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            this.run(selection, SelectionConverter.getInputAsCompilationUnit(this.fEditor));
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.MoveInstanceMethodAction_dialog_title, RefactoringMessages.MoveInstanceMethodAction_unexpected_exception);
        }
    }

    private void run(ITextSelection selection, IJavaScriptUnit cu) throws JavaScriptModelException {
        Assert.isNotNull((Object)cu);
        Assert.isTrue((selection.getOffset() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selection.getLength() >= 0 ? 1 : 0) != 0);
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaScriptElement)cu)) {
            return;
        }
        IFunction method = MoveInstanceMethodAction.getMethod(cu, selection);
        if (method != null) {
            RefactoringExecutionStarter.startMoveMethodRefactoring(method, this.getShell());
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveInstanceMethodAction_dialog_title, (String)RefactoringMessages.MoveInstanceMethodAction_No_reference_or_declaration);
        }
    }

    private static IFunction getMethod(IJavaScriptUnit cu, ITextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement element = SelectionConverter.getElementAtOffset((IJavaScriptElement)cu, selection);
        if (element instanceof IFunction) {
            return (IFunction)element;
        }
        return null;
    }
}

