/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ReorgMoveAction
extends SelectionDispatchAction {
    public ReorgMoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.ReorgMoveAction_3);
        this.setDescription(ReorgMessages.ReorgMoveAction_4);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block7: {
            if (!selection.isEmpty()) {
                if (ReorgUtils.containsOnlyProjects(selection.toList())) {
                    this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
                    return;
                }
                try {
                    List elements = selection.toList();
                    IResource[] resources = ReorgUtils.getResources(elements);
                    IJavaScriptElement[] javaElements = ReorgUtils.getJavaElements(elements);
                    if (elements.size() != resources.length + javaElements.length) {
                        this.setEnabled(false);
                        break block7;
                    }
                    this.setEnabled(RefactoringAvailabilityTester.isMoveAvailable(resources, javaElements));
                }
                catch (JavaScriptModelException e) {
                    if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                        JavaScriptPlugin.log(e);
                    }
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            this.setEnabled(false);
        }
    }

    private MoveProjectAction createWorkbenchAction(IStructuredSelection selection) {
        MoveProjectAction action = new MoveProjectAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaScriptElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (RefactoringAvailabilityTester.isMoveAvailable(resources, javaElements)) {
                RefactoringExecutionStarter.startMoveRefactoring(resources, javaElements, this.getShell());
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

