/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class ReorgMoveWizard
extends RefactoringWizard {
    public ReorgMoveWizard(MoveRefactoring ref) {
        super((Refactoring)ref, 4 | ReorgMoveWizard.computeHasPreviewPage(ref));
        if (ReorgMoveWizard.isTextualMove(ref)) {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_textual_move);
        } else {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_3);
        }
    }

    private static boolean isTextualMove(MoveRefactoring ref) {
        JavaMoveProcessor moveProcessor = (JavaMoveProcessor)ref.getAdapter(JavaMoveProcessor.class);
        return moveProcessor.isTextualMove();
    }

    private static int computeHasPreviewPage(MoveRefactoring refactoring) {
        JavaMoveProcessor processor = (JavaMoveProcessor)refactoring.getAdapter(JavaMoveProcessor.class);
        if (processor.canUpdateReferences() || processor.canEnableQualifiedNameUpdating()) {
            return 0;
        }
        return 16;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage());
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;
        private ICreateTargetQuery fCreateTargetQuery;
        private Object fDestination;

        public MoveInputPage() {
            super(PAGE_NAME);
        }

        private JavaMoveProcessor getJavaMoveProcessor() {
            return (JavaMoveProcessor)this.getRefactoring().getAdapter(JavaMoveProcessor.class);
        }

        protected Object getInitiallySelectedElement() {
            return this.getJavaMoveProcessor().getCommonParentForInputElements();
        }

        protected IJavaScriptElement[] getJavaElements() {
            return this.getJavaMoveProcessor().getJavaElements();
        }

        protected IResource[] getResources() {
            return this.getJavaMoveProcessor().getResources();
        }

        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getJavaMoveProcessor();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getJavaMoveProcessor().wasCanceled();
        }

        protected RefactoringStatus verifyDestination(Object selected) throws JavaScriptModelException {
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            RefactoringStatus refactoringStatus = selected instanceof IJavaScriptElement ? processor.setDestination((IJavaScriptElement)selected) : (selected instanceof IResource ? processor.setDestination((IResource)selected) : RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.ReorgMoveWizard_4));
            this.updateUIStatus();
            this.fDestination = selected;
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setForcePreviewReview(false);
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (this.fReferenceCheckbox != null) {
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                processor.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
            }
            if (this.fQualifiedNameCheckbox != null) {
                boolean enabled = processor.canEnableQualifiedNameUpdating();
                this.fQualifiedNameCheckbox.setEnabled(enabled);
                if (enabled) {
                    this.fQualifiedNameComponent.setEnabled(processor.getUpdateQualifiedNames());
                    if (processor.getUpdateQualifiedNames()) {
                        this.getRefactoringWizard().setForcePreviewReview(true);
                    }
                } else {
                    this.fQualifiedNameComponent.setEnabled(false);
                }
                processor.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite result) {
            final JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (!processor.canUpdateReferences()) {
                return;
            }
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(ReorgMessages.JdtMoveAction_update_references);
            this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    processor.setUpdateReferences(((Button)e.widget).getSelection());
                    MoveInputPage.this.updateUIStatus();
                }
            });
        }

        private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
            final JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (!processor.canEnableQualifiedNameUpdating() || !processor.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(parent, 32);
            int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.RenameInputWizardPage_update_qualified_names);
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(processor.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, processor, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            this.updateQualifiedNameUpdating(processor, processor.getUpdateQualifiedNames());
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.widget).getSelection();
                    MoveInputPage.this.updateQualifiedNameUpdating(processor, enabled);
                }
            });
        }

        private void updateQualifiedNameUpdating(JavaMoveProcessor processor, boolean enabled) {
            this.fQualifiedNameComponent.setEnabled(enabled);
            processor.setUpdateQualifiedNames(enabled);
            this.updateUIStatus();
        }

        public void createControl(Composite parent) {
            Composite result;
            boolean showDestinationTree;
            boolean bl = showDestinationTree = !this.getJavaMoveProcessor().hasDestinationSet();
            if (showDestinationTree) {
                this.fCreateTargetQuery = this.getJavaMoveProcessor().getCreateTargetQuery();
                super.createControl(parent);
                this.getTreeViewer().getTree().setFocus();
                result = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)parent);
                result = new Composite(parent, 0);
                this.setControl((Control)result);
                result.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)result);
            }
            this.addUpdateReferenceComponent(result);
            this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
            this.setControl((Control)result);
            Dialog.applyDialogFont((Control)result);
        }

        protected Control addLabel(Composite parent) {
            if (this.fCreateTargetQuery != null) {
                Composite firstLine = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                firstLine.setLayout((Layout)layout);
                firstLine.setLayoutData((Object)new GridData(768));
                Control label = super.addLabel(firstLine);
                label.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 128 && e.doit) {
                            e.detail = 0;
                            MoveInputPage.this.getTreeViewer().getTree().setFocus();
                        }
                    }
                });
                Button newButton = new Button(firstLine, 8);
                newButton.setText(this.fCreateTargetQuery.getNewButtonLabel());
                GridData gd = new GridData(642);
                gd.widthHint = SWTUtil.getButtonWidthHint(newButton);
                newButton.setLayoutData((Object)gd);
                newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MoveInputPage.this.doNewButtonPressed();
                    }
                });
                return firstLine;
            }
            return super.addLabel(parent);
        }

        private boolean canUpdateReferences() {
            return this.getJavaMoveProcessor().canUpdateReferences();
        }

        private void doNewButtonPressed() {
            Object newElement = this.fCreateTargetQuery.getCreatedTarget(this.fDestination);
            if (newElement != null) {
                TreeViewer viewer = this.getTreeViewer();
                ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
                viewer.refresh(contentProvider.getParent(newElement));
                viewer.setSelection((ISelection)new StructuredSelection(newElement), true);
                viewer.getTree().setFocus();
            }
        }
    }
}

