/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class BufferedDocumentScanner
implements ICharacterScanner {
    private IDocument fDocument;
    private int fRangeOffset;
    private int fRangeLength;
    private char[][] fDelimiters;
    private final char[] fBuffer;
    private int fBufferOffset;
    private int fBufferLength;
    private int fOffset;

    public BufferedDocumentScanner(int size) {
        Assert.isTrue((size >= 1 ? 1 : 0) != 0);
        this.fBuffer = new char[size];
    }

    private final void updateBuffer(int offset) {
        this.fBufferOffset = offset;
        this.fBufferLength = this.fBufferOffset + this.fBuffer.length > this.fRangeOffset + this.fRangeLength ? this.fRangeLength - (this.fBufferOffset - this.fRangeOffset) : this.fBuffer.length;
        try {
            String content = this.fDocument.get(this.fBufferOffset, this.fBufferLength);
            content.getChars(0, this.fBufferLength, this.fBuffer, 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public final void setRange(IDocument document, int offset, int length) {
        this.fDocument = document;
        this.fRangeOffset = offset;
        this.fRangeLength = length;
        String[] delimiters = document.getLegalLineDelimiters();
        this.fDelimiters = new char[delimiters.length][];
        int i = 0;
        while (i < delimiters.length) {
            this.fDelimiters[i] = delimiters[i].toCharArray();
            ++i;
        }
        this.updateBuffer(offset);
        this.fOffset = 0;
    }

    public final int read() {
        if (this.fOffset == this.fBufferLength) {
            int end = this.fBufferOffset + this.fBufferLength;
            if (end == this.fDocument.getLength() || end == this.fRangeOffset + this.fRangeLength) {
                return -1;
            }
            this.updateBuffer(this.fBufferOffset + this.fBufferLength);
            this.fOffset = 0;
        }
        try {
            return this.fBuffer[this.fOffset++];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            StringBuffer buf = new StringBuffer();
            buf.append("Detailed state of 'BufferedDocumentScanner:'");
            buf.append("\n\tfOffset= ");
            buf.append(this.fOffset);
            buf.append("\n\tfBufferOffset= ");
            buf.append(this.fBufferOffset);
            buf.append("\n\tfBufferLength= ");
            buf.append(this.fBufferLength);
            buf.append("\n\tfRangeOffset= ");
            buf.append(this.fRangeOffset);
            buf.append("\n\tfRangeLength= ");
            buf.append(this.fRangeLength);
            JavaScriptPlugin.logErrorMessage(buf.toString());
            throw ex;
        }
    }

    public final void unread() {
        if (this.fOffset == 0) {
            if (this.fBufferOffset != this.fRangeOffset) {
                this.updateBuffer(this.fBufferOffset - this.fBuffer.length);
                this.fOffset = this.fBuffer.length - 1;
            }
        } else {
            --this.fOffset;
        }
    }

    public final int getColumn() {
        try {
            int offset = this.fBufferOffset + this.fOffset;
            int line = this.fDocument.getLineOfOffset(offset);
            int start = this.fDocument.getLineOffset(line);
            return offset - start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public final char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }
}

