/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class ASTResolving {
    private static final PrimitiveType.Code[] CODE_ORDER = new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.LONG, PrimitiveType.FLOAT, PrimitiveType.DOUBLE};

    public static ITypeBinding guessBindingForReference(ASTNode node) {
        return Bindings.normalizeTypeBinding(ASTResolving.getPossibleReferenceBinding(node));
    }

    private static ITypeBinding getPossibleReferenceBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 7: {
                Assignment assignment = (Assignment)parent;
                if (node.equals((Object)assignment.getLeftHandSide())) {
                    return assignment.getRightHandSide().resolveTypeBinding();
                }
                return assignment.getLeftHandSide().resolveTypeBinding();
            }
            case 27: {
                InfixExpression infix = (InfixExpression)parent;
                InfixExpression.Operator op = infix.getOperator();
                if (op == InfixExpression.Operator.CONDITIONAL_AND || op == InfixExpression.Operator.CONDITIONAL_OR) {
                    return infix.getAST().resolveWellKnownType("boolean");
                }
                if (op == InfixExpression.Operator.LEFT_SHIFT || op == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED || op == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                    return infix.getAST().resolveWellKnownType("int");
                }
                if (node.equals((Object)infix.getLeftOperand())) {
                    ITypeBinding rigthHandBinding = infix.getRightOperand().resolveTypeBinding();
                    if (rigthHandBinding != null) {
                        return rigthHandBinding;
                    }
                } else {
                    ITypeBinding leftHandBinding = infix.getLeftOperand().resolveTypeBinding();
                    if (leftHandBinding != null) {
                        return leftHandBinding;
                    }
                }
                if (op == InfixExpression.Operator.EQUALS || op == InfixExpression.Operator.NOT_EQUALS) break;
                return infix.getAST().resolveWellKnownType("int");
            }
            case 62: {
                InstanceofExpression instanceofExpression = (InstanceofExpression)parent;
                return instanceofExpression.getRightOperand().resolveBinding();
            }
            case 59: {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                if (!frag.getInitializer().equals((Object)node)) break;
                return frag.getName().resolveTypeBinding();
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
                IFunctionBinding superMethodBinding = ASTNodes.getMethodBinding((Name)superMethodInvocation.getName());
                if (superMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superMethodInvocation.arguments(), superMethodBinding);
            }
            case 32: {
                FunctionInvocation methodInvocation = (FunctionInvocation)parent;
                IFunctionBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, methodInvocation.arguments(), methodBinding);
            }
            case 46: {
                SuperConstructorInvocation superInvocation = (SuperConstructorInvocation)parent;
                IFunctionBinding superBinding = superInvocation.resolveConstructorBinding();
                if (superBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superInvocation.arguments(), superBinding);
            }
            case 17: {
                ConstructorInvocation constrInvocation = (ConstructorInvocation)parent;
                IFunctionBinding constrBinding = constrInvocation.resolveConstructorBinding();
                if (constrBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, constrInvocation.arguments(), constrBinding);
            }
            case 14: {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                IFunctionBinding creationBinding = creation.resolveConstructorBinding();
                if (creationBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, creation.arguments(), creationBinding);
            }
            case 36: {
                return ASTResolving.guessBindingForReference(parent);
            }
            case 2: {
                if (((ArrayAccess)parent).getIndex().equals((Object)node)) {
                    return parent.getAST().resolveWellKnownType("int");
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 3: {
                if (!((ArrayCreation)parent).dimensions().contains(node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 4: {
                ASTNode initializerParent = parent.getParent();
                int dim = 1;
                while (initializerParent instanceof ArrayInitializer) {
                    initializerParent = initializerParent.getParent();
                    ++dim;
                }
                ArrayType creationType = null;
                if (initializerParent instanceof ArrayCreation) {
                    creationType = ((ArrayCreation)initializerParent).getType();
                } else if (initializerParent instanceof VariableDeclaration) {
                    VariableDeclaration varDecl = (VariableDeclaration)initializerParent;
                    creationType = ASTNodes.getType(varDecl);
                    dim -= varDecl.getExtraDimensions();
                }
                if (creationType == null) break;
                while (creationType instanceof ArrayType && dim > 0) {
                    creationType = creationType.getComponentType();
                    --dim;
                }
                return creationType.resolveBinding();
            }
            case 16: {
                ConditionalExpression expression = (ConditionalExpression)parent;
                if (node.equals((Object)expression.getExpression())) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                if (node.equals((Object)expression.getElseExpression())) {
                    return expression.getThenExpression().resolveTypeBinding();
                }
                return expression.getElseExpression().resolveTypeBinding();
            }
            case 37: {
                return parent.getAST().resolveWellKnownType("int");
            }
            case 38: {
                if (((PrefixExpression)parent).getOperator() == PrefixExpression.Operator.NOT) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                return parent.getAST().resolveWellKnownType("int");
            }
            case 19: 
            case 25: 
            case 61: {
                if (!(node instanceof Expression)) break;
                return parent.getAST().resolveWellKnownType("boolean");
            }
            case 50: {
                if (!((SwitchStatement)parent).getExpression().equals((Object)node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 41: {
                FunctionDeclaration decl = ASTResolving.findParentMethodDeclaration(parent);
                if (decl == null || decl.isConstructor()) break;
                return decl.getReturnType2() != null ? decl.getReturnType2().resolveBinding() : null;
            }
            case 12: 
            case 53: {
                return parent.getAST().resolveWellKnownType("java.lang.Exception");
            }
            case 22: {
                if (!node.equals((Object)((FieldAccess)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 47: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 40: {
                if (!node.equals((Object)((QualifiedName)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 49: {
                if (!node.equals((Object)((SwitchCase)parent).getExpression()) || !(parent.getParent() instanceof SwitchStatement)) break;
                return ((SwitchStatement)parent.getParent()).getExpression().resolveTypeBinding();
            }
        }
        return null;
    }

    public static Type guessTypeForReference(AST ast, ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 59: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 44: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 2: {
                    Type type;
                    if (!((ArrayAccess)parent).getIndex().equals((Object)node) && (type = ASTResolving.guessTypeForReference(ast, parent)) != null) {
                        return ast.newArrayType(type);
                    }
                    return null;
                }
                case 22: {
                    if (node.equals((Object)((FieldAccess)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                case 36: 
                case 47: {
                    node = parent;
                    parent = parent.getParent();
                    break;
                }
                case 40: {
                    if (node.equals((Object)((QualifiedName)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static ITypeBinding getParameterTypeBinding(ASTNode node, List args, IFunctionBinding binding) {
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        int index = args.indexOf(node);
        if (binding.isVarargs() && index >= paramTypes.length - 1) {
            return paramTypes[paramTypes.length - 1].getComponentType();
        }
        if (index >= 0 && index < paramTypes.length) {
            return paramTypes[index];
        }
        return null;
    }

    public static ITypeBinding guessBindingForTypeReference(ASTNode node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        if (locationInParent == SimpleType.NAME_PROPERTY) {
            node = node.getParent();
        }
        ITypeBinding binding = Bindings.normalizeTypeBinding(ASTResolving.getPossibleTypeBinding(node));
        return binding;
    }

    private static ITypeBinding getPossibleTypeBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 5: {
                int dim = 1;
                while (parent.getParent() instanceof ArrayType) {
                    parent = parent.getParent();
                    ++dim;
                }
                ITypeBinding parentBinding = ASTResolving.getPossibleTypeBinding(parent);
                if (parentBinding != null && parentBinding.getDimensions() == dim) {
                    return parentBinding.getElementType();
                }
                return null;
            }
            case 75: {
                ITypeBinding parentBinding = ASTResolving.getPossibleTypeBinding(parent);
                if (parentBinding == null || !parentBinding.isMember()) {
                    return null;
                }
                if (node.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return parentBinding.getDeclaringClass();
                }
                return parentBinding;
            }
            case 60: {
                return ASTResolving.guessVariableType(((VariableDeclarationStatement)parent).fragments());
            }
            case 23: {
                return ASTResolving.guessVariableType(((FieldDeclaration)parent).fragments());
            }
            case 58: {
                return ASTResolving.guessVariableType(((VariableDeclarationExpression)parent).fragments());
            }
            case 44: {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)parent;
                if (varDecl.getInitializer() == null) break;
                return Bindings.normalizeTypeBinding(varDecl.getInitializer().resolveTypeBinding());
            }
            case 3: {
                ArrayCreation creation = (ArrayCreation)parent;
                if (creation.getInitializer() != null) {
                    return creation.getInitializer().resolveTypeBinding();
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 57: {
                return ((TypeLiteral)parent).getType().resolveBinding();
            }
            case 14: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 65: {
                List thrownExcpetions;
                ASTNode methNode;
                TagElement tagElement = (TagElement)parent;
                if (!"@throws".equals(tagElement.getTagName()) && !"@exception".equals(tagElement.getTagName()) || !((methNode = tagElement.getParent().getParent()) instanceof FunctionDeclaration) || (thrownExcpetions = ((FunctionDeclaration)methNode).thrownExceptions()).size() != 1) break;
                return ((Name)thrownExcpetions.get(0)).resolveTypeBinding();
            }
        }
        return null;
    }

    private static ITypeBinding guessVariableType(List fragments) {
        for (VariableDeclarationFragment frag : fragments) {
            if (frag.getInitializer() == null) continue;
            return Bindings.normalizeTypeBinding(frag.getInitializer().resolveTypeBinding());
        }
        return null;
    }

    public static ITypeBinding[] getQualifierGuess(ASTNode searchRoot, final String selector, List arguments, final IBinding context) {
        final int nArgs = arguments.size();
        final ArrayList result = new ArrayList();
        ITypeBinding binding = searchRoot.getAST().resolveWellKnownType("Object");
        IFunctionBinding[] objectMethods = binding.getDeclaredMethods();
        int i = 0;
        while (i < objectMethods.length) {
            IFunctionBinding meth = objectMethods[i];
            if (meth.getName().equals(selector) && meth.getParameterTypes().length == nArgs) {
                return new ITypeBinding[]{binding};
            }
            ++i;
        }
        ASTResolving.visitAllBindings(searchRoot, new TypeBindingVisitor(){
            private HashSet fVisitedBindings = new HashSet(100);

            public boolean visit(ITypeBinding node) {
                if ((node = Bindings.normalizeTypeBinding(node)) == null) {
                    return true;
                }
                if (!this.fVisitedBindings.add(node.getKey())) {
                    return true;
                }
                if (context != null && !ASTResolving.isUseableTypeInContext(node, context, false)) {
                    return true;
                }
                IFunctionBinding[] methods = node.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    IFunctionBinding meth = methods[i];
                    if (meth.getName().equals(selector) && meth.getParameterTypes().length == nArgs) {
                        result.add(node);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result.toArray(new ITypeBinding[result.size()]);
    }

    public static void visitAllBindings(ASTNode astRoot, TypeBindingVisitor visitor) {
        try {
            astRoot.accept((ASTVisitor)new AllBindingsVisitor(visitor));
        }
        catch (AllBindingsVisitor.VisitCancelledException visitCancelledException) {
            // empty catch block
        }
    }

    public static IBinding getParentMethodOrTypeBinding(ASTNode node) {
        do {
            if (node instanceof FunctionDeclaration) {
                return ((FunctionDeclaration)node).resolveBinding();
            }
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (!(node instanceof AnonymousClassDeclaration)) continue;
            return ((AnonymousClassDeclaration)node).resolveBinding();
        } while ((node = node.getParent()) != null);
        return null;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode node) {
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        return (BodyDeclaration)node;
    }

    public static ASTNode findParentBodyDeclaration(ASTNode node, boolean treatModifiersOutside) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof BodyDeclaration) {
                BodyDeclaration decl = (BodyDeclaration)node;
                if (!treatModifiersOutside || lastLocation != decl.getModifiersProperty()) {
                    return decl;
                }
                treatModifiersOutside = false;
            } else if (node instanceof JavaScriptUnit) {
                return node;
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return node;
    }

    public static JavaScriptUnit findParentCompilationUnit(ASTNode node) {
        return (JavaScriptUnit)ASTResolving.findAncestor(node, 15);
    }

    public static ASTNode findParentType(ASTNode node, boolean treatModifiersOutside) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)node;
                if (!treatModifiersOutside || lastLocation != decl.getModifiersProperty()) {
                    return decl;
                }
            } else if (node instanceof AnonymousClassDeclaration) {
                return node;
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return null;
    }

    public static ASTNode findParentType(ASTNode node) {
        return ASTResolving.findParentType(node, false);
    }

    public static ASTNode findParent(ASTNode node) {
        while (node != null) {
            if (node instanceof JavaScriptUnit) {
                return node;
            }
            if (node instanceof AbstractTypeDeclaration) {
                return node;
            }
            if (node instanceof AnonymousClassDeclaration) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static FunctionDeclaration findParentMethodDeclaration(ASTNode node) {
        while (node != null) {
            if (node.getNodeType() == 31) {
                return (FunctionDeclaration)node;
            }
            if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
                return null;
            }
            node = node.getParent();
        }
        return null;
    }

    public static ASTNode findAncestor(ASTNode node, int nodeType) {
        while (node != null && node.getNodeType() != nodeType) {
            node = node.getParent();
        }
        return node;
    }

    public static Statement findParentStatement(ASTNode node) {
        while (node != null && !(node instanceof Statement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (Statement)node;
    }

    public static TryStatement findParentTryStatement(ASTNode node) {
        while (node != null && !(node instanceof TryStatement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (TryStatement)node;
    }

    public static boolean isInsideConstructorInvocation(FunctionDeclaration methodDeclaration, ASTNode node) {
        Statement statement;
        return methodDeclaration.isConstructor() && ((statement = ASTResolving.findParentStatement(node)) instanceof ConstructorInvocation || statement instanceof SuperConstructorInvocation);
    }

    public static boolean isInsideModifiers(ASTNode node) {
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        return false;
    }

    public static boolean isInStaticContext(ASTNode selectedNode) {
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof FunctionDeclaration) {
            if (ASTResolving.isInsideConstructorInvocation((FunctionDeclaration)decl, selectedNode)) {
                return true;
            }
            return Modifier.isStatic((int)decl.getModifiers());
        }
        if (decl instanceof Initializer) {
            return Modifier.isStatic((int)((Initializer)decl).getModifiers());
        }
        if (decl instanceof FieldDeclaration) {
            return Modifier.isStatic((int)((FieldDeclaration)decl).getModifiers());
        }
        return false;
    }

    public static boolean isWriteAccess(Name selectedNode) {
        Name curr = selectedNode;
        ASTNode parent = curr.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 40: {
                    if (((QualifiedName)parent).getQualifier() != curr) break;
                    return false;
                }
                case 22: {
                    if (((FieldAccess)parent).getExpression() != curr) break;
                    return false;
                }
                case 47: {
                    break;
                }
                case 7: {
                    return ((Assignment)parent).getLeftHandSide() == curr;
                }
                case 44: 
                case 59: {
                    return ((VariableDeclaration)parent).getName() == curr;
                }
                case 37: 
                case 38: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            curr = parent;
            parent = curr.getParent();
        }
        return false;
    }

    public static int getPossibleTypeKinds(ASTNode node, boolean is50OrHigher) {
        int kinds = ASTResolving.internalGetPossibleTypeKinds(node);
        if (!is50OrHigher) {
            kinds &= 6;
        }
        return kinds;
    }

    private static int internalGetPossibleTypeKinds(ASTNode node) {
        int kind = 126;
        int mask = 254;
        ASTNode parent = node.getParent();
        while (parent instanceof QualifiedName) {
            if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
                return 30;
            }
            node = parent;
            parent = parent.getParent();
            mask = 30;
        }
        while (parent instanceof Type) {
            if (parent instanceof QualifiedType) {
                if (node.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return mask & 0x1E;
                }
                mask &= 0x1E;
            }
            node = parent;
            parent = parent.getParent();
        }
        switch (parent.getNodeType()) {
            case 55: {
                if (node.getLocationInParent() != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) break;
                kind = 2;
                break;
            }
            case 31: {
                if (node.getLocationInParent() == FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
                    kind = 2;
                    break;
                }
                if (node.getLocationInParent() != FunctionDeclaration.RETURN_TYPE2_PROPERTY) break;
                kind = 254;
                break;
            }
            case 62: {
                kind = 30;
                break;
            }
            case 53: {
                kind = 2;
                break;
            }
            case 14: {
                if (((ClassInstanceCreation)parent).getAnonymousClassDeclaration() == null) {
                    kind = 2;
                    break;
                }
                kind = 6;
                break;
            }
            case 44: {
                int superParent = parent.getParent().getNodeType();
                if (superParent != 12) break;
                kind = 2;
                break;
            }
            case 65: {
                kind = 30;
                break;
            }
            case 57: {
                kind = 30;
            }
        }
        return kind & mask;
    }

    public static String getFullName(Name name) {
        return name.getFullyQualifiedName();
    }

    public static IJavaScriptUnit findCompilationUnitForBinding(IJavaScriptUnit cu, JavaScriptUnit astRoot, ITypeBinding binding) throws JavaScriptModelException {
        if (binding == null || !binding.isFromSource()) {
            return null;
        }
        ASTNode node = astRoot.findDeclaringNode((IBinding)binding.getTypeDeclaration());
        if (node == null) {
            IJavaScriptUnit targetCU = Bindings.findCompilationUnit(binding, cu.getJavaScriptProject());
            if (targetCU != null) {
                return targetCU;
            }
            return null;
        }
        if (node instanceof JavaScriptUnit || node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
            return cu;
        }
        return null;
    }

    public static ITypeBinding[] getNarrowingTypes(AST ast, ITypeBinding type) {
        ArrayList<ITypeBinding> res = new ArrayList<ITypeBinding>();
        res.add(type);
        if (type.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)type.getName());
            int i = 0;
            while (i < CODE_ORDER.length && code != CODE_ORDER[i]) {
                String typeName = CODE_ORDER[i].toString();
                res.add(ast.resolveWellKnownType(typeName));
                ++i;
            }
        }
        return res.toArray(new ITypeBinding[res.size()]);
    }

    public static ITypeBinding[] getRelaxingTypes(AST ast, ITypeBinding type) {
        ArrayList<ITypeBinding> res = new ArrayList<ITypeBinding>();
        res.add(type);
        if (type.isArray()) {
            res.add(ast.resolveWellKnownType("Object"));
        } else if (type.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)type.getName());
            boolean found = false;
            int i = 0;
            while (i < CODE_ORDER.length) {
                if (found) {
                    String typeName = CODE_ORDER[i].toString();
                    res.add(ast.resolveWellKnownType(typeName));
                }
                if (code == CODE_ORDER[i]) {
                    found = true;
                }
                ++i;
            }
        } else {
            ASTResolving.collectRelaxingTypes(res, type);
        }
        return res.toArray(new ITypeBinding[res.size()]);
    }

    private static void collectRelaxingTypes(Collection res, ITypeBinding type) {
        ITypeBinding binding = type.getSuperclass();
        if (binding != null) {
            if (!res.contains(binding)) {
                res.add(binding);
            }
            ASTResolving.collectRelaxingTypes(res, binding);
        }
    }

    public static String[] getUsedVariableNames(ASTNode node) {
        JavaScriptUnit root = (JavaScriptUnit)node.getRoot();
        Collection res = new ScopeAnalyzer(root).getUsedVariableNames(node.getStartPosition(), node.getLength());
        return res.toArray(new String[res.size()]);
    }

    public static boolean isUseableTypeInContext(ITypeBinding[] binding, IBinding context, boolean noWildcards) {
        int i = 0;
        while (i < binding.length) {
            if (!ASTResolving.isUseableTypeInContext(binding[i], context, noWildcards)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUseableTypeInContext(ITypeBinding type, IBinding context, boolean noWildcards) {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isAnonymous()) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        return true;
    }

    public static String getTypeSignature(ITypeBinding type) {
        return BindingLabelProvider.getBindingLabel((IBinding)type, 0x20000AL);
    }

    public static String getMethodSignature(IFunctionBinding binding, boolean inOtherCU) {
        StringBuffer buf = new StringBuffer();
        if (inOtherCU && !binding.isConstructor()) {
            buf.append(binding.getDeclaringClass().getTypeDeclaration().getName()).append('.');
        }
        return BindingLabelProvider.getBindingLabel((IBinding)binding, 0x20000AL);
    }

    public static String getMethodSignature(String name, ITypeBinding[] params, boolean isVarArgs) {
        StringBuffer buf = new StringBuffer();
        buf.append(name).append('(');
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                buf.append(JavaScriptElementLabels.COMMA_STRING);
            }
            if (isVarArgs && i == params.length - 1) {
                buf.append(ASTResolving.getTypeSignature(params[i].getElementType()));
                buf.append("...");
            } else {
                buf.append(ASTResolving.getTypeSignature(params[i]));
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static JavaScriptUnit createQuickFixAST(IJavaScriptUnit compilationUnit, IProgressMonitor monitor) {
        ASTParser astParser = ASTParser.newParser((int)3);
        astParser.setSource(compilationUnit);
        astParser.setResolveBindings(true);
        astParser.setStatementsRecovery(true);
        astParser.setBindingsRecovery(true);
        return (JavaScriptUnit)astParser.createAST(monitor);
    }

    private static class AllBindingsVisitor
    extends GenericVisitor {
        private final TypeBindingVisitor fVisitor;

        public AllBindingsVisitor(TypeBindingVisitor visitor) {
            super(true);
            this.fVisitor = visitor;
        }

        public boolean visit(SimpleName node) {
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null) {
                boolean res = this.fVisitor.visit(binding);
                if (res) {
                    res = Bindings.visitHierarchy(binding, this.fVisitor);
                }
                if (!res) {
                    throw new VisitCancelledException();
                }
            }
            return false;
        }

        private static class VisitCancelledException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private VisitCancelledException() {
            }
        }
    }
}

