/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class LazyGenericTypeProposal
extends LazyJavaTypeCompletionProposal {
    private static final char[] GENERIC_TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', '<', ' '};
    private IRegion fSelectedRegion;
    private TypeArgumentProposal[] fTypeArgumentProposals;

    public LazyGenericTypeProposal(CompletionProposal typeProposal, JavaContentAssistInvocationContext context) {
        super(typeProposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (this.shouldAppendArguments(document, offset, trigger)) {
            try {
                TypeArgumentProposal[] typeArgumentProposals = this.computeTypeArgumentProposals();
                if (typeArgumentProposals.length > 0) {
                    boolean insertClosingParenthesis;
                    int[] offsets = new int[typeArgumentProposals.length];
                    int[] lengths = new int[typeArgumentProposals.length];
                    StringBuffer buffer = this.createParameterList(typeArgumentProposals, offsets, lengths);
                    boolean bl = insertClosingParenthesis = trigger == '(' && this.autocloseBrackets();
                    if (insertClosingParenthesis) {
                        this.updateReplacementWithParentheses(buffer);
                    }
                    super.setReplacementString(buffer.toString());
                    super.apply(document, '\u0000', offset);
                    if (this.getTextViewer() != null) {
                        if (this.hasAmbiguousProposals(typeArgumentProposals)) {
                            this.adaptOffsets(offsets, buffer);
                            this.installLinkedMode(document, offsets, lengths, typeArgumentProposals, insertClosingParenthesis);
                        } else if (insertClosingParenthesis) {
                            this.setUpLinkedMode(document, ')');
                        } else {
                            this.fSelectedRegion = new Region(this.getReplacementOffset() + this.getReplacementString().length(), 0);
                        }
                    }
                    return;
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        super.apply(document, trigger, offset);
    }

    protected char[] computeTriggerCharacters() {
        return GENERIC_TYPE_TRIGGERS;
    }

    private void adaptOffsets(int[] offsets, StringBuffer buffer) {
        String replacementString = this.getReplacementString();
        int delta = buffer.length() - replacementString.length();
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - delta;
        }
    }

    private TypeArgumentProposal[] computeTypeArgumentProposals() throws JavaScriptModelException {
        if (this.fTypeArgumentProposals == null) {
            IType type = (IType)this.getJavaElement();
            if (type == null) {
                return new TypeArgumentProposal[0];
            }
            return new TypeArgumentProposal[0];
        }
        return this.fTypeArgumentProposals;
    }

    private boolean shouldAppendArguments(IDocument document, int offset, char trigger) {
        int index;
        String line;
        block6: {
            if (trigger != '\u0000' && trigger != '<' && trigger != '(') {
                return false;
            }
            char[] completion = this.fProposal.getCompletion();
            if (completion.length == 0) {
                return false;
            }
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                line = document.get(region.getOffset(), region.getLength());
                index = offset - region.getOffset();
                while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                    ++index;
                }
                if (index != line.length()) break block6;
                return true;
            }
            catch (BadLocationException e) {
                return true;
            }
        }
        char ch = line.charAt(index);
        return ch != '<';
    }

    private StringBuffer createParameterList(TypeArgumentProposal[] typeArguments, int[] offsets, int[] lengths) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getReplacementString());
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        int LESS = 60;
        int GREATER = 62;
        if (prefs.beforeOpeningBracket) {
            buffer.append(" ");
        }
        buffer.append('<');
        if (prefs.afterOpeningBracket) {
            buffer.append(" ");
        }
        StringBuffer separator = new StringBuffer(3);
        if (prefs.beforeTypeArgumentComma) {
            separator.append(" ");
        }
        separator.append(",");
        if (prefs.afterTypeArgumentComma) {
            separator.append(" ");
        }
        int i = 0;
        while (i != typeArguments.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            offsets[i] = buffer.length();
            buffer.append(typeArguments[i]);
            lengths[i] = buffer.length() - offsets[i];
            ++i;
        }
        if (prefs.beforeClosingBracket) {
            buffer.append(" ");
        }
        buffer.append('>');
        return buffer;
    }

    private void installLinkedMode(IDocument document, int[] offsets, int[] lengths, TypeArgumentProposal[] typeArgumentProposals, boolean withParentheses) {
        int replacementOffset = this.getReplacementOffset();
        String replacementString = this.getReplacementString();
        try {
            LinkedModeModel model = new LinkedModeModel();
            int i = 0;
            while (i != offsets.length) {
                if (typeArgumentProposals[i].isAmbiguous()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, replacementOffset + offsets[i], lengths[i]));
                    model.addGroup(group);
                }
                ++i;
            }
            if (withParentheses) {
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, replacementOffset + this.getCursorPosition(), 0));
                model.addGroup(group);
            }
            model.forceInstall();
            JavaEditor editor = this.getJavaEditor();
            if (editor != null) {
                model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(withParentheses ? (char)')' : '>', document));
            ui.setExitPosition(this.getTextViewer(), replacementOffset + replacementString.length(), 0, Integer.MAX_VALUE);
            ui.setDoContextInfo(true);
            ui.enter();
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    private boolean hasAmbiguousProposals(TypeArgumentProposal[] typeArgumentProposals) {
        boolean hasAmbiguousProposals = false;
        int i = 0;
        while (i < typeArgumentProposals.length) {
            if (typeArgumentProposals[i].isAmbiguous()) {
                hasAmbiguousProposals = true;
                break;
            }
            ++i;
        }
        return hasAmbiguousProposals;
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaScriptPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return super.getSelection(document);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.FilledArgumentNamesMethodProposal_error_msg, (String)e.getMessage());
    }

    protected IContextInformation computeContextInformation() {
        try {
            TypeArgumentProposal[] proposals;
            if (this.hasParameters() && this.hasAmbiguousProposals(proposals = this.computeTypeArgumentProposals())) {
                return new ContextInformation(this);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
        return super.computeContextInformation();
    }

    protected int computeCursorPosition() {
        if (this.fSelectedRegion != null) {
            return this.fSelectedRegion.getOffset() - this.getReplacementOffset();
        }
        return super.computeCursorPosition();
    }

    private boolean hasParameters() {
        IType type = (IType)this.getJavaElement();
        if (type == null) {
            return false;
        }
        return false;
    }

    private static class ContextInformation
    implements IContextInformation,
    IContextInformationExtension {
        private final String fInformationDisplayString;
        private final String fContextDisplayString;
        private final Image fImage;
        private final int fPosition;

        ContextInformation(LazyGenericTypeProposal proposal) {
            this.fContextDisplayString = proposal.getDisplayString();
            this.fInformationDisplayString = this.computeContextString(proposal);
            this.fImage = proposal.getImage();
            this.fPosition = proposal.getReplacementOffset() + proposal.getReplacementString().indexOf(60) + 1;
        }

        public String getContextDisplayString() {
            return this.fContextDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getInformationDisplayString() {
            return this.fInformationDisplayString;
        }

        private String computeContextString(LazyGenericTypeProposal proposal) {
            TypeArgumentProposal[] proposals;
            block5: {
                proposals = proposal.computeTypeArgumentProposals();
                if (proposals.length != 0) break block5;
                return null;
            }
            try {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < proposals.length) {
                    buf.append(proposals[i].getDisplayName());
                    if (i < proposals.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                return buf.toString();
            }
            catch (JavaScriptModelException e) {
                return null;
            }
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextInformation) {
                ContextInformation ci = (ContextInformation)obj;
                return this.getContextInformationPosition() == ci.getContextInformationPosition() && this.getInformationDisplayString().equals(ci.getInformationDisplayString());
            }
            return false;
        }
    }

    private static final class TypeArgumentProposal {
        private final boolean fIsAmbiguous;
        private final String fProposal;
        private final String fTypeDisplayName;

        TypeArgumentProposal(String proposal, boolean ambiguous, String typeDisplayName) {
            this.fIsAmbiguous = ambiguous;
            this.fProposal = proposal;
            this.fTypeDisplayName = typeDisplayName;
        }

        public String getDisplayName() {
            return this.fTypeDisplayName;
        }

        boolean isAmbiguous() {
            return this.fIsAmbiguous;
        }

        String getProposals() {
            return this.fProposal;
        }

        public String toString() {
            return this.fProposal;
        }
    }
}

