/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AnnotationExpansionControl;

public class AnnotationExpandHover
implements IAnnotationHover,
IAnnotationHoverExtension {
    private final IInformationControlCreator fgCreator = new InformationControlCreator();
    protected final IVerticalRulerListener fgListener = new VerticalRulerListener();
    protected CompositeRuler fCompositeRuler;
    protected IDoubleClickListener fDblClickListener;
    protected IAnnotationAccess fAnnotationAccess;

    public AnnotationExpandHover(CompositeRuler ruler, IAnnotationAccess access, IDoubleClickListener doubleClickListener) {
        this.fCompositeRuler = ruler;
        this.fAnnotationAccess = access;
        this.fDblClickListener = doubleClickListener;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int line) {
        return null;
    }

    protected Object getHoverInfoForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = viewer.getAnnotationModel();
        IDocument document = viewer.getDocument();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Annotation annotation = (Annotation)e.next();
            Position position = model.getPosition(annotation);
            if (position == null || this.compareRulerLine(position, document, line) != 1 || this.isDuplicateMessage(messagesAtPosition, position, annotation.getText())) continue;
            exact.add(annotation);
        }
        if (exact.size() < 1) {
            return null;
        }
        this.sort(exact, model);
        if (exact.size() > 0) {
            this.setLastRulerMouseLocation(viewer, line);
        }
        AnnotationExpansionControl.AnnotationHoverInput input = new AnnotationExpansionControl.AnnotationHoverInput();
        input.fAnnotations = exact.toArray(new Annotation[0]);
        input.fViewer = viewer;
        input.fRulerInfo = this.fCompositeRuler;
        input.fAnnotationListener = this.fgListener;
        input.fDoubleClickListener = this.fDblClickListener;
        input.model = model;
        return input;
    }

    protected void sort(List exact, IAnnotationModel model) {
        class AnnotationComparator
        implements Comparator {
            private final /* synthetic */ IAnnotationModel val$model;

            AnnotationComparator(IAnnotationModel iAnnotationModel) {
                this.val$model = iAnnotationModel;
            }

            public int compare(Object o1, Object o2) {
                Annotation a1 = (Annotation)o1;
                Annotation a2 = (Annotation)o2;
                Position p1 = this.val$model.getPosition(a1);
                Position p2 = this.val$model.getPosition(a2);
                if (p1.offset == p2.offset) {
                    return AnnotationExpandHover.this.getOrder(a2) - AnnotationExpandHover.this.getOrder(a1);
                }
                return p1.offset - p2.offset;
            }
        }
        Collections.sort(exact, new AnnotationComparator(model));
    }

    protected int getOrder(Annotation annotation) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)this.fAnnotationAccess;
            return extension.getLayer(annotation);
        }
        return 0;
    }

    protected boolean isDuplicateMessage(Map messagesAtPosition, Position position, String message) {
        if (message == null) {
            return false;
        }
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    protected void setLastRulerMouseLocation(ISourceViewer viewer, int line) {
        StyledText st;
        if (this.fCompositeRuler != null && (st = viewer.getTextWidget()) != null && !st.isDisposed()) {
            if (viewer instanceof ITextViewerExtension5) {
                int widgetLine = ((ITextViewerExtension5)viewer).modelLine2WidgetLine(line);
                Point loc = st.getLocationAtOffset(st.getOffsetAtLine(widgetLine));
                this.fCompositeRuler.setLocationOfLastMouseButtonActivity(0, loc.y);
            } else if (viewer instanceof TextViewer) {
                int widgetLine = ((TextViewer)viewer).modelLine2WidgetLine(line);
                Point loc = st.getLocationAtOffset(st.getOffsetAtLine(widgetLine));
                this.fCompositeRuler.setLocationOfLastMouseButtonActivity(0, loc.y);
            }
        }
    }

    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int firstLine;
            block5: {
                firstLine = document.getLineOfOffset(position.getOffset());
                if (line != firstLine) break block5;
                return 1;
            }
            try {
                if (firstLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return this.fgCreator;
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleLines) {
        return this.getHoverInfoForLine(sourceViewer, lineRange.getStartLine());
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    private class InformationControlCreator
    implements IInformationControlCreator,
    IInformationControlCreatorExtension {
        private InformationControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            return new AnnotationExpansionControl(parent, 0, AnnotationExpandHover.this.fAnnotationAccess);
        }

        public boolean canReuse(IInformationControl control) {
            return control instanceof AnnotationExpansionControl;
        }

        public boolean canReplace(IInformationControlCreator creator) {
            return creator == this;
        }
    }

    private class VerticalRulerListener
    implements IVerticalRulerListener {
        private VerticalRulerListener() {
        }

        public void annotationSelected(VerticalRulerEvent event) {
            AnnotationExpandHover.this.fCompositeRuler.fireAnnotationSelected(event);
        }

        public void annotationDefaultSelected(VerticalRulerEvent event) {
            AnnotationExpandHover.this.fCompositeRuler.fireAnnotationDefaultSelected(event);
        }

        public void annotationContextMenuAboutToShow(VerticalRulerEvent event, Menu menu) {
            AnnotationExpandHover.this.fCompositeRuler.fireAnnotationContextMenuAboutToShow(event, menu);
        }
    }
}

