/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.oaametadata.DocumentedElement;
import org.eclipse.wst.jsdt.internal.oaametadata.Exception;
import org.eclipse.wst.jsdt.internal.oaametadata.Method;
import org.eclipse.wst.jsdt.internal.oaametadata.Parameter;
import org.eclipse.wst.jsdt.internal.oaametadata.VersionableElement;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocMessages;

public class OAADocReader
extends Reader {
    StringReader sr;
    StringBuffer buffer = new StringBuffer();

    public OAADocReader(MetadataFile openable, IMember member) {
        this.getDoc(openable, member);
    }

    private void getDoc(MetadataFile openable, IMember member) {
        Method method;
        DocumentedElement documentation = openable.getDocumentation(member);
        VersionableElement versionableElement = documentation instanceof VersionableElement ? (VersionableElement)documentation : null;
        Method method2 = method = documentation instanceof Method ? (Method)documentation : null;
        if (documentation != null) {
            if (documentation.description != null) {
                this.buffer.append("<p>");
                this.buffer.append(documentation.description);
                this.buffer.append("</p>");
            }
            if (method != null) {
                this.printMethod(method);
            }
        }
        this.buffer.append("</dl>");
        this.sr = new StringReader(this.buffer.toString());
    }

    private void printMethod(Method method) {
        int i;
        this.buffer.append("<dl>");
        if (method.parameters != null && method.parameters.length > 0) {
            this.printSectionHead(JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section);
            i = 0;
            while (i < method.parameters.length) {
                Parameter parameter = method.parameters[i];
                this.buffer.append("<dd>");
                this.buffer.append("<b>").append(parameter.name).append("</b> ");
                if (parameter.description != null) {
                    this.buffer.append(parameter.description);
                }
                this.buffer.append("</dd>");
                ++i;
            }
        }
        if (method.returns != null) {
            this.printSection(JavaDocMessages.JavaDoc2HTMLTextReader_returns_section, method.returns.dataType, method.returns.description);
        }
        if (method.exceptions != null && method.exceptions.length > 0) {
            this.printSectionHead(JavaDocMessages.JavaDoc2HTMLTextReader_throws_section);
            i = 0;
            while (i < method.exceptions.length) {
                Exception exception = method.exceptions[i];
                this.buffer.append("<dd>");
                this.buffer.append(exception.description);
                this.buffer.append("</dd>");
                ++i;
            }
        }
    }

    public void close() throws IOException {
        this.sr.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.sr.read(cbuf, off, len);
    }

    private void printSectionHead(String tag) {
        this.buffer.append("<dt>");
        this.buffer.append(tag);
        this.buffer.append("</dt>");
    }

    private void printSection(String tag, String nameIn, String descriptionIn) {
        String description;
        String name = nameIn != null && nameIn.length() > 0 ? nameIn : null;
        String string = description = descriptionIn != null && descriptionIn.length() > 0 ? descriptionIn : null;
        if (name != null || description != null) {
            this.buffer.append("<dt>");
            this.buffer.append(tag);
            this.buffer.append("<dd>");
            if (name != null) {
                this.buffer.append("<b>").append(name).append("</b>");
            }
            if (description != null) {
                this.buffer.append(description);
            }
            this.buffer.append("</dd>");
            this.buffer.append("</dt>");
        }
    }
}

