/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IRichLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.OwnerDrawSupport;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class ColoredViewersManager
implements IPropertyChangeListener {
    public static final String QUALIFIER_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.qualifier";
    public static final String DECORATIONS_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.decorations";
    public static final String COUNTER_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.counter";
    public static final String INHERITED_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.inherited";
    private static ColoredViewersManager fgInstance = new ColoredViewersManager();
    private Map fManagedViewers = new HashMap();
    private ColorRegistry fColorRegisty = JFaceResources.getColorRegistry();

    public void installColoredLabels(StructuredViewer viewer) {
        if (this.fManagedViewers.containsKey(viewer)) {
            return;
        }
        if (this.fManagedViewers.isEmpty()) {
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.fColorRegisty.addListener((IPropertyChangeListener)this);
        }
        this.fManagedViewers.put(viewer, new ManagedViewer(viewer));
    }

    public void uninstallColoredLabels(StructuredViewer viewer) {
        ManagedViewer mv = (ManagedViewer)this.fManagedViewers.remove(viewer);
        if (mv == null) {
            return;
        }
        if (this.fManagedViewers.isEmpty()) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            this.fColorRegisty.removeListener((IPropertyChangeListener)this);
        }
    }

    public Color getColorForName(String symbolicName) {
        return this.fColorRegisty.get(symbolicName);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(QUALIFIER_COLOR_NAME) || property.equals(COUNTER_COLOR_NAME) || property.equals(DECORATIONS_COLOR_NAME) || property.equals("colored_labels_in_views")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ColoredViewersManager.this.refreshAllViewers();
                }
            });
        }
    }

    protected final void refreshAllViewers() {
        for (ManagedViewer viewer : this.fManagedViewers.values()) {
            viewer.refresh();
        }
    }

    public static boolean showColoredLabels() {
        String preference = PreferenceConstants.getPreference("colored_labels_in_views", null);
        return preference != null && Boolean.valueOf(preference) != false;
    }

    public static void install(StructuredViewer viewer) {
        fgInstance.installColoredLabels(viewer);
    }

    private class ManagedViewer
    implements DisposeListener {
        private static final String COLORED_LABEL_KEY = "coloredlabel";
        private StructuredViewer fViewer;
        private OwnerDrawSupport fOwnerDrawSupport;

        private ManagedViewer(StructuredViewer viewer) {
            this.fViewer = viewer;
            this.fOwnerDrawSupport = null;
            this.fViewer.getControl().addDisposeListener((DisposeListener)this);
            if (ColoredViewersManager.showColoredLabels()) {
                this.installOwnerDraw();
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            ColoredViewersManager.this.uninstallColoredLabels(this.fViewer);
        }

        public final void refresh() {
            Control control = this.fViewer.getControl();
            if (!control.isDisposed()) {
                if (ColoredViewersManager.showColoredLabels()) {
                    this.installOwnerDraw();
                } else {
                    this.uninstallOwnerDraw();
                }
            }
        }

        protected void installOwnerDraw() {
            if (this.fOwnerDrawSupport == null) {
                this.fOwnerDrawSupport = new OwnerDrawSupport(this.fViewer.getControl()){

                    public ColoredString getColoredLabel(Item item) {
                        return ManagedViewer.this.getColoredLabelForView(item);
                    }

                    public Color getColor(String foregroundColorName, Display display) {
                        return ColoredViewersManager.this.getColorForName(foregroundColorName);
                    }
                };
            }
            this.refreshViewer();
        }

        protected void uninstallOwnerDraw() {
            if (this.fOwnerDrawSupport == null) {
                return;
            }
            this.fOwnerDrawSupport.dispose();
            this.fOwnerDrawSupport = null;
            this.refreshViewer();
        }

        private void refreshViewer() {
            Control control = this.fViewer.getControl();
            if (!control.isDisposed()) {
                if (control instanceof Tree) {
                    this.refresh((Item[])((Tree)control).getItems());
                } else if (control instanceof Table) {
                    this.refresh((Item[])((Table)control).getItems());
                }
            }
        }

        private void refresh(Item[] items) {
            int i = 0;
            while (i < items.length) {
                Item item = items[i];
                item.setData(COLORED_LABEL_KEY, null);
                String text = item.getText();
                item.setText("");
                item.setText(text);
                if (item instanceof TreeItem) {
                    this.refresh((Item[])((TreeItem)item).getItems());
                }
                ++i;
            }
        }

        private ColoredString getColoredLabelForView(Item item) {
            ColoredString oldLabel = (ColoredString)item.getData(COLORED_LABEL_KEY);
            String itemText = item.getText();
            if (oldLabel != null && oldLabel.getString().equals(itemText)) {
                return oldLabel;
            }
            ColoredString newLabel = null;
            IBaseLabelProvider labelProvider = this.fViewer.getLabelProvider();
            if (labelProvider instanceof IRichLabelProvider) {
                newLabel = ((IRichLabelProvider)labelProvider).getRichTextLabel(item.getData());
            }
            if (newLabel == null) {
                newLabel = new ColoredString(itemText);
            } else if (!newLabel.getString().equals(itemText)) {
                newLabel = ColoredJavaElementLabels.decorateColoredString(newLabel, itemText, ColoredJavaElementLabels.DECORATIONS_STYLE);
            }
            item.setData(COLORED_LABEL_KEY, (Object)newLabel);
            return newLabel;
        }
    }
}

