/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.CorrectionEngine;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class UserLibraryMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        return id == 963 || id == 965 || id == 962 || id == 1010 || id == 964;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        final Shell shell = JavaScriptPlugin.getActiveWorkbenchShell();
        if (!this.hasResolutions(marker) || shell == null) {
            return NO_RESOLUTION;
        }
        ArrayList<Object> resolutions = new ArrayList<Object>();
        IJavaScriptProject project = this.getJavaProject(marker);
        int id = marker.getAttribute("id", -1);
        if (id == 963) {
            Image image;
            String label;
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            Path path = new Path(arguments[0]);
            if (path.segment(0).equals("org.eclipse.wst.jsdt.USER_LIBRARY")) {
                label = NewWizardMessages.UserLibraryMarkerResolutionGenerator_changetouserlib_label;
                image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_rename.png");
                resolutions.add(new UserLibraryMarkerResolution(label, image, (IPath)path, project){
                    private final /* synthetic */ IPath val$path;
                    private final /* synthetic */ IJavaScriptProject val$project;
                    {
                        this.val$path = iPath;
                        this.val$project = iJavaScriptProject;
                        super($anonymous0, $anonymous1);
                    }

                    public void run(IMarker m) {
                        UserLibraryMarkerResolutionGenerator.this.changeToExistingLibrary(shell, this.val$path, false, this.val$project);
                    }
                });
                if (path.segmentCount() == 2) {
                    String label2 = Messages.format(NewWizardMessages.UserLibraryMarkerResolutionGenerator_createuserlib_label, path.segment(1));
                    Image image2 = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.add_correction.png");
                    resolutions.add(new UserLibraryMarkerResolution(label2, image2, (IPath)path, project){
                        private final /* synthetic */ IPath val$path;
                        private final /* synthetic */ IJavaScriptProject val$project;
                        {
                            this.val$path = iPath;
                            this.val$project = iJavaScriptProject;
                            super($anonymous0, $anonymous1);
                        }

                        public void run(IMarker m) {
                            UserLibraryMarkerResolutionGenerator.this.createUserLibrary(shell, this.val$path, this.val$project);
                        }
                    });
                }
            }
            label = NewWizardMessages.UserLibraryMarkerResolutionGenerator_changetoother;
            image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_rename.png");
            resolutions.add(new UserLibraryMarkerResolution(label, image, (IPath)path, project){
                private final /* synthetic */ IPath val$path;
                private final /* synthetic */ IJavaScriptProject val$project;
                {
                    this.val$path = iPath;
                    this.val$project = iJavaScriptProject;
                    super($anonymous0, $anonymous1);
                }

                public void run(IMarker m) {
                    UserLibraryMarkerResolutionGenerator.this.changeToExistingLibrary(shell, this.val$path, true, this.val$project);
                }
            });
        }
        if (project != null) {
            resolutions.add(new OpenBuildPathMarkerResolution(project));
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    protected void changeToExistingLibrary(Shell shell, IPath path, boolean isNew, final IJavaScriptProject project) {
        try {
            IIncludePathEntry[] res;
            IIncludePathEntry[] entries = project.getRawIncludepath();
            int idx = this.indexOfClasspath(entries, path);
            if (idx == -1) {
                return;
            }
            if (isNew) {
                res = BuildPathDialogAccess.chooseContainerEntries(shell, project, entries);
                if (res == null) {
                    return;
                }
            } else {
                IIncludePathEntry resEntry = BuildPathDialogAccess.configureContainerEntry(shell, entries[idx], project, entries);
                if (resEntry == null) {
                    return;
                }
                res = new IIncludePathEntry[]{resEntry};
            }
            final IIncludePathEntry[] newEntries = new IIncludePathEntry[entries.length - 1 + res.length];
            System.arraycopy(entries, 0, newEntries, 0, idx);
            System.arraycopy(res, 0, newEntries, idx, res.length);
            System.arraycopy(entries, idx + 1, newEntries, idx + res.length, entries.length - idx - 1);
            IWorkbenchWindow context = JavaScriptPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawIncludepath(newEntries, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (JavaScriptModelException e) {
            String title = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_title;
            String message = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, message);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_title;
            String message = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_applyingfailed_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int indexOfClasspath(IIncludePathEntry[] entries, IPath path) {
        int i = 0;
        while (i < entries.length) {
            IIncludePathEntry curr = entries[i];
            if (curr.getEntryKind() == 5 && curr.getPath().equals((Object)path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void createUserLibrary(Shell shell, IPath unboundPath, IJavaScriptProject project) {
        String name = unboundPath.segment(1);
        String id = "org.eclipse.wst.jsdt.ui.preferences.UserLibraryPreferencePage";
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("select_library", name);
        data.put("do_create", Boolean.TRUE);
        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)id, (String[])new String[]{id}, data).open();
    }

    private IJavaScriptProject getJavaProject(IMarker marker) {
        return JavaScriptCore.create((IProject)marker.getResource().getProject());
    }

    private static class OpenBuildPathMarkerResolution
    implements IMarkerResolution2 {
        private IJavaScriptProject fProject;

        public OpenBuildPathMarkerResolution(IJavaScriptProject project) {
            this.fProject = project;
        }

        public String getDescription() {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_description, this.fProject.getElementName());
        }

        public Image getImage() {
            return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.access_restriction_attrib.gif");
        }

        public String getLabel() {
            return CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label;
        }

        public void run(IMarker marker) {
            PreferencesUtil.createPropertyDialogOn((Shell)JavaScriptPlugin.getActiveWorkbenchShell(), (IAdaptable)this.fProject, (String)"org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
        }
    }

    private static abstract class UserLibraryMarkerResolution
    implements IMarkerResolution,
    IMarkerResolution2 {
        private String fLabel;
        private Image fImage;

        public UserLibraryMarkerResolution(String label, Image image) {
            this.fLabel = label;
            this.fImage = image;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return this.fImage;
        }
    }
}

