/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.AttachingConnector;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.Connector;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.ListeningConnector;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.launching.JavaScriptProcess;
import org.eclipse.wst.jsdt.debug.internal.core.launching.Messages;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class RemoteJavaScriptLaunchDelegate
extends LaunchConfigurationDelegate {
    static final String LAUNCH_URI = "launch_uri";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.launching_js_debug_delegate, (int)16);
        try {
            String name = configuration.getAttribute("connector_id", null);
            Map argmap = configuration.getAttribute("argument_map", null);
            if (argmap == null) {
                Status status = new Status(4, "org.eclipse.wst.jsdt.debug.core", Messages.argument_map_null);
                throw new CoreException((IStatus)status);
            }
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(4);
            localmonitor.subTask(Messages.acquiring_connector);
            Connector connector = JavaScriptDebugPlugin.getConnectionsManager().getConnector(name);
            VirtualMachine vm = null;
            if (localmonitor.isCanceled()) {
                return;
            }
            if (connector instanceof AttachingConnector) {
                localmonitor.subTask(Messages.attaching_to_vm);
            } else if (connector instanceof ListeningConnector) {
                localmonitor.subTask(Messages.waiting_for_vm_to_connect);
            } else {
                Status status = new Status(4, "org.eclipse.wst.jsdt.debug.core", NLS.bind((String)Messages.could_not_locate_connector, (Object[])new String[]{name}));
                throw new CoreException((IStatus)status);
            }
            localmonitor.worked(4);
            ConnectRunnable runnable = new ConnectRunnable(connector, argmap);
            Thread thread = new Thread((Runnable)runnable, Messages.connect_thread);
            thread.setDaemon(true);
            thread.start();
            while (thread.isAlive()) {
                if (localmonitor.isCanceled()) {
                    if (vm != null) {
                        vm.terminate();
                    }
                    thread.interrupt();
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (runnable.exception != null) {
                Status status = new Status(4, "org.eclipse.wst.jsdt.debug.core", "Error occured while launching", (Throwable)runnable.exception);
                throw new CoreException((IStatus)status);
            }
            if (localmonitor.isCanceled()) {
                return;
            }
            if (runnable.vm == null) {
                Status status = new Status(4, "org.eclipse.wst.jsdt.debug.core", "Failed to connect to virtual machine", (Throwable)runnable.exception);
                throw new CoreException((IStatus)status);
            }
            vm = runnable.vm;
            localmonitor.worked(4);
            localmonitor.subTask(Messages.creating_debug_target);
            JavaScriptProcess process = new JavaScriptProcess(launch, this.computeProcessName(connector));
            launch.addProcess((IProcess)process);
            JavaScriptDebugTarget target = new JavaScriptDebugTarget(vm, process, launch, true, true);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(4);
            launch.addDebugTarget((IDebugTarget)target);
        }
        finally {
            localmonitor.done();
        }
    }

    String computeCommandline(Connector connector) {
        StringBuffer buffer = new StringBuffer();
        Map args = connector.defaultArguments();
        if (args != null) {
            String arg = (String)args.get("host");
            if (arg != null) {
                buffer.append(arg);
            }
            if ((arg = (String)args.get("port")) != null) {
                buffer.append(":").append(arg);
            }
        }
        return buffer.toString();
    }

    String computeProcessName(Connector connector) {
        StringBuffer buffer = new StringBuffer(connector.name());
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)Messages.javascript_process_name, (Object[])new String[]{buffer.toString(), timestamp});
    }

    class ConnectRunnable
    implements Runnable {
        VirtualMachine vm = null;
        Exception exception = null;
        private Connector connector = null;
        private Map args = null;

        ConnectRunnable(Connector connector, Map args) {
            this.connector = connector;
            this.args = args;
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                Exception inner = null;
                do {
                    try {
                        if (this.connector instanceof AttachingConnector) {
                            this.vm = ((AttachingConnector)this.connector).attach(this.args);
                            continue;
                        }
                        if (!(this.connector instanceof ListeningConnector)) continue;
                        this.vm = ((ListeningConnector)this.connector).accept(this.args);
                    }
                    catch (Exception e) {
                        inner = e;
                    }
                } while (this.vm == null && System.currentTimeMillis() < start + 5000L);
                if (this.vm == null) {
                    throw inner;
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

