/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.addons;

import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SaveAllDirtyPartsAddon {
    @Inject
    IEventBroker eventBroker;
    private final WorkbenchJob autoSaveJob = new AutoSaveJob("Auto save all editors");
    private final EventHandler dirtyHandler;
    private final Listener idleListener;
    private boolean isAutoSaveActive;
    private long autoSaveInterval;

    @Inject
    @Optional
    public void setAutoSave(@Preference(value="SAVE_AUTOMATICALLY", nodePath="org.eclipse.ui.workbench") boolean autoSave) {
        this.isAutoSaveActive = autoSave;
        if (this.isAutoSaveActive) {
            this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*", this.dirtyHandler);
            this.autoSaveJob.schedule();
        } else {
            this.eventBroker.unsubscribe(this.dirtyHandler);
        }
    }

    @Inject
    @Optional
    public void autoSaveIntervalChanged(@Preference(value="SAVE_AUTOMATICALLY_INTERVAL", nodePath="org.eclipse.ui.workbench") int newInterval) {
        this.autoSaveInterval = TimeUnit.SECONDS.toMillis(newInterval);
    }

    public SaveAllDirtyPartsAddon() {
        this.autoSaveJob.setSystem(true);
        this.idleListener = new IdleListener();
        this.dirtyHandler = new DirtyEventHandler();
    }

    private void addIdleListenerToWorkbenchDisplay() {
        Display display = SaveAllDirtyPartsAddon.getWorkbenchDisplay();
        if (display != null && !display.isDisposed()) {
            display.addFilter(2, this.idleListener);
            display.addFilter(4, this.idleListener);
            display.addFilter(22, this.idleListener);
            display.addFilter(23, this.idleListener);
        }
    }

    private void removeIdleListenerFromWorkbenchDisplay() {
        Display display = SaveAllDirtyPartsAddon.getWorkbenchDisplay();
        if (display != null && !display.isDisposed()) {
            display.removeFilter(4, this.idleListener);
            display.removeFilter(2, this.idleListener);
            display.removeFilter(22, this.idleListener);
            display.removeFilter(23, this.idleListener);
        }
    }

    @PreDestroy
    private void shutdown() {
        this.eventBroker.unsubscribe(this.dirtyHandler);
        this.autoSaveJob.cancel();
        Display display = SaveAllDirtyPartsAddon.getWorkbenchDisplay();
        if (display != null && !display.isDisposed()) {
            try {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SaveAllDirtyPartsAddon.this.removeIdleListenerFromWorkbenchDisplay();
                        SaveAllDirtyPartsAddon.this.autoSaveJob.cancel();
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    private static boolean hasVisibleSubShell(Display display) {
        Shell shell;
        if (display != null && !display.isDisposed() && (shell = display.getActiveShell()) != null) {
            Shell[] shellArray = shell.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell subShell = shellArray[n2];
                if (subShell.isVisible()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static Display getWorkbenchDisplay() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getDisplay();
        }
        return null;
    }

    private final class AutoSaveJob
    extends WorkbenchJob {
        private AutoSaveJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IWorkbench workbench;
            if (SaveAllDirtyPartsAddon.this.isAutoSaveActive && (workbench = PlatformUI.getWorkbench()) != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage p = window.getActivePage();
                    if (p != null && !SaveAllDirtyPartsAddon.hasVisibleSubShell(SaveAllDirtyPartsAddon.getWorkbenchDisplay())) {
                        p.saveAllEditors(false);
                    } else {
                        this.schedule(SaveAllDirtyPartsAddon.this.autoSaveInterval / 2L);
                    }
                    ++n2;
                }
            }
            return Status.OK_STATUS;
        }
    }

    private final class DirtyEventHandler
    implements EventHandler {
        private DirtyEventHandler() {
        }

        public void handleEvent(Event event) {
            if (SaveAllDirtyPartsAddon.this.isAutoSaveActive) {
                Object isDirty = event.getProperty("NewValue");
                if (isDirty instanceof Boolean && ((Boolean)isDirty).booleanValue()) {
                    SaveAllDirtyPartsAddon.this.autoSaveJob.schedule(SaveAllDirtyPartsAddon.this.autoSaveInterval);
                    SaveAllDirtyPartsAddon.this.addIdleListenerToWorkbenchDisplay();
                } else if (this.noDirtyEditor(PlatformUI.getWorkbench())) {
                    SaveAllDirtyPartsAddon.this.removeIdleListenerFromWorkbenchDisplay();
                    SaveAllDirtyPartsAddon.this.autoSaveJob.cancel();
                }
            }
        }

        private boolean noDirtyEditor(IWorkbench workbench) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage p = window.getActivePage();
                if (p != null) {
                    IEditorReference[] iEditorReferenceArray = p.getEditorReferences();
                    int n3 = iEditorReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference editorRef = iEditorReferenceArray[n4];
                        if (editorRef.isDirty()) {
                            return false;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return true;
        }
    }

    private final class IdleListener
    implements Listener {
        private IdleListener() {
        }

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            if (event.type == 23 && event.widget instanceof Menu) {
                SaveAllDirtyPartsAddon.this.autoSaveJob.cancel();
                SaveAllDirtyPartsAddon.this.autoSaveJob.schedule(SaveAllDirtyPartsAddon.this.autoSaveInterval);
            } else if (SaveAllDirtyPartsAddon.this.autoSaveJob.getState() == 1) {
                if (event.type == 22 && event.widget instanceof Menu) {
                    SaveAllDirtyPartsAddon.this.autoSaveJob.cancel();
                } else {
                    SaveAllDirtyPartsAddon.this.autoSaveJob.cancel();
                    SaveAllDirtyPartsAddon.this.autoSaveJob.schedule(SaveAllDirtyPartsAddon.this.autoSaveInterval);
                }
            }
        }
    }
}

