/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkLabelProvider;

class BookmarkSorter
extends ViewerComparator {
    private int[] directions;
    private int[] priorities;
    static final int ASCENDING = 1;
    static final int DESCENDING = -1;
    static final int DESCRIPTION = 0;
    static final int RESOURCE = 1;
    static final int FOLDER = 2;
    static final int LOCATION = 3;
    static final int CREATION_TIME = 4;
    static final int[] DEFAULT_PRIORITIES;
    static final int[] DEFAULT_DIRECTIONS;

    static {
        int[] nArray = new int[5];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[4] = 4;
        DEFAULT_PRIORITIES = nArray;
        DEFAULT_DIRECTIONS = new int[]{1, 1, 1, 1, 1};
    }

    public BookmarkSorter() {
        this.resetState();
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void setTopPriority(int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.priorities.length) {
            if (this.priorities[i] == priority) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            this.resetState();
            return;
        }
        i = index;
        while (i > 0) {
            this.priorities[i] = this.priorities[i - 1];
            --i;
        }
        this.priorities[0] = priority;
        this.directions[priority] = DEFAULT_DIRECTIONS[priority];
    }

    public void setTopPriorityDirection(int direction) {
        if (direction == 1 || direction == -1) {
            this.directions[this.priorities[0]] = direction;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public int[] getPriorities() {
        return this.priorities;
    }

    public void resetState() {
        this.priorities = new int[DEFAULT_PRIORITIES.length];
        System.arraycopy(DEFAULT_PRIORITIES, 0, this.priorities, 0, this.priorities.length);
        this.directions = new int[DEFAULT_DIRECTIONS.length];
        System.arraycopy(DEFAULT_DIRECTIONS, 0, this.directions, 0, this.directions.length);
    }

    private int compare(IMarker marker1, IMarker marker2, int depth) {
        if (depth >= this.priorities.length) {
            return 0;
        }
        int column = this.priorities[depth];
        switch (column) {
            case 0: {
                String desc1 = marker1.getAttribute("message", "");
                String desc2 = marker2.getAttribute("message", "");
                int result = this.getComparator().compare(desc1, desc2);
                if (result == 0) {
                    return this.compare(marker1, marker2, depth + 1);
                }
                return result * this.directions[column];
            }
            case 1: {
                String res1 = marker1.getResource().getName();
                String res2 = marker2.getResource().getName();
                int result = this.getComparator().compare(res1, res2);
                if (result == 0) {
                    return this.compare(marker1, marker2, depth + 1);
                }
                return result * this.directions[column];
            }
            case 2: {
                String folder1 = BookmarkLabelProvider.getContainerName(marker1);
                String folder2 = BookmarkLabelProvider.getContainerName(marker2);
                int result = this.getComparator().compare(folder1, folder2);
                if (result == 0) {
                    return this.compare(marker1, marker2, depth + 1);
                }
                return result * this.directions[column];
            }
            case 3: {
                int line1 = marker1.getAttribute("lineNumber", -1);
                int line2 = marker2.getAttribute("lineNumber", -1);
                int result = line1 - line2;
                if (result == 0) {
                    return this.compare(marker1, marker2, depth + 1);
                }
                return result * this.directions[column];
            }
            case 4: {
                long result;
                try {
                    result = marker1.getCreationTime() - marker2.getCreationTime();
                }
                catch (CoreException e) {
                    result = 0L;
                }
                if (result == 0L) {
                    return this.compare(marker1, marker2, depth + 1);
                }
                return (int)result * this.directions[column];
            }
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IMarker marker1 = (IMarker)e1;
        IMarker marker2 = (IMarker)e2;
        return this.compare(marker1, marker2, 0);
    }

    public void saveState(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        int i = 0;
        while (i < this.priorities.length) {
            settings.put("priority" + i, this.priorities[i]);
            settings.put("direction" + i, this.directions[i]);
            ++i;
        }
    }

    public void restoreState(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        try {
            int i = 0;
            while (i < this.priorities.length) {
                this.priorities[i] = settings.getInt("priority" + i);
                this.directions[i] = settings.getInt("direction" + i);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            this.resetState();
        }
    }
}

