/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.IMarkerConstants;

class MarkerUtil
implements IMarkerConstants {
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    private static MessageFormat line;
    private static MessageFormat lineAndLocation;

    static {
        imageRegistry = new ImageRegistry();
        line = new MessageFormat(TaskListMessages.TaskList_line);
        lineAndLocation = new MessageFormat(TaskListMessages.TaskList_lineAndLocation);
        MarkerUtil.createImageDescriptors();
    }

    private MarkerUtil() {
    }

    static void createImageDescriptors() {
        imageDescriptors = new HashMap(51);
        imageDescriptors.put("header_complete", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/header_complete.png"));
        imageDescriptors.put("header_priority", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/header_priority.png"));
        imageDescriptors.put("task", IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/taskmrk_tsk.png"));
        imageDescriptors.put("error", IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/error_tsk.png"));
        imageDescriptors.put("warn", IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/warn_tsk.png"));
        imageDescriptors.put("info", IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/info_tsk.png"));
        imageDescriptors.put("hprio", IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/hprio_tsk.png"));
        imageDescriptors.put("lprio", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/lprio_tsk.png"));
        imageDescriptors.put("complete_tsk", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/complete_tsk.png"));
        imageDescriptors.put("incomplete_tsk", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/incomplete_tsk.png"));
        imageDescriptors.put("gotoobj", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/gotoobj_tsk.png"));
        imageDescriptors.put("addtsk", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/addtsk_tsk.png"));
        imageDescriptors.put("addtsk_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/addtsk_tsk.png"));
        imageDescriptors.put("showcomplete", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/showcomplete_tsk.png"));
        imageDescriptors.put("selected_mode", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/selected_mode.png"));
        imageDescriptors.put("selected_mode_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/selected_mode.png"));
        imageDescriptors.put("showchild_mode", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/showchild_mode.png"));
        imageDescriptors.put("showchild_mode_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showchild_mode.png"));
        imageDescriptors.put("showerr_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showerr_tsk.png"));
        imageDescriptors.put("showwarn_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showwarn_tsk.png"));
        imageDescriptors.put("showtsk_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showtsk_tsk.png"));
        imageDescriptors.put("filter", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/filter_ps.png"));
    }

    public static int getCharEnd(IMarker marker) {
        return marker.getAttribute("charEnd", -1);
    }

    public static int getCharStart(IMarker marker) {
        return marker.getAttribute("charStart", -1);
    }

    public static Image getCompleteImage(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            if (MarkerUtil.isComplete(marker)) {
                return MarkerUtil.getImage("complete_tsk");
            }
            if (!MarkerUtil.isReadOnly(marker)) {
                return MarkerUtil.getImage("incomplete_tsk");
            }
        }
        return null;
    }

    public static String getCompleteText(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            if (MarkerUtil.isComplete(marker)) {
                return TaskListMessages.TaskList_completed;
            }
            return TaskListMessages.TaskList_notCompleted;
        }
        return "";
    }

    public static String getKindText(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return TaskListMessages.TaskList_task;
        }
        switch (MarkerUtil.getSeverity(marker)) {
            case 2: {
                return TaskListMessages.TaskList_error;
            }
            case 1: {
                return TaskListMessages.TaskList_warning;
            }
            case 0: {
                return TaskListMessages.TaskList_info;
            }
        }
        return "";
    }

    public static String getContainerName(IMarker marker) {
        IPath path = marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int len = 0;
        int i = 0;
        while (i < n) {
            len += path.segment(i).length();
            ++i;
        }
        if (n > 1) {
            len += n - 1;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < n) {
            if (i2 != 0) {
                sb.append('/');
            }
            sb.append(path.segment(i2));
            ++i2;
        }
        return sb.toString();
    }

    static Image getImage(String key) {
        ImageDescriptor desc;
        Image image = imageRegistry.get(key);
        if (image == null && (desc = MarkerUtil.getImageDescriptor(key)) != null) {
            image = desc.createImage(false);
            if (image == null) {
                System.err.println("TaskList: Error creating image for " + key);
            }
            imageRegistry.put(key, image);
        }
        return image;
    }

    public static Image getImage(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtil.getSeverity(marker)) {
                case 2: {
                    return MarkerUtil.getImage("error");
                }
                case 1: {
                    return MarkerUtil.getImage("warn");
                }
                case 0: {
                    return MarkerUtil.getImage("info");
                }
            }
        } else if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.getImage("task");
        }
        return null;
    }

    static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor desc = (ImageDescriptor)imageDescriptors.get(key);
        if (desc == null) {
            IDEWorkbenchPlugin.log("TaskList: No image descriptor for " + key);
        }
        return desc;
    }

    public static String getLineAndLocation(IMarker marker) {
        int lineNumber = MarkerUtil.getLineNumber(marker);
        String location = MarkerUtil.getLocation(marker);
        return MarkerUtil.getLineAndLocation(lineNumber, location);
    }

    public static String getLineAndLocation(int lineNumber, String location) {
        if (lineNumber == -1) {
            if (location.equals("")) {
                return "";
            }
            return location;
        }
        if (location.equals("")) {
            return line.format((Object)new Object[]{Integer.toString(lineNumber)});
        }
        return lineAndLocation.format((Object)new Object[]{Integer.toString(lineNumber), location});
    }

    public static int getLineNumber(IMarker marker) {
        return marker.getAttribute("lineNumber", -1);
    }

    public static String getLocation(IMarker marker) {
        return marker.getAttribute("location", "");
    }

    public static String getMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    public static int getNumericValue(String value) {
        boolean negative = false;
        int i = 0;
        int len = value.length();
        if (i < len && value.charAt(i) == '#') {
            ++i;
        }
        if (i < len && value.charAt(i) == '-') {
            negative = true;
            ++i;
        }
        int result = 0;
        while (i < len) {
            int digit;
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                return result;
            }
            result = result * 10 + digit;
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    public static int getPriority(IMarker marker) {
        return marker.getAttribute("priority", 1);
    }

    public static Image getPriorityImage(IMarker marker) {
        switch (MarkerUtil.getPriority(marker)) {
            case 2: {
                return MarkerUtil.getImage("hprio");
            }
            case 1: {
                return null;
            }
            case 0: {
                return MarkerUtil.getImage("lprio");
            }
        }
        return null;
    }

    public static String getPriorityText(IMarker marker) {
        if (!MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return "";
        }
        switch (MarkerUtil.getPriority(marker)) {
            case 2: {
                return TaskListMessages.TaskList_high;
            }
            case 1: {
                return TaskListMessages.TaskList_normal;
            }
            case 0: {
                return TaskListMessages.TaskList_low;
            }
        }
        return "";
    }

    public static Object getProperty(Object object, String key) {
        IMarker marker = (IMarker)object;
        if ("org.eclipse.jface.image" == key) {
            return MarkerUtil.getImage(marker);
        }
        if ("org.eclipse.ui.tasklist.completeImage" == key) {
            return MarkerUtil.getCompleteImage(marker);
        }
        if ("org.eclipse.ui.tasklist.priorityImage" == key) {
            return MarkerUtil.getPriorityImage(marker);
        }
        if ("message" == key) {
            return MarkerUtil.getMessage(marker);
        }
        if ("org.eclipse.ui.tasklist.resourceName" == key) {
            return MarkerUtil.getResourceName(marker);
        }
        if ("org.eclipse.ui.tasklist.containerName" == key) {
            return MarkerUtil.getContainerName(marker);
        }
        if ("org.eclipse.ui.tasklist.lineAndLocation" == key) {
            return MarkerUtil.getLineAndLocation(marker);
        }
        if ("priority" == key) {
            return 2 - MarkerUtil.getPriority(marker);
        }
        if ("done" == key) {
            return MarkerUtil.isComplete(marker) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("org.eclipse.jface.text" == key) {
            return MarkerUtil.getMessage(marker);
        }
        return null;
    }

    public static String getResourceName(IMarker marker) {
        return marker.getResource().getName();
    }

    public static int getSeverity(IMarker marker) {
        return marker.getAttribute("severity", 1);
    }

    public static boolean isComplete(IMarker marker) {
        return marker.getAttribute("done", false);
    }

    public static boolean isEditable(IMarker marker) {
        return MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker") && !MarkerUtil.isReadOnly(marker);
    }

    public static boolean isMarkerType(IMarker marker, String type) {
        try {
            return marker.isSubtypeOf(type);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isReadOnly(IMarker marker) {
        return !marker.getAttribute("userEditable", true);
    }

    public static String getCreationTime(IMarker marker) {
        try {
            return DateFormat.getDateTimeInstance((int)1, (int)2).format(new Date(marker.getCreationTime()));
        }
        catch (CoreException e) {
            return null;
        }
    }
}

