/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.ImportRewriteSupport;
import org.eclipse.wst.jsdt.core.infer.InferrenceManager;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.RefactoringSupport;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ImportRewriteAnalyzer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public final class ImportRewrite {
    private static final char STATIC_PREFIX = 's';
    private static final char NORMAL_PREFIX = 'n';
    private final ImportRewriteContext defaultContext;
    private final IJavaScriptUnit compilationUnit;
    private final JavaScriptUnit astRoot;
    private final boolean restoreExistingImports;
    private final List existingImports;
    private String[] importOrder;
    private int importOnDemandThreshold;
    private int staticImportOnDemandThreshold;
    private List addedImports;
    private List removedImports;
    private String[] createdImports;
    private String[] createdStaticImports;
    private boolean filterImplicitImports;
    private boolean writeImports = false;
    private ImportRewriteSupport importRewriteExtension;
    private boolean isImportMatchesType = true;

    public static ImportRewrite create(IJavaScriptUnit cu, boolean restoreExistingImports) throws JavaScriptModelException {
        RefactoringSupport refactoringSupport;
        if (cu == null) {
            throw new IllegalArgumentException("JavaScript unit must not be null");
        }
        ImportRewriteSupport importRewriteExtension = null;
        InferrenceProvider[] inferenceProviders = InferrenceManager.getInstance().getInferenceProviders((IInferenceFile)((Object)cu));
        if (inferenceProviders.length > 0 && inferenceProviders[0].getRefactoringSupport() != null && (refactoringSupport = inferenceProviders[0].getRefactoringSupport()) != null) {
            importRewriteExtension = refactoringSupport.getImportRewriteSupport();
        }
        ArrayList<String> existingImport = null;
        if (restoreExistingImports) {
            existingImport = new ArrayList<String>();
            IImportDeclaration[] imports = cu.getImports();
            int i = 0;
            while (i < imports.length) {
                IImportDeclaration curr = imports[i];
                char prefix = Flags.isStatic(curr.getFlags()) ? (char)'s' : 'n';
                existingImport.add(String.valueOf(prefix) + curr.getElementName());
                ++i;
            }
        }
        return new ImportRewrite(cu, null, existingImport, importRewriteExtension);
    }

    public static ImportRewrite create(JavaScriptUnit astRoot, boolean restoreExistingImports) {
        RefactoringSupport refactoringSupport;
        if (astRoot == null) {
            throw new IllegalArgumentException("AST must not be null");
        }
        ITypeRoot typeRoot = astRoot.getTypeRoot();
        if (!(typeRoot instanceof IJavaScriptUnit)) {
            throw new IllegalArgumentException("AST must have been constructed from a JavaScript element");
        }
        ImportRewriteSupport importRewriteExtension = null;
        InferrenceProvider[] inferenceProviders = InferrenceManager.getInstance().getInferenceProviders((IInferenceFile)((Object)typeRoot));
        if (inferenceProviders.length > 0 && inferenceProviders[0].getRefactoringSupport() != null && (refactoringSupport = inferenceProviders[0].getRefactoringSupport()) != null) {
            importRewriteExtension = refactoringSupport.getImportRewriteSupport();
        }
        ArrayList<String> existingImport = null;
        if (restoreExistingImports) {
            existingImport = new ArrayList<String>();
            List imports = astRoot.imports();
            int i = 0;
            while (i < imports.size()) {
                ImportDeclaration curr = (ImportDeclaration)imports.get(i);
                StringBuffer buf = new StringBuffer();
                buf.append(curr.isStatic() ? (char)'s' : 'n').append(curr.getName().getFullyQualifiedName());
                if (curr.isOnDemand()) {
                    if (buf.length() > 1) {
                        buf.append('.');
                    }
                    buf.append('*');
                }
                existingImport.add(buf.toString());
                ++i;
            }
        }
        return new ImportRewrite((IJavaScriptUnit)typeRoot, astRoot, existingImport, importRewriteExtension);
    }

    private ImportRewrite(IJavaScriptUnit cu, JavaScriptUnit astRoot, List existingImports, ImportRewriteSupport importRewriteExtension) {
        this.compilationUnit = cu;
        this.astRoot = astRoot;
        this.importRewriteExtension = importRewriteExtension;
        if (this.importRewriteExtension != null) {
            this.isImportMatchesType = this.importRewriteExtension.isImportMatchesType();
            this.writeImports = true;
        }
        if (existingImports != null) {
            this.existingImports = existingImports;
            this.restoreExistingImports = !existingImports.isEmpty();
        } else {
            this.existingImports = new ArrayList();
            this.restoreExistingImports = false;
        }
        this.filterImplicitImports = true;
        this.defaultContext = new ImportRewriteContext(){

            public int findInContext(String qualifier, String name, int kind) {
                return ImportRewrite.this.findInImports(qualifier, name, kind);
            }
        };
        this.addedImports = null;
        this.removedImports = null;
        this.createdImports = null;
        this.createdStaticImports = null;
        this.importOrder = CharOperation.NO_STRINGS;
        this.importOnDemandThreshold = 99;
        this.staticImportOnDemandThreshold = 99;
    }

    public void setImportOrder(String[] order) {
        if (order == null) {
            throw new IllegalArgumentException("Order must not be null");
        }
        this.importOrder = order;
    }

    public void setOnDemandImportThreshold(int threshold) {
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be positive.");
        }
        this.importOnDemandThreshold = threshold;
    }

    public void setStaticOnDemandImportThreshold(int threshold) {
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be positive.");
        }
        this.staticImportOnDemandThreshold = threshold;
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public ImportRewriteContext getDefaultImportRewriteContext() {
        return this.defaultContext;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.filterImplicitImports = filterImplicitImports;
    }

    private static int compareImport(char prefix, String qualifier, String name, String curr) {
        if (curr.charAt(0) != prefix || !curr.endsWith(name)) {
            return 2;
        }
        if ((curr = curr.substring(1)).length() == name.length()) {
            if (qualifier.length() == 0) {
                return 1;
            }
            return 3;
        }
        int dotPos = curr.length() - name.length() - 1;
        if (curr.charAt(dotPos) != '.') {
            return 2;
        }
        if (qualifier.length() != dotPos || !curr.startsWith(qualifier)) {
            return 3;
        }
        return 1;
    }

    final int findInImports(String qualifier, String name, int kind) {
        boolean allowAmbiguity = kind == 3 || name.length() == 1 && name.charAt(0) == '*';
        List imports = this.existingImports;
        char prefix = kind == 1 ? (char)'n' : 's';
        int i = imports.size() - 1;
        while (i >= 0) {
            String curr = (String)imports.get(i);
            int res = ImportRewrite.compareImport(prefix, qualifier, name, curr);
            if (!(res == 2 || allowAmbiguity && res != 1)) {
                return res;
            }
            --i;
        }
        return 2;
    }

    public Type addImportFromSignature(String typeSig, AST ast) {
        return this.addImportFromSignature(typeSig, ast, this.defaultContext);
    }

    public Type addImportFromSignature(String typeSig, AST ast, ImportRewriteContext context) {
        if (typeSig == null || typeSig.length() == 0) {
            throw new IllegalArgumentException("Invalid type signature: empty or null");
        }
        int sigKind = Signature.getTypeSignatureKind(typeSig);
        switch (sigKind) {
            case 2: {
                return ast.newPrimitiveType(PrimitiveType.toCode(Signature.toString(typeSig)));
            }
            case 4: {
                Type elementType = this.addImportFromSignature(Signature.getElementType(typeSig), ast, context);
                return ast.newArrayType(elementType, Signature.getArrayCount(typeSig));
            }
            case 1: {
                String erasureName = Signature.toString(typeSig);
                if (typeSig.charAt(0) == 'L') {
                    erasureName = this.internalAddImport(erasureName, erasureName, context);
                }
                SimpleType baseType = ast.newSimpleType(ast.newName(erasureName));
                return baseType;
            }
        }
        throw new IllegalArgumentException("Unknown type signature kind: " + typeSig);
    }

    public String addImport(ITypeBinding binding) {
        return this.addImport(binding, this.defaultContext);
    }

    public String addImport(ITypeBinding binding, ImportRewriteContext context) {
        if (binding.isPrimitive()) {
            return binding.getName();
        }
        ITypeBinding normalizedBinding = ImportRewrite.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return "invalid";
        }
        if (normalizedBinding.isArray()) {
            StringBuffer res = new StringBuffer(this.addImport(normalizedBinding.getElementType(), context));
            int i = normalizedBinding.getDimensions();
            while (i > 0) {
                res.append("[]");
                --i;
            }
            return res.toString();
        }
        String qualifiedName = ImportRewrite.getRawQualifiedName(normalizedBinding);
        if (qualifiedName.length() > 0) {
            String str = this.internalAddImport(qualifiedName, qualifiedName, context);
            return str;
        }
        return ImportRewrite.getRawName(normalizedBinding);
    }

    private static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !"void".equals(binding.getName())) {
            if (binding.isAnonymous()) {
                return binding.getSuperclass();
            }
            return binding;
        }
        return null;
    }

    public Type addImport(ITypeBinding binding, AST ast) {
        return this.addImport(binding, ast, this.defaultContext);
    }

    public Type addImport(ITypeBinding binding, AST ast, ImportRewriteContext context) {
        if (binding.isPrimitive() || binding.isRecovered()) {
            return ast.newPrimitiveType(PrimitiveType.toCode(binding.getName()));
        }
        ITypeBinding normalizedBinding = ImportRewrite.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return ast.newSimpleType(ast.newSimpleName("invalid"));
        }
        if (normalizedBinding.isArray()) {
            Type elementType = this.addImport(normalizedBinding.getElementType(), ast, context);
            return ast.newArrayType(elementType, normalizedBinding.getDimensions());
        }
        String qualifiedName = ImportRewrite.getRawQualifiedName(normalizedBinding);
        if (qualifiedName.length() > 0) {
            String res = this.internalAddImport(qualifiedName, qualifiedName, context);
            return ast.newSimpleType(ast.newName(res));
        }
        return ast.newSimpleType(ast.newName(ImportRewrite.getRawName(normalizedBinding)));
    }

    public String addImport(String qualifiedTypeName, String packageName, ImportRewriteContext context) {
        if (packageName == null) {
            packageName = qualifiedTypeName;
        }
        return this.internalAddImport(qualifiedTypeName, packageName, context);
    }

    public String addImport(String qualifiedTypeName) {
        return this.addImport(qualifiedTypeName, qualifiedTypeName, this.defaultContext);
    }

    public String addStaticImport(IBinding binding) {
        return this.addStaticImport(binding, this.defaultContext);
    }

    public String addStaticImport(IBinding binding, ImportRewriteContext context) {
        if (Modifier.isStatic(binding.getModifiers())) {
            if (binding instanceof IVariableBinding) {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (variableBinding.isField()) {
                    ITypeBinding declaringType = variableBinding.getDeclaringClass();
                    return this.addStaticImport(ImportRewrite.getRawQualifiedName(declaringType), binding.getName(), true, context);
                }
            } else if (binding instanceof IFunctionBinding) {
                ITypeBinding declaringType = ((IFunctionBinding)binding).getDeclaringClass();
                return this.addStaticImport(ImportRewrite.getRawQualifiedName(declaringType), binding.getName(), false, context);
            }
        }
        throw new IllegalArgumentException("Binding must be a static field or method.");
    }

    public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
        return this.addStaticImport(declaringTypeName, simpleName, isField, this.defaultContext);
    }

    public String addStaticImport(String declaringTypeName, String simpleName, boolean isField, ImportRewriteContext context) {
        int kind;
        int res;
        if (declaringTypeName.indexOf(46) == -1) {
            return String.valueOf(declaringTypeName) + '.' + simpleName;
        }
        if (context == null) {
            context = this.defaultContext;
        }
        if ((res = context.findInContext(declaringTypeName, simpleName, kind = isField ? 2 : 3)) == 3) {
            return String.valueOf(declaringTypeName) + '.' + simpleName;
        }
        if (res == 2) {
            this.addEntry(String.valueOf('s') + declaringTypeName + '.' + simpleName);
        }
        return simpleName;
    }

    private String internalAddImport(String fullTypeName, String packageName, ImportRewriteContext context) {
        int res;
        String typeName;
        String typeContainerName;
        String importName = this.isImportMatchesType ? fullTypeName : packageName;
        int idx = importName.lastIndexOf(46);
        if (idx != -1) {
            typeContainerName = importName.substring(0, idx);
            typeName = importName.substring(idx + 1);
        } else {
            typeContainerName = "";
            typeName = importName;
        }
        if (typeContainerName.length() == 0 && PrimitiveType.toCode(typeName) != null) {
            return fullTypeName;
        }
        if (context == null) {
            context = this.defaultContext;
        }
        if ((res = context.findInContext(typeContainerName, typeName, 1)) == 3) {
            return fullTypeName;
        }
        if (res == 2) {
            this.addEntry(String.valueOf('n') + importName);
        }
        return fullTypeName;
    }

    private void addEntry(String entry) {
        this.existingImports.add(entry);
        if (this.removedImports != null && this.removedImports.remove(entry)) {
            return;
        }
        if (this.addedImports == null) {
            this.addedImports = new ArrayList();
        }
        this.addedImports.add(entry);
    }

    private boolean removeEntry(String entry) {
        if (this.existingImports.remove(entry)) {
            if (this.addedImports != null && this.addedImports.remove(entry)) {
                return true;
            }
            if (this.removedImports == null) {
                this.removedImports = new ArrayList();
            }
            this.removedImports.add(entry);
            return true;
        }
        return false;
    }

    public boolean removeImport(String qualifiedName) {
        return this.removeEntry(String.valueOf('n') + qualifiedName);
    }

    public boolean removeStaticImport(String qualifiedName) {
        return this.removeEntry(String.valueOf('s') + qualifiedName);
    }

    private static String getRawName(ITypeBinding normalizedBinding) {
        return normalizedBinding.getTypeDeclaration().getName();
    }

    private static String getRawQualifiedName(ITypeBinding normalizedBinding) {
        return normalizedBinding.getTypeDeclaration().getQualifiedName();
    }

    public final TextEdit rewriteImports(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String curr;
            int i;
            monitor.beginTask(Messages.bind(Messages.importRewrite_processDescription), 2);
            if (!this.hasRecordedChanges()) {
                this.createdImports = CharOperation.NO_STRINGS;
                this.createdStaticImports = CharOperation.NO_STRINGS;
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                return multiTextEdit;
            }
            JavaScriptUnit usedAstRoot = this.astRoot;
            if (usedAstRoot == null) {
                ASTParser parser = ASTParser.newParser(3);
                parser.setSource(this.compilationUnit);
                parser.setFocalPosition(0);
                parser.setResolveBindings(false);
                usedAstRoot = (JavaScriptUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            ImportRewriteAnalyzer computer = new ImportRewriteAnalyzer(this.compilationUnit, usedAstRoot, this.importOrder, this.importOnDemandThreshold, this.staticImportOnDemandThreshold, this.restoreExistingImports, this.importRewriteExtension);
            computer.setFilterImplicitImports(this.filterImplicitImports);
            if (this.addedImports != null) {
                i = 0;
                while (i < this.addedImports.size()) {
                    curr = (String)this.addedImports.get(i);
                    computer.addImport(curr.substring(1), 's' == curr.charAt(0));
                    ++i;
                }
            }
            if (this.removedImports != null) {
                i = 0;
                while (i < this.removedImports.size()) {
                    curr = (String)this.removedImports.get(i);
                    computer.removeImport(curr.substring(1), 's' == curr.charAt(0));
                    ++i;
                }
            }
            MultiTextEdit result = computer.getResultingEdits((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.createdImports = computer.getCreatedImports();
            this.createdStaticImports = computer.getCreatedStaticImports();
            MultiTextEdit multiTextEdit = result;
            return multiTextEdit;
        }
        finally {
            monitor.done();
        }
    }

    public String[] getCreatedImports() {
        return this.createdImports;
    }

    public String[] getCreatedStaticImports() {
        return this.createdStaticImports;
    }

    public String[] getAddedImports() {
        return ImportRewrite.filterFromList(this.addedImports, 'n');
    }

    public String[] getAddedStaticImports() {
        return ImportRewrite.filterFromList(this.addedImports, 's');
    }

    public String[] getRemovedImports() {
        return ImportRewrite.filterFromList(this.removedImports, 'n');
    }

    public String[] getRemovedStaticImports() {
        return ImportRewrite.filterFromList(this.removedImports, 's');
    }

    public boolean hasRecordedChanges() {
        if (!this.writeImports) {
            return false;
        }
        return !this.restoreExistingImports || this.addedImports != null && !this.addedImports.isEmpty() || this.removedImports != null && !this.removedImports.isEmpty();
    }

    private static String[] filterFromList(List imports, char prefix) {
        if (imports == null) {
            return CharOperation.NO_STRINGS;
        }
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < imports.size()) {
            String curr = (String)imports.get(i);
            if (prefix == curr.charAt(0)) {
                res.add(curr.substring(1));
            }
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    public boolean isImportMatchesType() {
        return this.isImportMatchesType;
    }

    public static abstract class ImportRewriteContext {
        public static final int RES_NAME_FOUND = 1;
        public static final int RES_NAME_UNKNOWN = 2;
        public static final int RES_NAME_CONFLICT = 3;
        public static final int KIND_TYPE = 1;
        public static final int KIND_STATIC_FIELD = 2;
        public static final int KIND_STATIC_METHOD = 3;

        public abstract int findInContext(String var1, String var2, int var3);
    }
}

