/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;
    public InferredType inferredType;

    public ClassScope(Scope parent, TypeDeclaration context) {
        super(3, parent);
        this.referenceContext = context;
    }

    public ClassScope(Scope parent, InferredType type) {
        super(3, parent);
        this.inferredType = type;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding enclosingType, ReferenceBinding supertype) {
        LocalTypeBinding anonymousType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        SourceTypeBinding sourceType = this.getReferenceBinding();
        sourceType.setSuperBinding(supertype);
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        anonymousType.faultInTypesForFieldsAndMethods();
    }

    private void buildFields() {
        FieldBinding fieldBinding;
        if (this.referenceContext.fields == null) {
            this.getReferenceBinding().setFields(Binding.NO_FIELDS);
            return;
        }
        FieldDeclaration[] fields = this.referenceContext.fields;
        int size = fields.length;
        int count = 0;
        int i = 0;
        while (i < size) {
            switch (fields[i].getKind()) {
                case 1: {
                    ++count;
                }
            }
            ++i;
        }
        FieldBinding[] fieldBindings = new FieldBinding[count];
        HashtableOfObject knownFieldNames = new HashtableOfObject(count);
        boolean duplicate = false;
        count = 0;
        int i2 = 0;
        while (i2 < size) {
            FieldDeclaration field = fields[i2];
            if (field.getKind() != 2) {
                fieldBinding = new FieldBinding(field.binding, this.getReferenceBinding());
                fieldBinding.id = count;
                this.checkAndSetModifiersForField(fieldBinding, field);
                if (knownFieldNames.containsKey(field.name)) {
                    duplicate = true;
                    FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(field.name);
                    if (previousBinding != null) {
                        int f = 0;
                        while (f < i2) {
                            FieldDeclaration previousField = fields[f];
                            if (previousField.binding == previousBinding) {
                                this.problemReporter().duplicateFieldInType(this.getReferenceBinding(), previousField);
                                previousField.binding = null;
                                break;
                            }
                            ++f;
                        }
                    }
                    knownFieldNames.put(field.name, null);
                    this.problemReporter().duplicateFieldInType(this.getReferenceBinding(), field);
                    field.binding = null;
                } else {
                    knownFieldNames.put(field.name, fieldBinding);
                    fieldBindings[count++] = fieldBinding;
                }
            }
            ++i2;
        }
        if (duplicate) {
            FieldBinding[] newFieldBindings = new FieldBinding[fieldBindings.length];
            size = count;
            count = 0;
            int i3 = 0;
            while (i3 < size) {
                fieldBinding = fieldBindings[i3];
                if (knownFieldNames.get(fieldBinding.name) != null) {
                    fieldBinding.id = count;
                    newFieldBindings[count++] = fieldBinding;
                }
                ++i3;
            }
            fieldBindings = newFieldBindings;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        this.getReferenceBinding().setFields(fieldBindings);
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceType = this.getReferenceBinding();
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int i = 0;
        int length = memberTypes.length;
        while (i < length) {
            ((SourceTypeBinding)memberTypes[i]).classScope.buildFieldsAndMethods();
            ++i;
        }
    }

    public SourceTypeBinding getReferenceBinding() {
        if (this.referenceContext != null) {
            return this.referenceContext.binding;
        }
        return this.inferredType.binding;
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding enclosingType, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localType = new LocalTypeBinding(this, enclosingType, this.innermostSwitchCase());
        this.referenceContext.binding = localType;
        this.checkAndSetModifiers();
        ReferenceBinding[] memberTypeBindings = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int size = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[size];
            int count = 0;
            int i = 0;
            while (i < size) {
                TypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                ReferenceBinding type = localType;
                block1: while (!CharOperation.equals(type.sourceName, memberContext.name)) {
                    if ((type = ((TypeBinding)type).enclosingType()) != null) continue;
                    int j = 0;
                    while (j < i) {
                        if (CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) break block1;
                        ++j;
                    }
                    ClassScope memberScope = new ClassScope((Scope)this, this.referenceContext.memberTypes[i]);
                    LocalTypeBinding memberBinding = memberScope.buildLocalType(localType, packageBinding);
                    memberBinding.setAsMemberType();
                    memberTypeBindings[count++] = memberBinding;
                    break;
                }
                ++i;
            }
            if (count != size) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        localType.memberTypes = memberTypeBindings;
        return localType;
    }

    void buildLocalTypeBinding(SourceTypeBinding enclosingType) {
        LocalTypeBinding localType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        this.connectTypeHierarchy();
        this.buildFieldsAndMethods();
        localType.faultInTypesForFieldsAndMethods();
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceType = this.getReferenceBinding();
        ReferenceBinding[] memberTypeBindings = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int length = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[length];
            int count = 0;
            int i = 0;
            while (i < length) {
                TypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                ReferenceBinding type = sourceType;
                block1: while (!CharOperation.equals(type.sourceName, memberContext.name)) {
                    if ((type = type.enclosingType()) != null) continue;
                    int j = 0;
                    while (j < i) {
                        if (CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) break block1;
                        ++j;
                    }
                    ClassScope memberScope = new ClassScope((Scope)this, memberContext);
                    memberTypeBindings[count++] = memberScope.buildType(sourceType, sourceType.fPackage, accessRestriction);
                    break;
                }
                ++i;
            }
            if (count != length) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        sourceType.memberTypes = memberTypeBindings;
    }

    private void buildMethods() {
        if (this.referenceContext.methods == null) {
            this.getReferenceBinding().setMethods(Binding.NO_METHODS);
            return;
        }
        AbstractMethodDeclaration[] methods = this.referenceContext.methods;
        int size = methods == null ? 0 : methods.length;
        int clinitIndex = -1;
        int i = 0;
        while (i < size) {
            if (methods[i].isClinit()) {
                clinitIndex = i;
                break;
            }
            ++i;
        }
        int count = 0;
        MethodBinding[] methodBindings = new MethodBinding[(clinitIndex == -1 ? size : size - 1) + count];
        SourceTypeBinding sourceType = this.getReferenceBinding();
        int i2 = 0;
        while (i2 < size) {
            MethodScope scope;
            MethodBinding methodBinding;
            if (i2 != clinitIndex && (methodBinding = (scope = new MethodScope(this, methods[i2], false)).createMethod(methods[i2], methods[i2].getName(), sourceType, false, false)) != null) {
                methodBindings[count++] = methodBinding;
            }
            ++i2;
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        sourceType.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        sourceType.setMethods(methodBindings);
    }

    SourceTypeBinding buildType(SourceTypeBinding enclosingType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        char[][] className;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (enclosingType == null) {
            className = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            if (this.referenceContext != null) {
                this.referenceContext.binding = new SourceTypeBinding(className, packageBinding, this);
            }
        } else {
            className = CharOperation.deepCopy(enclosingType.compoundName);
            className[className.length - 1] = CharOperation.concat(className[className.length - 1], this.referenceContext.name, '.');
            ReferenceBinding existingType = packageBinding.getType0(className[className.length - 1]);
            this.referenceContext.binding = new MemberTypeBinding(className, this, enclosingType);
        }
        SourceTypeBinding sourceType = this.getReferenceBinding();
        this.environment().setAccessRestriction(sourceType, accessRestriction);
        sourceType.fPackage.addType(sourceType);
        this.checkAndSetModifiers();
        this.buildMemberTypes(accessRestriction);
        return sourceType;
    }

    private void checkAndSetModifiers() {
        int accessorBits;
        SourceTypeBinding sourceType = this.getReferenceBinding();
        int modifiers = sourceType.modifiers;
        ReferenceBinding enclosingType = sourceType.enclosingType();
        boolean isMemberType = sourceType.isMemberType();
        if (isMemberType) {
            modifiers |= enclosingType.modifiers & 0x800;
            if (enclosingType.isViewedAsDeprecated() && !sourceType.isDeprecated()) {
                modifiers |= 0x200000;
            }
        } else if (sourceType.isLocalType()) {
            if (sourceType.isAnonymousType()) {
                modifiers |= 0x10;
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        MethodScope methodScope = (MethodScope)scope;
                        if (methodScope.isInsideInitializer()) {
                            SourceTypeBinding type = ((TypeDeclaration)methodScope.referenceContext).binding;
                            if (methodScope.initializedField != null) {
                                if (!methodScope.initializedField.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                                modifiers |= 0x200000;
                                break;
                            }
                            if (type.isStrictfp()) {
                                modifiers |= 0x800;
                            }
                            if (!type.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                            modifiers |= 0x200000;
                            break;
                        }
                        MethodBinding method = ((AbstractMethodDeclaration)methodScope.referenceContext).getBinding();
                        if (method == null) break;
                        if (method.isStrictfp()) {
                            modifiers |= 0x800;
                        }
                        if (!method.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                        modifiers |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (enclosingType.isStrictfp()) {
                            modifiers |= 0x800;
                        }
                        if (!enclosingType.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                        modifiers |= 0x200000;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        int realModifiers = modifiers & 0xFFFF;
        if (isMemberType && ((accessorBits = realModifiers & 7) & accessorBits - 1) > 1) {
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        sourceType.modifiers = modifiers;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDecl) {
        int modifiers = fieldBinding.modifiers;
        ReferenceBinding declaringClass = fieldBinding.declaringClass;
        int realModifiers = modifiers & 0xFFFF;
        int accessorBits = realModifiers & 7;
        if ((accessorBits & accessorBits - 1) > 1) {
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        if (fieldDecl.initialization == null && (modifiers & 0x10) != 0) {
            modifiers |= 0x4000000;
        }
        fieldBinding.modifiers = modifiers;
    }

    public void checkParameterizedSuperTypeCollisions() {
        ReferenceBinding[] memberTypes = this.getReferenceBinding().memberTypes;
        if (memberTypes != null && memberTypes != Binding.NO_MEMBER_TYPES) {
            int i = 0;
            int size = memberTypes.length;
            while (i < size) {
                ((SourceTypeBinding)memberTypes[i]).classScope.checkParameterizedSuperTypeCollisions();
                ++i;
            }
        }
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceType) {
        ReferenceBinding currentType = sourceType;
        do {
            if (!currentType.hasMemberTypes()) continue;
            return;
        } while (currentType.getSuperBinding() != currentType && (currentType = currentType.getSuperBinding()) != null && (currentType.tagBits & 0x10000L) == 0L);
        currentType = sourceType;
        do {
            currentType.tagBits |= 0x10000L;
        } while ((currentType = currentType.getSuperBinding()) != null && (currentType.tagBits & 0x10000L) == 0L);
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceType = this.getReferenceBinding();
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        if (memberTypes != null && memberTypes != Binding.NO_MEMBER_TYPES) {
            int i = 0;
            int size = memberTypes.length;
            while (i < size) {
                ((SourceTypeBinding)memberTypes[i]).classScope.connectTypeHierarchy();
                ++i;
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceType = this.getReferenceBinding();
        if (sourceType.id == 1) {
            sourceType.setSuperBinding(null);
            return true;
        }
        if (this.referenceContext != null && this.referenceContext.superclass == null || this.inferredType != null && this.inferredType.getSuperType() == null) {
            sourceType.setSuperBinding(this.getJavaLangObject());
            return !this.detectHierarchyCycle(sourceType, sourceType.getSuperBinding0(), null);
        }
        if (this.referenceContext != null) {
            TypeReference superclassRef = this.referenceContext.superclass;
            ReferenceBinding superclass = this.findSupertype(superclassRef);
            if (superclass != null) {
                sourceType.setSuperBinding(superclass);
                return true;
            }
        } else {
            ReferenceBinding superclass = this.findInferredSupertype(this.inferredType);
            if (superclass != null) {
                sourceType.setSuperBinding(superclass);
                if (superclass.isValidBinding()) {
                    return true;
                }
            }
        }
        sourceType.tagBits |= 0x20000L;
        sourceType.setSuperBinding(this.getJavaLangObject());
        if ((sourceType.getSuperBinding0().tagBits & 0x100L) == 0L) {
            this.detectHierarchyCycle(sourceType, sourceType.getSuperBinding0(), null);
        }
        return false;
    }

    protected boolean connectMixins() {
        SourceTypeBinding sourceType = this.inferredType.binding;
        if (sourceType.id == 1) {
            return true;
        }
        if (this.inferredType.mixins == null || this.inferredType.mixins.isEmpty()) {
            return true;
        }
        boolean noProblems = true;
        int length = this.inferredType.mixins.size();
        int i = 0;
        while (i < length) {
            char[] mixinsName = (char[])this.inferredType.mixins.get(i);
            TypeBinding mixinBinding = this.getType(mixinsName);
            if (mixinBinding == null) {
                sourceType.tagBits |= 0x20000L;
                noProblems = false;
            } else if (mixinBinding instanceof SourceTypeBinding) {
                ((SourceTypeBinding)mixinBinding).performActionOnLinkedBindings(new SourceTypeBinding.LinkedBindingAction(){

                    public boolean performAction(SourceTypeBinding linkedBinding) {
                        InferredType mixin = linkedBinding.getInferredType();
                        ClassScope.this.inferredType.mixin(mixin);
                        return true;
                    }
                });
            }
            ++i;
        }
        return noProblems;
    }

    void connectTypeHierarchy() {
        SourceTypeBinding sourceType = this.getReferenceBinding();
        if ((sourceType.tagBits & 0x100L) == 0L) {
            sourceType.tagBits |= 0x100L;
            boolean noProblems = this.connectSuperclass();
            sourceType.tagBits |= 0x200L;
            if ((noProblems &= this.connectMixins()) && sourceType.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceType);
            }
        }
        this.connectMemberTypes();
        LookupEnvironment env = this.environment();
        try {
            try {
                env.missingClassFileLocation = this.referenceContext;
                this.checkForInheritedMemberTypes(sourceType);
            }
            catch (AbortCompilation e) {
                e.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
                throw e;
            }
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceType = this.getReferenceBinding();
        if ((sourceType.tagBits & 0x100L) != 0L) {
            return;
        }
        sourceType.tagBits |= 0x100L;
        boolean noProblems = this.connectSuperclass();
        sourceType.tagBits |= 0x200L;
        if ((noProblems &= this.connectMixins()) && sourceType.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceType);
        }
    }

    public boolean detectHierarchyCycle(TypeBinding superType, TypeReference reference) {
        if (!(superType instanceof ReferenceBinding)) {
            return false;
        }
        if (reference == this.superTypeReference) {
            this.compilationUnitScope().recordSuperTypeReference(superType);
            return this.detectHierarchyCycle(this.getReferenceBinding(), (ReferenceBinding)superType, reference);
        }
        if ((superType.tagBits & 0x100L) == 0L && superType instanceof SourceTypeBinding) {
            ((SourceTypeBinding)superType).classScope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceType, ReferenceBinding superType, TypeReference reference) {
        TypeReference ref;
        if (sourceType == superType) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x20000L;
            return true;
        }
        if (superType.isMemberType()) {
            ReferenceBinding current = superType.enclosingType();
            do {
                if (!current.isHierarchyBeingConnected() || current != sourceType) continue;
                this.problemReporter().hierarchyCircularity(sourceType, current, reference);
                sourceType.tagBits |= 0x20000L;
                current.tagBits |= 0x20000L;
                return true;
            } while ((current = current.enclosingType()) != null);
        }
        if (superType.isBinaryBinding()) {
            boolean hasCycle = false;
            ReferenceBinding parentType = superType.getSuperBinding();
            if (parentType != null) {
                if (sourceType == parentType) {
                    this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                    sourceType.tagBits |= 0x20000L;
                    superType.tagBits |= 0x20000L;
                    return true;
                }
                hasCycle |= this.detectHierarchyCycle(sourceType, parentType, reference);
                if ((parentType.tagBits & 0x20000L) != 0L) {
                    sourceType.tagBits |= 0x20000L;
                    parentType.tagBits |= 0x20000L;
                }
            }
            return hasCycle;
        }
        if (superType.isHierarchyBeingConnected() && (ref = ((SourceTypeBinding)superType).classScope.superTypeReference) != null && (ref.resolvedType == null || ((ReferenceBinding)ref.resolvedType).isHierarchyBeingConnected())) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x20000L;
            superType.tagBits |= 0x20000L;
            return true;
        }
        if ((superType.tagBits & 0x100L) == 0L) {
            ((SourceTypeBinding)superType).classScope.connectTypeHierarchyWithoutMembers();
        }
        if ((superType.tagBits & 0x20000L) != 0L) {
            sourceType.tagBits |= 0x20000L;
        }
        return false;
    }

    private ReferenceBinding findInferredSupertype(InferredType type) {
        try {
            this.compilationUnitScope().recordQualifiedReference(new char[][]{type.getSuperType().getName()});
            ReferenceBinding superType = type.resolveSuperType(this);
            this.superTypeReference = null;
            return superType;
        }
        catch (AbortCompilation e) {
            e.updateContext(type, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            ReferenceBinding superType;
            env.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            unitScope.recordQualifiedReference(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            ReferenceBinding referenceBinding = superType = (ReferenceBinding)typeReference.resolveSuperType(this);
            return referenceBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
            this.superTypeReference = null;
        }
    }

    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.getReferenceBinding().toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }

    SourceTypeBinding buildInferredType(SourceTypeBinding enclosingType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.inferredType.scope = this;
        if (enclosingType == null) {
            char[][] className = CharOperation.arrayConcat(packageBinding.compoundName, this.inferredType.getName());
            this.inferredType.binding = new SourceTypeBinding(className, packageBinding, this);
            if (!this.inferredType.isNamed()) {
                this.inferredType.binding.tagBits |= 0x34L;
            }
            if (this.inferredType.isObjectLiteral) {
                this.inferredType.binding.tagBits |= 0x100000000000000L;
            }
        }
        SourceTypeBinding sourceType = this.inferredType.binding;
        LookupEnvironment environment = this.environment();
        environment.setAccessRestriction(sourceType, accessRestriction);
        environment.defaultPackage.addType(sourceType);
        if (environment.defaultPackage != sourceType.fPackage) {
            sourceType.fPackage.addType(sourceType);
        }
        return sourceType;
    }
}

