/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.env.IDependent;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;

public abstract class ReferenceBinding
extends TypeBinding
implements IDependent {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;
    private SimpleLookupTable compatibleCache;
    private static final Comparator FIELD_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            char[] n1 = ((FieldBinding)o1).name;
            char[] n2 = ((FieldBinding)o2).name;
            return ReferenceBinding.compare(n1, n2, n1.length, n2.length);
        }
    };
    private static final Comparator METHOD_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            MethodBinding m1 = (MethodBinding)o1;
            MethodBinding m2 = (MethodBinding)o2;
            char[] s1 = m1.selector;
            char[] s2 = m2.selector;
            int c = ReferenceBinding.compare(s1, s2, s1 == null ? 0 : s1.length, s2 == null ? 0 : s2.length);
            return c == 0 ? m1.parameters.length - m2.parameters.length : c;
        }
    };

    public static FieldBinding binarySearch(char[] name, FieldBinding[] sortedFields) {
        if (sortedFields == null) {
            return null;
        }
        int max = sortedFields.length;
        if (max == 0) {
            return null;
        }
        int left = 0;
        int right = max - 1;
        int nameLength = name.length;
        int mid = 0;
        while (left <= right) {
            mid = left + (right - left) / 2;
            char[] midName = sortedFields[mid].name;
            int compare = ReferenceBinding.compare(name, sortedFields[mid].name, nameLength, midName.length);
            if (compare < 0) {
                right = mid - 1;
                continue;
            }
            if (compare > 0) {
                left = mid + 1;
                continue;
            }
            return sortedFields[mid];
        }
        return null;
    }

    public static long binarySearch(char[] selector, MethodBinding[] sortedMethods) {
        if (sortedMethods == null || selector == null || selector.length == 0) {
            return -1L;
        }
        int max = sortedMethods.length;
        if (max == 0) {
            return -1L;
        }
        int left = 0;
        int right = max - 1;
        int selectorLength = selector.length;
        int mid = 0;
        while (left <= right) {
            mid = left + (right - left) / 2;
            char[] midSelector = sortedMethods[mid].selector;
            int compare = ReferenceBinding.compare(selector, sortedMethods[mid].selector, selectorLength, midSelector.length);
            if (compare < 0) {
                right = mid - 1;
                continue;
            }
            if (compare > 0) {
                left = mid + 1;
                continue;
            }
            int start = mid;
            int end = mid;
            while (start > left && CharOperation.equals(sortedMethods[start - 1].selector, selector)) {
                --start;
            }
            while (end < right && CharOperation.equals(sortedMethods[end + 1].selector, selector)) {
                ++end;
            }
            return (long)start + ((long)end << 32);
        }
        return -1L;
    }

    static int compare(char[] str1, char[] str2, int len1, int len2) {
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static void sortFields(FieldBinding[] sortedFields, int left, int right) {
        Arrays.sort(sortedFields, left, right, FIELD_COMPARATOR);
    }

    public static void sortMethods(MethodBinding[] sortedMethods, int left, int right) {
        Arrays.sort(sortedMethods, left, right, METHOD_COMPARATOR);
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return (this.modifiers & 0x400) == 0;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.fPackage;
    }

    public final boolean canBeSeenBy(ReferenceBinding receiverType, ReferenceBinding invocationType) {
        ReferenceBinding declaringClass;
        if (this.isPublic()) {
            return true;
        }
        if (invocationType == this && invocationType == receiverType) {
            return true;
        }
        if (this.isPrivate()) {
            if (receiverType != this && receiverType != this.enclosingType()) {
                return false;
            }
            if (invocationType != this) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = this;
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding currentType = receiverType;
        ReferenceBinding referenceBinding = declaringClass = this.enclosingType() == null ? this : this.enclosingType();
        do {
            if (declaringClass == currentType) {
                return true;
            }
            PackageBinding currentPackage = currentType.fPackage;
            if (currentPackage == null || currentPackage == this.fPackage) continue;
            return false;
        } while ((currentType = currentType.getSuperBinding()) != null);
        return false;
    }

    public final boolean canBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this) {
            return true;
        }
        if (invocationType == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.fPackage;
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = this;
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.fPackage;
    }

    public ReferenceBinding closestMatch() {
        return this;
    }

    public void computeId() {
        if (this.compoundName == null) {
            return;
        }
        switch (this.compoundName.length) {
            case 1: 
            case 2: {
                char[] typeName;
                char[] cArray = typeName = this.compoundName.length > 1 && CharOperation.equals(this.compoundName[0], TypeConstants.SYSTEMJS) ? this.compoundName[1] : this.compoundName[0];
                if (typeName.length == 0) {
                    return;
                }
                switch (typeName[0]) {
                    case 'B': {
                        if (CharOperation.equals(typeName, TypeConstants.BOOLEAN_OBJECT[0])) {
                            this.id = 5;
                        }
                        return;
                    }
                    case 'E': {
                        if (CharOperation.equals(typeName, TypeConstants.ERROR[0])) {
                            this.id = 19;
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(typeName, TypeConstants.FUNCTION[0])) {
                            this.id = 14;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(typeName, TypeConstants.NUMBER[0])) {
                            this.id = 10;
                        }
                        return;
                    }
                    case 'O': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_OBJECT[0])) {
                            this.id = 1;
                        }
                        return;
                    }
                    case 'S': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRING[0])) {
                            this.id = 11;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    return;
                }
                char[] packageName = this.compoundName[2];
                if (packageName.length == 0) {
                    return;
                }
                char[] typeName = this.compoundName[3];
                if (typeName.length == 0) {
                    return;
                }
                if (!CharOperation.equals(packageName, TypeConstants.REFLECT)) break;
                return;
            }
        }
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        if (!isLeaf) {
            return this.signature();
        }
        return this.signature();
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    public String debugName() {
        return this.compoundName != null ? new String(this.readableName()) : "UNNAMED TYPE";
    }

    public final int depth() {
        int depth = 0;
        ReferenceBinding current = this;
        while ((current = current.enclosingType()) != null) {
            ++depth;
        }
        return depth;
    }

    public final ReferenceBinding enclosingTypeAt(int relativeDepth) {
        ReferenceBinding current = this;
        while (relativeDepth-- > 0 && current != null) {
            current = current.enclosingType();
        }
        return current;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return Binding.NO_FIELDS;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        ReferenceBinding[] memberTypes = this.memberTypes();
        int i = memberTypes.length;
        while (--i >= 0) {
            if (!CharOperation.equals(memberTypes[i].sourceName, typeName)) continue;
            return memberTypes[i];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        return Binding.NO_METHODS;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding otherType) {
        if (this == otherType) {
            return false;
        }
        Object interfacesToVisit = null;
        boolean nextPosition = false;
        ReferenceBinding currentType = this;
        do {
            TypeBinding match;
            if ((match = otherType.findSuperTypeWithSameErasure(currentType)) == null || match.isIntersectingWith(currentType)) continue;
            return true;
        } while ((currentType = currentType.getSuperBinding()) != null);
        return false;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    boolean implementsMethod(MethodBinding method) {
        char[] selector = method.selector;
        ReferenceBinding type = this;
        while (type != null) {
            MethodBinding[] methods = type.methods();
            long range = ReferenceBinding.binarySearch(selector, methods);
            if (range >= 0L) {
                int start = (int)range;
                int end = (int)(range >> 32);
                int i = start;
                while (i <= end) {
                    if (methods[i].areParametersEqual(method)) {
                        return true;
                    }
                    ++i;
                }
            }
            type = type.getSuperBinding();
        }
        return false;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    public boolean isClass() {
        return true;
    }

    public boolean isCompatibleWith(TypeBinding otherType) {
        if (otherType == this) {
            return true;
        }
        if (otherType.id == 1 || otherType.id == 13) {
            return true;
        }
        if (this.compatibleCache == null) {
            this.compatibleCache = new SimpleLookupTable(3);
            Object result = null;
        } else {
            Object result = this.compatibleCache.get(otherType);
            if (result != null) {
                return result == Boolean.TRUE;
            }
        }
        boolean cacheThisBinding = true;
        if (this instanceof ProblemReferenceBinding) {
            cacheThisBinding = false;
        }
        if (cacheThisBinding) {
            this.compatibleCache.put(otherType, Boolean.FALSE);
        }
        if (this.isCompatibleWith0(otherType)) {
            if (cacheThisBinding) {
                this.compatibleCache.put(otherType, Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    private boolean isCompatibleWith0(TypeBinding otherType) {
        if (otherType == this) {
            return true;
        }
        if (otherType.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(otherType)) {
            return true;
        }
        switch (otherType.kind()) {
            case 4: {
                ReferenceBinding otherReferenceType = (ReferenceBinding)otherType;
                if (Arrays.equals((Object[])this.compoundName, (Object[])otherReferenceType.compoundName) && Arrays.equals(this.fileName, otherReferenceType.fileName)) {
                    return true;
                }
                if (otherReferenceType.isSuperclassOf(this)) {
                    return true;
                }
                return otherReferenceType.isAnonymousType() && this.isSuperclassOf(otherReferenceType);
            }
            case 68: {
                return this == ((ArrayBinding)otherType).referenceBinding;
            }
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        while ((otherType = otherType.getSuperBinding()) != null) {
            if (!otherType.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowable() {
        ReferenceBinding current = this;
        do {
            switch (current.id) {
                case 19: 
                case 21: 
                case 24: 
                case 25: {
                    return true;
                }
            }
        } while ((current = current.getSuperBinding()) != null);
        return false;
    }

    public boolean isUncheckedException(boolean includeSupertype) {
        return true;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public ReferenceBinding[] memberTypes() {
        return Binding.NO_MEMBER_TYPES;
    }

    public MethodBinding[] methods() {
        return Binding.NO_METHODS;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding last;
        ReferenceBinding current = this;
        do {
            last = current;
        } while ((current = current.enclosingType()) != null);
        return last;
    }

    public char[] qualifiedSourceName() {
        return this.sourceName();
    }

    public char[] readableName() {
        char[] readableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        return readableName;
    }

    public char[] shortReadableName() {
        char[] shortReadableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName;
        return shortReadableName;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    public ReferenceBinding getSuperBinding() {
        return null;
    }

    public InferredType getInferredType() {
        return null;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }

    public void cleanup() {
    }
}

