/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.util.BindingKeyParser;

public class KeyToSignature
extends BindingKeyParser {
    public static final int SIGNATURE = 0;
    public static final int TYPE_ARGUMENTS = 1;
    public static final int DECLARING_TYPE = 2;
    public static final int THROWN_EXCEPTIONS = 3;
    public StringBuffer signature = new StringBuffer();
    private int kind;
    private ArrayList arguments = new ArrayList();
    private ArrayList thrownExceptions = new ArrayList();
    private int mainTypeStart = -1;
    private int mainTypeEnd;
    private int typeSigStart = -1;
    public static final char[] ObjectSignature = "Ljava/lang/Object;".toCharArray();

    public KeyToSignature(BindingKeyParser parser) {
        super(parser);
        this.kind = ((KeyToSignature)parser).kind;
    }

    public KeyToSignature(String key, int kind) {
        super(key);
        this.kind = kind;
    }

    public void consumeArrayDimension(char[] brakets) {
        this.signature.append(brakets);
    }

    public void consumeBaseType(char[] baseTypeSig) {
        this.typeSigStart = this.signature.length();
        this.signature.append(baseTypeSig);
    }

    public void consumeCapture(int position) {
        this.signature = ((KeyToSignature)this.arguments.get((int)0)).signature;
    }

    public void consumeLocalType(char[] uniqueKey) {
        this.signature = new StringBuffer();
        uniqueKey = CharOperation.subarray(uniqueKey, 0, uniqueKey.length - 1);
        CharOperation.replace(uniqueKey, '/', '.');
        this.signature.append(uniqueKey);
    }

    public void consumeMethod(char[] selector, char[] methodSignature) {
        this.arguments = new ArrayList();
        CharOperation.replace(methodSignature, '/', '.');
        switch (this.kind) {
            case 0: {
                this.signature = new StringBuffer();
                this.signature.append(methodSignature);
            }
        }
    }

    public void consumeMemberType(char[] simpleTypeName) {
        this.signature.append('.');
        this.signature.append(simpleTypeName);
    }

    public void consumePackage(char[] pkgName) {
        this.signature.append(pkgName);
    }

    public void consumeParameterizedType(char[] simpleTypeName, boolean isRaw) {
        if (simpleTypeName != null) {
            this.signature.append('.');
            this.signature.append(simpleTypeName);
        }
        if (!isRaw) {
            this.signature.append('<');
            int length = this.arguments.size();
            int i = 0;
            while (i < length) {
                this.signature.append(((KeyToSignature)this.arguments.get((int)i)).signature);
                ++i;
            }
            this.signature.append('>');
            if (this.kind != 1) {
                this.arguments = new ArrayList();
            }
        }
    }

    public void consumeParser(BindingKeyParser parser) {
        this.arguments.add(parser);
    }

    public void consumeField(char[] fieldName) {
        if (this.kind == 0) {
            this.signature = ((KeyToSignature)this.arguments.get((int)0)).signature;
        }
    }

    public void consumeException() {
        int size = this.arguments.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                this.thrownExceptions.add(((KeyToSignature)this.arguments.get((int)i)).signature.toString());
                ++i;
            }
            this.arguments = new ArrayList();
        }
    }

    public void consumeFullyQualifiedName(char[] fullyQualifiedName) {
        this.typeSigStart = this.signature.length();
        this.signature.append('L');
        this.signature.append(CharOperation.replaceOnCopy(fullyQualifiedName, '/', '.'));
    }

    public void consumeSecondaryType(char[] simpleTypeName) {
        this.signature.append('~');
        this.mainTypeStart = this.signature.lastIndexOf(".") + 1;
        if (this.mainTypeStart == 0) {
            this.mainTypeStart = 1;
        }
        this.mainTypeEnd = this.signature.length();
        this.signature.append(simpleTypeName);
    }

    public void consumeType() {
        if (this.mainTypeStart != -1) {
            this.signature.replace(this.mainTypeStart, this.mainTypeEnd, "");
        }
        this.signature.append(';');
    }

    public void consumeTypeVariable(char[] position, char[] typeVariableName) {
        this.signature = new StringBuffer();
        this.signature.append('T');
        this.signature.append(typeVariableName);
        this.signature.append(';');
    }

    public void consumeTypeWithCapture() {
        KeyToSignature keyToSignature = (KeyToSignature)this.arguments.get(0);
        this.signature = keyToSignature.signature;
        this.arguments = keyToSignature.arguments;
        this.thrownExceptions = keyToSignature.thrownExceptions;
    }

    public String[] getThrownExceptions() {
        int length = this.thrownExceptions.size();
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = (String)this.thrownExceptions.get(i);
            ++i;
        }
        return result;
    }

    public String[] getTypeArguments() {
        int length = this.arguments.size();
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = ((KeyToSignature)this.arguments.get((int)i)).signature.toString();
            ++i;
        }
        return result;
    }

    public BindingKeyParser newParser() {
        return new KeyToSignature(this);
    }

    public String toString() {
        return this.signature.toString();
    }
}

