/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.help.internal.standalone.EclipseLifeCycleListener;
import org.eclipse.help.internal.standalone.Options;

public class Eclipse
extends Thread {
    private static final int NEEDS_RESTART = 23;
    public static final int STATUS_INIT = 0;
    public static final int STATUS_STARTED = 1;
    public static final int STATUS_ERROR = 2;
    File dir;
    String[] cmdarray;
    private int status = 0;
    private Exception exception;
    Process pr;
    private EclipseLifeCycleListener lifeCycleListener;

    public Eclipse(EclipseLifeCycleListener listener) {
        this.lifeCycleListener = listener;
        this.setName("Eclipse");
        this.dir = Options.getEclipseHome();
    }

    private void prepareCommand() throws Exception {
        if (Options.useExe()) {
            this.prepareEclipseCommand();
            this.ensureEclipseExeExists();
        } else {
            this.prepareJavaCommand();
        }
        this.ensureVmExists();
    }

    private void prepareEclipseCommand() {
        List<String> vmArgs = Options.getVmArgs();
        List<String> eclipseArgs = Options.getEclipseArgs();
        this.cmdarray = new String[3 + vmArgs.size() + 1 + eclipseArgs.size()];
        this.cmdarray[0] = new File(Options.getEclipseHome(), "eclipse").getAbsolutePath();
        this.cmdarray[1] = "-vm";
        this.cmdarray[2] = Options.getVm();
        int i = 0;
        while (i < eclipseArgs.size()) {
            this.cmdarray[3 + i] = eclipseArgs.get(i);
            ++i;
        }
        this.cmdarray[3 + eclipseArgs.size()] = "-vmargs";
        i = 0;
        while (i < vmArgs.size()) {
            this.cmdarray[4 + eclipseArgs.size() + i] = vmArgs.get(i);
            ++i;
        }
    }

    private void prepareJavaCommand() throws Exception {
        List<String> vmArgs = Options.getVmArgs();
        List<String> eclipseArgs = Options.getEclipseArgs();
        this.cmdarray = new String[1 + vmArgs.size() + 3 + eclipseArgs.size()];
        this.cmdarray[0] = Options.getVm();
        int i = 0;
        while (i < vmArgs.size()) {
            this.cmdarray[1 + i] = vmArgs.get(i);
            ++i;
        }
        this.cmdarray[1 + vmArgs.size()] = "-cp";
        this.cmdarray[2 + vmArgs.size()] = this.getStartupJar();
        this.cmdarray[3 + vmArgs.size()] = "org.eclipse.core.launcher.Main";
        i = 0;
        while (i < eclipseArgs.size()) {
            this.cmdarray[4 + vmArgs.size() + i] = eclipseArgs.get(i);
            ++i;
        }
    }

    @Override
    public void run() {
        try {
            try {
                this.prepareCommand();
                if (Options.isDebug()) {
                    this.printCommand();
                }
                do {
                    this.pr = Runtime.getRuntime().exec(this.cmdarray, null, this.dir);
                    new StreamConsumer(this.pr.getInputStream()).start();
                    new StreamConsumer(this.pr.getErrorStream()).start();
                    if (this.status == 0) {
                        this.status = 1;
                    }
                    try {
                        this.pr.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!Options.isDebug()) continue;
                    System.out.println("Eclipse exited with status code " + this.pr.exitValue());
                    if (this.pr.exitValue() != 23) continue;
                    System.out.println("Updates are installed,  Eclipse will be restarted.");
                } while (this.pr.exitValue() == 23);
            }
            catch (Exception exc) {
                this.exception = exc;
                this.status = 2;
                if (this.status == 0) {
                    this.status = 2;
                }
                if (this.status == 2 && this.exception == null) {
                    this.exception = new Exception("Unknown exception.");
                }
                this.lifeCycleListener.eclipseEnded();
            }
        }
        finally {
            if (this.status == 0) {
                this.status = 2;
            }
            if (this.status == 2 && this.exception == null) {
                this.exception = new Exception("Unknown exception.");
            }
            this.lifeCycleListener.eclipseEnded();
        }
    }

    private void ensureVmExists() throws Exception {
        File vmExe = new File(Options.getVm());
        if (vmExe.exists() && !vmExe.isDirectory()) {
            return;
        }
        vmExe = new File(String.valueOf(Options.getVm()) + ".exe");
        if (vmExe.exists() && !vmExe.isDirectory()) {
            return;
        }
        throw new Exception("File " + vmExe.getAbsolutePath() + " does not exists.  Pass a correct -vm option");
    }

    private void ensureEclipseExeExists() throws Exception {
        File eclipseExe = new File(Options.getEclipseHome(), "eclipse" + (System.getProperty("os.name").startsWith("Win") ? ".exe" : ""));
        if (eclipseExe.exists() && !eclipseExe.isDirectory()) {
            return;
        }
        throw new Exception("File " + eclipseExe.getAbsolutePath() + " does not exists.  Pass a correct -eclipsehome option");
    }

    private String getStartupJar() throws Exception {
        File pluginsDir = new File(Options.getEclipseHome(), "plugins/");
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            throw new Exception("Plugins directory " + pluginsDir.getAbsolutePath() + " does not exists.  Pass a correct -eclipsehome option");
        }
        File[] plugins = pluginsDir.listFiles();
        int i = 0;
        while (i < plugins.length) {
            String file = plugins[i].getName();
            if (file.startsWith("org.eclipse.equinox.launcher_") && file.endsWith(".jar") && !plugins[i].isDirectory()) {
                return "plugins/" + file;
            }
            ++i;
        }
        throw new Exception("Plugins directory " + pluginsDir.getAbsolutePath() + " does not contain a valid startup jar.  Pass a correct -eclipsehome option");
    }

    public Exception getException() {
        return this.exception;
    }

    public int getStatus() {
        return this.status;
    }

    private void printCommand() {
        System.out.println("Launch command is:");
        int i = 0;
        while (i < this.cmdarray.length) {
            System.out.println("  " + this.cmdarray[i]);
            ++i;
        }
    }

    public void killProcess() {
        if (this.pr != null) {
            this.pr.destroy();
        }
    }

    public class StreamConsumer
    extends Thread {
        BufferedReader bReader;

        public StreamConsumer(InputStream inputStream) {
            this.setName("Eclipse out/err consumer");
            this.setDaemon(true);
            this.bReader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.bReader.readLine()) != null) {
                    System.out.println(line);
                }
                this.bReader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

