/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.data.AbstractSubItem;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.StringDelimitedTokenizer;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;

public class CoreItem
extends ViewItem {
    protected boolean buttonsHandled = false;
    private static final int SUBITEM_COLUMNS = 6;

    public CoreItem(CheatSheetPage page, Item item, Color itemColor, CheatSheetViewer viewer) {
        super(page, item, itemColor, viewer);
    }

    private void createButtonComposite() {
        this.buttonComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
        GridLayout buttonlayout = new GridLayout(1, false);
        buttonlayout.marginHeight = 2;
        buttonlayout.marginWidth = 2;
        buttonlayout.verticalSpacing = 2;
        TableWrapData buttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)buttonlayout);
        this.buttonComposite.setLayoutData((Object)buttonData);
        this.buttonComposite.setBackground(this.itemColor);
    }

    private void createButtons(AbstractExecutable executable) {
        boolean isActionShown = false;
        if (executable != null && !this.isInDialogMode()) {
            isActionShown = true;
            final ImageHyperlink startButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"), this, this.itemColor, Messages.PERFORM_TASK_TOOLTIP);
            startButton.setLayoutData((Object)new GridData(4, 128, true, false));
            startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.runPerformExecutable(startButton);
                }
            });
        }
        if (!isActionShown || executable.isConfirm() || !executable.isRequired()) {
            final ImageHyperlink completeButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE"), this, this.itemColor, Messages.COMPLETE_TASK_TOOLTIP);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(completeButton, true);
                }
            });
        }
        if (this.item.isSkip()) {
            final ImageHyperlink skipButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_SKIP"), this, this.itemColor, Messages.SKIP_TASK_TOOLTIP);
            skipButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(skipButton, false);
                }
            });
        }
    }

    private void createSubItemButtonComposite() {
        this.buttonComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
        TableWrapLayout xbuttonlayout = new TableWrapLayout();
        xbuttonlayout.numColumns = 6;
        xbuttonlayout.leftMargin = 0;
        xbuttonlayout.rightMargin = 0;
        xbuttonlayout.horizontalSpacing = 0;
        TableWrapData xbuttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)xbuttonlayout);
        this.buttonComposite.setLayoutData((Object)xbuttonData);
        this.buttonComposite.setBackground(this.itemColor);
    }

    private void createSubItemButtons(SubItem sub, String thisValue, int index) {
        Text subItemLabel;
        int added = 0;
        if (index != 0) {
            this.addSeparator();
        }
        int LABEL_MARGIN = 5;
        SubItemCompositeHolder holder = new SubItemCompositeHolder(sub);
        Label checkDoneLabel = this.page.getToolkit().createLabel(this.buttonComposite, null);
        checkDoneLabel.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_COMPLETE"));
        checkDoneLabel.setVisible(false);
        checkDoneLabel.setBackground(this.itemColor);
        holder.setCheckDoneLabel(checkDoneLabel);
        ++added;
        String labelText = null;
        labelText = thisValue != null ? this.performLineSubstitution(sub.getLabel(), "${this}", thisValue) : sub.getLabel();
        if (sub.isFormatted()) {
            FormText formText = this.page.getToolkit().createFormText(this.buttonComposite, false);
            formText.setText(labelText, labelText.startsWith("<form><p>"), false);
            formText.setBackground(this.itemColor);
            subItemLabel = formText;
        } else {
            Text text = new Text(this.buttonComposite, 72);
            text.setText(labelText);
            text.setBackground(this.itemColor);
            subItemLabel = text;
        }
        TableWrapData labelData = new TableWrapData();
        labelData.indent = 5;
        subItemLabel.setLayoutData((Object)labelData);
        holder.setSubitemLabel((Control)subItemLabel);
        ++added;
        Label spacer = this.page.getToolkit().createLabel(this.buttonComposite, null);
        TableWrapData spacerData = new TableWrapData();
        spacerData.maxWidth = 0;
        spacerData.indent = 5;
        spacer.setLayoutData((Object)spacerData);
        ++added;
        AbstractExecutable subExecutable = null;
        if (sub.getPerformWhen() != null) {
            sub.getPerformWhen().setSelectedExecutable(this.viewer.getManager());
            subExecutable = sub.getPerformWhen().getSelectedExecutable();
        } else {
            subExecutable = sub.getExecutable();
        }
        final int fi = index;
        ImageHyperlink startButton = null;
        boolean isActionShown = false;
        if (subExecutable != null && !this.isInDialogMode()) {
            ++added;
            isActionShown = true;
            final ImageHyperlink finalStartButton = startButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"), this, this.itemColor, Messages.PERFORM_TASK_TOOLTIP);
            startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.runSubItemPerformExecutable(finalStartButton, fi);
                }
            });
            holder.setStartButton(startButton);
        }
        if (!isActionShown || subExecutable.isConfirm() || !subExecutable.isRequired()) {
            ++added;
            final ImageHyperlink completeButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE"), this, this.itemColor, Messages.COMPLETE_TASK_TOOLTIP);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceSubItem(completeButton, true, fi);
                }
            });
            holder.setCompleteButton((Control)completeButton);
        }
        if (sub.isSkip()) {
            ++added;
            final ImageHyperlink skipButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_SKIP"), this, this.itemColor, Messages.SKIP_TASK_TOOLTIP);
            skipButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceSubItem(skipButton, false, fi);
                }
            });
            holder.setSkipButton((Control)skipButton);
        }
        while (added < 6) {
            Label filler = this.page.getToolkit().createLabel(this.buttonComposite, null);
            TableWrapData fillerData = new TableWrapData();
            fillerData.maxWidth = 0;
            filler.setLayoutData((Object)fillerData);
            ++added;
        }
        holder.setThisValue(thisValue);
        this.listOfSubItemCompositeHolders.add(holder);
    }

    private void addSeparator() {
        Label pad = this.page.getToolkit().createLabel(this.buttonComposite, null);
        TableWrapData padData = new TableWrapData();
        padData.maxWidth = 0;
        pad.setLayoutData((Object)padData);
        Label separator = new Label(this.buttonComposite, 258);
        TableWrapData separatorData = new TableWrapData();
        separatorData.align = 128;
        separatorData.grabHorizontal = true;
        separatorData.maxHeight = 1;
        separatorData.valign = 32;
        separator.setLayoutData((Object)separatorData);
        int i = 3;
        while (i <= 6) {
            Label filler = this.page.getToolkit().createLabel(this.buttonComposite, null);
            TableWrapData fillerData = new TableWrapData();
            fillerData.maxWidth = 0;
            filler.setLayoutData((Object)fillerData);
            ++i;
        }
    }

    private AbstractExecutable getExecutable() {
        AbstractExecutable executable = this.item.getExecutable();
        if (executable == null && this.item.getPerformWhen() != null) {
            executable = this.item.getPerformWhen().getSelectedExecutable();
        }
        return executable;
    }

    private AbstractExecutable getExecutable(int index) {
        SubItemCompositeHolder s;
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0 && this.listOfSubItemCompositeHolders != null && (s = (SubItemCompositeHolder)this.listOfSubItemCompositeHolders.get(index)) != null) {
            SubItem subItem = s.getSubItem();
            AbstractExecutable executable = subItem.getExecutable();
            if (executable == null && subItem.getPerformWhen() != null) {
                executable = subItem.getPerformWhen().getSelectedExecutable();
            }
            return executable;
        }
        return null;
    }

    public ArrayList<SubItemCompositeHolder> getListOfSubItemCompositeHolders() {
        return this.listOfSubItemCompositeHolders;
    }

    private ImageHyperlink getStartButton() {
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            return null;
        }
        if (this.buttonComposite != null) {
            Control[] controls = this.buttonComposite.getChildren();
            int i = 0;
            while (i < controls.length) {
                String toolTipText;
                Control control = controls[i];
                if (control instanceof ImageHyperlink && (toolTipText = control.getToolTipText()) != null && (toolTipText.equals(Messages.PERFORM_TASK_TOOLTIP) || toolTipText.equals(Messages.RESTART_TASK_TOOLTIP))) {
                    return (ImageHyperlink)control;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    void handleButtons() {
        if (this.item.isDynamic()) {
            this.handleDynamicButtons();
            return;
        }
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            this.handleSubButtons();
        }
        if (this.buttonsHandled) {
            return;
        }
        this.createButtonComposite();
        this.createButtons(this.item.getExecutable());
        this.buttonsHandled = true;
    }

    private void handleDynamicButtons() {
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            this.handleDynamicSubItemButtons();
        } else if (this.item.getPerformWhen() != null) {
            this.handlePerformWhenButtons();
        }
    }

    private void handleDynamicSubItemButtons() {
        boolean refreshRequired = false;
        if (this.buttonComposite != null) {
            Control[] children = this.buttonComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control control = children[i];
                control.dispose();
                ++i;
            }
            refreshRequired = true;
        } else {
            this.createSubItemButtonComposite();
        }
        this.listOfSubItemCompositeHolders = new ArrayList(20);
        int i = 0;
        for (AbstractSubItem subItem : this.item.getSubItems()) {
            Status status;
            String message;
            if (subItem instanceof RepeatedSubItem) {
                RepeatedSubItem repeatedSubItem = (RepeatedSubItem)subItem;
                String values = repeatedSubItem.getValues();
                values = this.viewer.getManager().getVariableData(values);
                if (values == null || values.length() <= 0 || values.startsWith("${") && values.endsWith("}")) {
                    message = NLS.bind((String)Messages.ERROR_DATA_MISSING_LOG, (Object[])new Object[]{repeatedSubItem.getValues()});
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_DATA_MISSING, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                    break;
                }
                SubItem sub = (SubItem)repeatedSubItem.getSubItems().get(0);
                StringTokenizer tokenizer = new StringTokenizer(values, ",");
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    this.createSubItemButtons(sub, value, i++);
                }
                --i;
            } else if (subItem instanceof ConditionalSubItem) {
                ConditionalSubItem sub = (ConditionalSubItem)subItem;
                sub.setSelectedSubItem(this.viewer.getManager());
                SubItem selectedSubItem = sub.getSelectedSubItem();
                if (selectedSubItem == null) {
                    message = NLS.bind((String)Messages.ERROR_CONDITIONAL_DATA_MISSING_LOG, (Object[])new Object[]{sub.getCondition(), this.getItem().getTitle()});
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_DATA_MISSING, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                    break;
                }
                this.createSubItemButtons(selectedSubItem, null, i);
            } else if (subItem instanceof SubItem) {
                this.createSubItemButtons((SubItem)subItem, null, i);
            }
            ++i;
        }
        if (refreshRequired) {
            this.refresh(this.buttonComposite);
        }
    }

    private void handlePerformWhenButtons() {
        boolean refreshRequired = false;
        if (this.buttonComposite != null) {
            Control[] controls = this.buttonComposite.getChildren();
            int i = 0;
            while (i < controls.length) {
                Control control = controls[i];
                if (control instanceof ImageHyperlink) {
                    control.dispose();
                }
                ++i;
            }
            refreshRequired = true;
        } else {
            this.createButtonComposite();
        }
        this.item.getPerformWhen().setSelectedExecutable(this.viewer.getManager());
        AbstractExecutable performExecutable = this.item.getPerformWhen().getSelectedExecutable();
        this.createButtons(performExecutable);
        if (refreshRequired) {
            this.refresh(this.buttonComposite);
        }
    }

    private void handleSubButtons() {
        if (this.buttonsHandled) {
            return;
        }
        this.listOfSubItemCompositeHolders = new ArrayList(20);
        ArrayList<AbstractSubItem> sublist = this.item.getSubItems();
        this.createSubItemButtonComposite();
        int i = 0;
        while (i < sublist.size()) {
            this.createSubItemButtons((SubItem)sublist.get(i), null, i);
            ++i;
        }
        this.buttonsHandled = true;
    }

    boolean hasConfirm() {
        AbstractExecutable executable = this.getExecutable();
        return executable == null || executable.isConfirm();
    }

    boolean hasConfirm(int index) {
        AbstractExecutable executable = this.getExecutable(index);
        return executable == null || executable.isConfirm();
    }

    public String performLineSubstitution(String line, String variable, String value) {
        StringBuffer buffer = new StringBuffer(line.length());
        StringDelimitedTokenizer tokenizer = new StringDelimitedTokenizer(line, variable);
        boolean addValue = false;
        while (tokenizer.hasMoreTokens()) {
            if (addValue) {
                buffer.append(value);
            }
            buffer.append(tokenizer.nextToken());
            addValue = true;
        }
        if (tokenizer.endsWithDelimiter()) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    IStatus runExecutable(CheatSheetManager csm) {
        return this.runExecutable(this.getExecutable(), csm);
    }

    IStatus runExecutable(AbstractExecutable executable, CheatSheetManager csm) {
        if (executable != null) {
            return executable.execute(csm);
        }
        return Status.OK_STATUS;
    }

    byte runSubItemExecutable(CheatSheetManager csm, int index) {
        AbstractExecutable executable;
        SubItemCompositeHolder s;
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0 && this.listOfSubItemCompositeHolders != null && (s = (SubItemCompositeHolder)this.listOfSubItemCompositeHolders.get(index)) != null && (executable = this.getExecutable(index)) != null) {
            try {
                IStatus status;
                if (s.getThisValue() != null) {
                    csm.setData("this", s.getThisValue());
                }
                if ((status = this.runExecutable(executable, csm)).isOK()) {
                    return 0;
                }
                if (status.getSeverity() == 4) {
                    CheatSheetPlugin.getPlugin().getLog().log(status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                }
                return 1;
            }
            finally {
                if (s.getThisValue() != null) {
                    csm.setData("this", null);
                }
            }
        }
        return 0;
    }

    void setButtonsHandled(boolean handled) {
        this.buttonsHandled = handled;
    }

    @Override
    void setIncomplete() {
        super.setIncomplete();
        ArrayList<SubItemCompositeHolder> l = this.getListOfSubItemCompositeHolders();
        if (l != null) {
            int j = 0;
            while (j < l.size()) {
                SubItemCompositeHolder s = l.get(j);
                if (s.isCompleted() || s.isSkipped()) {
                    s.getCheckDoneLabel().setVisible(false);
                }
                if (s.getStartButton() != null) {
                    s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"));
                    s.getStartButton().setToolTipText(Messages.PERFORM_TASK_TOOLTIP);
                }
                ++j;
            }
        }
    }

    @Override
    void setRestartImage() {
        ImageHyperlink startButton = this.getStartButton();
        if (startButton != null) {
            startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
            startButton.setText(Messages.RESTART_TASK_TOOLTIP);
            startButton.setToolTipText(Messages.RESTART_TASK_TOOLTIP);
        }
    }

    @Override
    void setStartImage() {
        ImageHyperlink startButton = this.getStartButton();
        if (startButton != null) {
            startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"));
            if (startButton.getText() != null) {
                startButton.setText(Messages.PERFORM_TASK_TOOLTIP);
            }
            startButton.setToolTipText(Messages.PERFORM_TASK_TOOLTIP);
        }
    }

    @Override
    boolean hasCompletionMessage() {
        return this.item.getCompletionMessage() != null;
    }

    @Override
    void createCompletionComposite(boolean isFinalItem) {
        String completionMessage = this.viewer.getManager().performVariableSubstitution(this.item.getCompletionMessage());
        if (completionMessage != null) {
            Color backgroundColor = this.bodyWrapperComposite.getBackground();
            this.completionComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
            TableWrapLayout completionlayout = new TableWrapLayout();
            completionlayout.numColumns = 1;
            TableWrapData completionData = new TableWrapData(128);
            this.completionComposite.setLayout((Layout)completionlayout);
            this.completionComposite.setLayoutData((Object)completionData);
            this.completionComposite.setBackground(backgroundColor);
            FormText completionText = this.page.getToolkit().createFormText(this.completionComposite, false);
            completionText.setText(completionMessage, completionMessage.startsWith("<form><p>"), false);
            completionText.setBackground(backgroundColor);
            final ImageHyperlink completeButton = this.createButtonWithText(this.completionComposite, this.getCompletionButtonIcon(isFinalItem), this, backgroundColor, this.getCompletionButtonTooltip(isFinalItem));
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(completeButton, true);
                }
            });
            this.completionComposite.setVisible(false);
            this.setBackgroundColor(this.completionComposite, backgroundColor);
            this.refresh(this.completionComposite);
        }
    }

    private Image getCompletionButtonIcon(boolean isFinalItem) {
        if (isFinalItem) {
            return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_RETURN");
        }
        return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE");
    }

    private String getCompletionButtonTooltip(boolean isFinalItem) {
        if (isFinalItem) {
            return Messages.RETURN_TO_INTRO_TOOLTIP;
        }
        return Messages.ADVANCE_TASK_TOOLTIP;
    }

    private void refresh(Composite composite) {
        composite.layout();
        this.getMainItemComposite().layout();
        this.page.getForm().reflow(true);
    }

    public void refreshItem() {
        if (this.buttonComposite != null) {
            this.refresh(this.buttonComposite);
        }
    }

    @Override
    protected void setFocus() {
        ArrayList<SubItemCompositeHolder> list = this.getListOfSubItemCompositeHolders();
        Control subitemLabel = null;
        SubItemCompositeHolder holder = null;
        if (list != null) {
            Iterator<SubItemCompositeHolder> iter = list.iterator();
            while (iter.hasNext() && subitemLabel == null) {
                holder = iter.next();
                if (holder.isCompleted() || holder.isSkipped()) continue;
                subitemLabel = holder.getSubitemLabel();
            }
        }
        if (subitemLabel != null) {
            FormToolkit.ensureVisible(subitemLabel);
            if (holder.getStartButton() != null) {
                holder.getStartButton().setFocus();
            } else if (holder.getCompleteButton() != null) {
                holder.getCompleteButton().setFocus();
            }
        } else {
            FormToolkit.ensureVisible((Control)this.getMainItemComposite());
            super.setFocus();
        }
    }
}

