/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.internal.flat.FlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;

public class FlatFile
extends FlatResource
implements IFlatFile {
    private InputStream stream;
    private IFile file;
    private File file2;
    private String name;
    private IPath path;
    private long stamp = -1L;

    public FlatFile(IFile file, String name, IPath path) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.name = name;
        this.path = path;
        if (file != null) {
            this.stamp = file.getModificationStamp() + file.getLocalTimeStamp();
        }
    }

    public FlatFile(File file, String name, IPath path) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.file2 = file;
        this.name = name;
        this.path = path;
        if (this.file2 != null) {
            this.stamp = this.file2.lastModified();
        }
    }

    public FlatFile(InputStream is, String name, IPath path, long stamp) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.stream = is;
        this.name = name;
        this.path = path;
        this.stamp = stamp;
    }

    public FlatFile(InputStream is, String name, IPath path) {
        this(is, name, path, System.currentTimeMillis());
    }

    public FlatFile(String name, IPath path, long stamp) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.path = path;
        this.stamp = stamp;
    }

    @Override
    public long getModificationStamp() {
        return this.stamp;
    }

    @Override
    public IPath getModuleRelativePath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlatFile)) {
            return false;
        }
        FlatFile mf = (FlatFile)obj;
        if (!this.name.equals(mf.getName())) {
            return false;
        }
        return this.path.equals((Object)mf.getModuleRelativePath());
    }

    public int hashCode() {
        return this.name.hashCode() * 37 + this.path.hashCode();
    }

    public Object getAdapter(Class cl) {
        if (IFile.class.equals((Object)cl) || IResource.class.equals((Object)cl)) {
            return this.file;
        }
        if (File.class.equals((Object)cl)) {
            if (this.file2 != null) {
                return this.file2;
            }
            if (this.file != null) {
                return this.file.getLocation().toFile();
            }
        } else if (InputStream.class.equals((Object)cl)) {
            try {
                if (this.stream != null) {
                    return this.stream;
                }
                if (this.file2 != null && this.file2.exists()) {
                    return new FileInputStream(this.file2);
                }
                if (this.file != null && this.file.exists()) {
                    return new FileInputStream(this.file.getLocation().toFile());
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public String toString() {
        return "DeployableFile [" + this.name + ", " + this.path + ", " + this.stamp + "]";
    }
}

