/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static String createMethodSignature(IFunction method) {
        try {
            return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (!method.isConstructor() ? 1 : 0) != 0);
        }
        catch (JavaScriptModelException e) {
            return method.getElementName();
        }
    }

    public static String createFieldSignature(IField field) {
        return String.valueOf(JavaModelUtil.getFullyQualifiedName(field.getDeclaringType())) + "." + field.getElementName();
    }

    public static String createSignature(IMember member) {
        switch (member.getElementType()) {
            case 8: {
                return JavaElementUtil.createFieldSignature((IField)member);
            }
            case 7: {
                return JavaModelUtil.getFullyQualifiedName((IType)member);
            }
            case 10: {
                return RefactoringCoreMessages.JavaElementUtil_initializer;
            }
            case 9: {
                return JavaElementUtil.createMethodSignature((IFunction)member);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IJavaScriptElement[] getElementsOfType(IJavaScriptElement[] elements, int type) {
        HashSet<IJavaScriptElement> result = new HashSet<IJavaScriptElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaScriptElement element = elements[i];
            if (element.getElementType() == type) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IJavaScriptElement[result.size()]);
    }

    public static IType getMainType(IJavaScriptUnit cu) throws JavaScriptModelException {
        IType[] types = cu.getTypes();
        int i = 0;
        while (i < types.length) {
            if (JavaElementUtil.isMainType(types[i])) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isMainType(IType type) throws JavaScriptModelException {
        if (!type.exists()) {
            return false;
        }
        if (type.isBinary()) {
            return false;
        }
        if (type.getJavaScriptUnit() == null) {
            return false;
        }
        if (type.getDeclaringType() != null) {
            return false;
        }
        return JavaElementUtil.isPrimaryType(type) || JavaElementUtil.isCuOnlyType(type);
    }

    private static boolean isPrimaryType(IType type) {
        return type.equals(type.getJavaScriptUnit().findPrimaryType());
    }

    private static boolean isCuOnlyType(IType type) throws JavaScriptModelException {
        return type.getJavaScriptUnit().getTypes().length == 1;
    }

    public static boolean isAncestorOf(IJavaScriptElement ancestor, IJavaScriptElement child) {
        IJavaScriptElement parent = child.getParent();
        while (parent != null && !parent.equals(ancestor)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public static IFunction[] getAllConstructors(IType type) throws JavaScriptModelException {
        ArrayList<IFunction> result = new ArrayList<IFunction>();
        IFunction[] methods = type.getFunctions();
        int i = 0;
        while (i < methods.length) {
            IFunction iMethod = methods[i];
            if (iMethod.isConstructor()) {
                result.add(iMethod);
            }
            ++i;
        }
        return result.toArray(new IFunction[result.size()]);
    }

    public static IJavaScriptProject[] getReferencingProjects(IPackageFragmentRoot root) throws JavaScriptModelException {
        IIncludePathEntry cpe = root.getRawIncludepathEntry();
        IJavaScriptProject[] allJavaProjects = JavaScriptCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaScriptProjects();
        ArrayList<IJavaScriptProject> result = new ArrayList<IJavaScriptProject>(allJavaProjects.length);
        int i = 0;
        while (i < allJavaProjects.length) {
            IJavaScriptProject project = allJavaProjects[i];
            IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(cpe);
            if (roots.length > 0) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IJavaScriptProject[result.size()]);
    }

    public static IMember[] merge(IMember[] a1, IMember[] a2) {
        IMember member;
        ArrayList<IMember> result = new ArrayList<IMember>(a1.length + a2.length);
        int i = 0;
        while (i < a1.length) {
            member = a1[i];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            member = a2[i];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage();
    }

    public static IPackageFragment[] getPackageAndSubpackages(IPackageFragment pack) throws JavaScriptModelException {
        if (pack.isDefaultPackage()) {
            return new IPackageFragment[]{pack};
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IJavaScriptElement[] allPackages = root.getChildren();
        ArrayList<IPackageFragment> subpackages = new ArrayList<IPackageFragment>();
        subpackages.add(pack);
        String prefix = String.valueOf(pack.getElementName()) + '.';
        int i = 0;
        while (i < allPackages.length) {
            IPackageFragment currentPackage = (IPackageFragment)allPackages[i];
            if (currentPackage.getElementName().startsWith(prefix)) {
                subpackages.add(currentPackage);
            }
            ++i;
        }
        return subpackages.toArray(new IPackageFragment[subpackages.size()]);
    }

    public static IPackageFragment getParentSubpackage(IPackageFragment pack) {
        String newPackageName;
        if (pack.isDefaultPackage()) {
            return null;
        }
        int index = pack.getElementName().lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IPackageFragment parent = root.getPackageFragment(newPackageName = pack.getElementName().substring(0, index));
        if (parent.exists()) {
            return parent;
        }
        return null;
    }

    public static IMember[] sortByOffset(IMember[] members) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((IMember)o1).getNameRange().getOffset() - ((IMember)o2).getNameRange().getOffset();
                }
                catch (JavaScriptModelException e) {
                    return 0;
                }
            }
        };
        Arrays.sort(members, comparator);
        return members;
    }

    public static boolean isSourceAvailable(ISourceReference sourceReference) {
        try {
            return SourceRange.isAvailable(sourceReference.getSourceRange());
        }
        catch (JavaScriptModelException e) {
            return false;
        }
    }
}

