/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public class LineWrappingTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private static final String PREF_CATEGORY_INDEX = "org.eclipse.wst.jsdt.uiformatter_page.line_wrapping_tab_page.last_category_index";
    protected static final String[] INDENT_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_indentation_default, FormatterMessages.LineWrappingTabPage_indentation_on_column, FormatterMessages.LineWrappingTabPage_indentation_by_one};
    protected static final String[] WRAPPING_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_splitting_do_not_split, FormatterMessages.LineWrappingTabPage_splitting_wrap_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_always_wrap_first_others_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_wrap_always, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_indent_all_but_first, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_except_first_only_if_necessary};
    private final Category fCompactIfCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_compact_if", "function foo(int argument) {\n  if (argument==0)\n    return 0;\n  if (argument==1)\n    return 42;\n  else\n    return 43;\n}", FormatterMessages.LineWrappingTabPage_compact_if_else);
    private final Category fMethodDeclarationsParametersCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", "function foo(arg1, arg2, arg3, arg4, arg5, arg6) { var x = 0; return x;}", FormatterMessages.LineWrappingTabPage_parameters);
    private final Category fMessageSendArgumentsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", "function foo() {Other.bar( 100, 200, 300, 400, 500, 600, 700, 800, 900 );}", FormatterMessages.LineWrappingTabPage_arguments);
    private final Category fAllocationExpressionArgumentsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_allocation_expression", "foo( new SomeClass(100, 200, 300, 400, 500, 600, 700, 800, 900 ) );", FormatterMessages.LineWrappingTabPage_object_allocation);
    private final Category fArrayInitializerExpressionsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", "fArray= [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];", FormatterMessages.LineWrappingTabPage_array_init);
    private final Category fObjectInitializerExpressionsCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", "anObject = { color:'red', wheels:4, engine:{ cylinders:4, size:2.2 } };", FormatterMessages.LineWrappingTabPage_object_init);
    private final Category fConditionalExpressionCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression", "function exampleFunction( anArgument) {return anArgument ? 100000 : 200000;}", FormatterMessages.LineWrappingTabPage_conditionals);
    private final Category fBinaryExpressionCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", "function foo() {  var sum= 100 + 200 + 300 + 400 + 500 + 600 + 700 + 800;  var product= 1 * 2 * 3 * 4 * 5 * 6 * 7 * 8 * 9 * 10;  var val= true && false && true && false && true;  return product / sum;}", FormatterMessages.LineWrappingTabPage_binary_exprs);
    private final Category fAssignmentCategory = new Category("org.eclipse.wst.jsdt.core.formatter.alignment_for_assignment", "var string = \"TextTextText\";\nfunction foo() {\n    for (int i = 0; i < 10; i++) {\n    }\n    var s;\n    s = \"TextTextText\";\n}\n", FormatterMessages.LineWrappingTabPage_assignment_alignment);
    private static int DEFAULT_PREVIEW_WINDOW_LINE_WIDTH = 40;
    private static final String PREF_PREVIEW_LINE_WIDTH = "org.eclipse.wst.jsdt.ui.codeformatter.line_wrapping_tab_page.preview_line_width";
    protected final IDialogSettings fDialogSettings = JavaScriptPlugin.getDefault().getDialogSettings();
    protected TreeViewer fCategoriesViewer;
    protected Label fWrappingStylePolicy;
    protected Combo fWrappingStyleCombo;
    protected Label fIndentStylePolicy;
    protected Combo fIndentStyleCombo;
    protected Button fForceSplit;
    protected CompilationUnitPreview fPreview;
    protected Group fOptionsGroup;
    private final List fCategories;
    protected final CategoryListener fCategoryListener;
    protected IStructuredSelection fSelection;
    SelectionState fSelectionState;
    protected final Map fPreviewPreferences;
    private final String LINE_SPLIT = "org.eclipse.wst.jsdt.core.formatter.lineSplit";
    private Composite fOptionsComposite;

    public LineWrappingTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
        String previewLineWidth = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = new HashMap();
        this.fPreviewPreferences.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", previewLineWidth != null ? previewLineWidth : Integer.toString(DEFAULT_PREVIEW_WINDOW_LINE_WIDTH));
        this.fCategories = this.createCategories();
        this.fCategoryListener = new CategoryListener(this.fCategories);
    }

    protected List createCategories() {
        Category methodDeclarations = new Category(null, null, FormatterMessages.LineWrappingTabPage_method_decls);
        methodDeclarations.children.add(this.fMethodDeclarationsParametersCategory);
        Category functionCalls = new Category(FormatterMessages.LineWrappingTabPage_function_calls);
        functionCalls.children.add(this.fMessageSendArgumentsCategory);
        functionCalls.children.add(this.fAllocationExpressionArgumentsCategory);
        Category expressions = new Category(FormatterMessages.LineWrappingTabPage_expressions);
        expressions.children.add(this.fBinaryExpressionCategory);
        expressions.children.add(this.fConditionalExpressionCategory);
        expressions.children.add(this.fArrayInitializerExpressionsCategory);
        expressions.children.add(this.fObjectInitializerExpressionsCategory);
        expressions.children.add(this.fAssignmentCategory);
        Category statements = new Category(FormatterMessages.LineWrappingTabPage_statements);
        statements.children.add(this.fCompactIfCategory);
        ArrayList<Category> root = new ArrayList<Category>();
        root.add(methodDeclarations);
        root.add(functionCalls);
        root.add(expressions);
        root.add(statements);
        return root;
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        this.fOptionsComposite = composite;
        Group lineWidthGroup = this.createGroup(numColumns, composite, FormatterMessages.LineWrappingTabPage_width_indent);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_max_line_width, "org.eclipse.wst.jsdt.core.formatter.lineSplit", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_wrapped, "org.eclipse.wst.jsdt.core.formatter.continuation_indentation", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_array, "org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_objlit, "org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_objlit_initializer", 0, 9999);
        this.fCategoriesViewer = new TreeViewer(composite, 2570);
        this.fCategoriesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((Category)parentElement).children.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return !((Category)element).children.isEmpty();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fCategoriesViewer.setInput((Object)this.fCategories);
        this.fCategoriesViewer.setExpandedElements(this.fCategories.toArray());
        GridData gd = LineWrappingTabPage.createGridData(numColumns, 1808, -1);
        this.fCategoriesViewer.getControl().setLayoutData((Object)gd);
        this.fOptionsGroup = this.createGroup(numColumns, composite, "");
        this.fWrappingStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_wrapping_policy_label_text);
        this.fWrappingStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fWrappingStyleCombo.setItems(WRAPPING_NAMES);
        this.fWrappingStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fIndentStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_indentation_policy_label_text);
        this.fIndentStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fIndentStyleCombo.setItems(INDENT_NAMES);
        this.fIndentStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit = new Button((Composite)this.fOptionsGroup, 32);
        this.fForceSplit.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns - 1, 32, -1));
        this.fForceSplit.setText(FormatterMessages.LineWrappingTabPage_force_split_checkbox_text);
        ModifyDialogTabPage.CheckboxPreference expressionWrapPositionPreference = this.createCheckboxPref((Composite)this.fOptionsGroup, 1, FormatterMessages.LineWrappingTabPage_binary_expression_wrap_operator, "org.eclipse.wst.jsdt.core.formatter.wrap_before_binary_operator", FALSE_TRUE);
        Control control = ((ModifyDialogTabPage.Preference)expressionWrapPositionPreference).getControl();
        control.setVisible(false);
        ((GridData)control.getLayoutData()).exclude = true;
        this.fBinaryExpressionCategory.addPreference(expressionWrapPositionPreference);
        this.fSelectionState = new SelectionState();
    }

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        super.doCreatePreviewPane(composite, numColumns);
        ModifyDialogTabPage.NumberPreference previewLineWidth = new ModifyDialogTabPage.NumberPreference(this, composite, numColumns / 2, this.fPreviewPreferences, "org.eclipse.wst.jsdt.core.formatter.lineSplit", 0, 9999, FormatterMessages.LineWrappingTabPage_line_width_for_preview_label_text);
        this.fDefaultFocusManager.add(previewLineWidth);
        previewLineWidth.addObserver(this.fUpdater);
        previewLineWidth.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_PREVIEW_LINE_WIDTH, (String)LineWrappingTabPage.this.fPreviewPreferences.get("org.eclipse.wst.jsdt.core.formatter.lineSplit"));
            }
        });
        return composite;
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void initializePage() {
        this.fCategoriesViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCategoryListener);
        this.fCategoriesViewer.addDoubleClickListener((IDoubleClickListener)this.fCategoryListener);
        this.fForceSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.forceSplitChanged(LineWrappingTabPage.this.fForceSplit.getSelection());
            }
        });
        this.fIndentStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.indentStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fWrappingStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.wrappingStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fCategoryListener.restoreSelection();
        this.fDefaultFocusManager.add(this.fCategoriesViewer.getControl());
        this.fDefaultFocusManager.add((Control)this.fWrappingStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fIndentStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fForceSplit);
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        Object normalSetting = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.wst.jsdt.core.formatter.lineSplit"));
        this.fPreview.update();
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", normalSetting);
    }

    protected void setPreviewText(String text) {
        Object normalSetting = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.wst.jsdt.core.formatter.lineSplit"));
        this.fPreview.setPreviewText(text);
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", normalSetting);
    }

    protected void forceSplitChanged(boolean forceSplit) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = ((Category)iterator.next()).key;
            try {
                this.changeForceSplit(currentKey, forceSplit);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)forceSplit, (int)0, (int)0));
                JavaScriptPlugin.log((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeForceSplit(String currentKey, boolean forceSplit) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setForceWrapping((String)value, (boolean)forceSplit)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void wrappingStyleChanged(int wrappingStyle) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = ((Category)iterator.next()).key;
            try {
                this.changeWrappingStyle(currentKey, wrappingStyle);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)wrappingStyle, (int)0));
                JavaScriptPlugin.log((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeWrappingStyle(String currentKey, int wrappingStyle) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setWrappingStyle((String)value, (int)wrappingStyle)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void indentStyleChanged(int indentStyle) {
        Iterator iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = ((Category)iterator.next()).key;
            try {
                this.changeIndentStyle(currentKey, indentStyle);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)0, (int)indentStyle));
                JavaScriptPlugin.log((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeIndentStyle(String currentKey, int indentStyle) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setIndentStyle((String)value, (int)indentStyle)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void updateControlEnablement(boolean inhomogenous, int wrappingStyle) {
        boolean doSplit = wrappingStyle != 0;
        this.fIndentStylePolicy.setEnabled(true);
        this.fIndentStyleCombo.setEnabled(inhomogenous || doSplit);
        this.fForceSplit.setEnabled(inhomogenous || doSplit);
    }

    private static final class Category {
        public final String key;
        public final String name;
        public final String previewText;
        public final List children;
        public final List preferences;
        public int index;

        public Category(String _key, String _previewText, String _name) {
            this.key = _key;
            this.name = _name;
            this.previewText = _previewText != null ? String.valueOf(LineWrappingTabPage.createPreviewHeader(_name)) + _previewText : null;
            this.children = new ArrayList();
            this.preferences = new ArrayList();
        }

        public Category(String _name) {
            this(null, null, _name);
        }

        public String toString() {
            return this.name;
        }

        public void addPreference(ModifyDialogTabPage.Preference specificPreference) {
            this.preferences.add(specificPreference);
        }

        public ModifyDialogTabPage.Preference[] getSpecificPreferences() {
            return this.preferences.toArray(new ModifyDialogTabPage.Preference[this.preferences.size()]);
        }
    }

    private final class CategoryListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private final List fCategoriesList = new ArrayList();
        private int fIndex = 0;

        public CategoryListener(List categoriesTree) {
            this.flatten(this.fCategoriesList, categoriesTree);
        }

        private void flatten(List categoriesList, List categoriesTree) {
            for (Category category : categoriesTree) {
                ++this.fIndex;
                category.index = category.index;
                categoriesList.add(category);
                this.flatten(categoriesList, category.children);
            }
        }

        public void add(Category category) {
            category.index = this.fIndex++;
            this.fCategoriesList.add(category);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event != null) {
                LineWrappingTabPage.this.fSelection = (IStructuredSelection)event.getSelection();
            }
            if (LineWrappingTabPage.this.fSelection.size() == 0) {
                this.disableAll();
                return;
            }
            if (!LineWrappingTabPage.this.fOptionsGroup.isEnabled()) {
                this.enableDefaultComponents(true);
            }
            LineWrappingTabPage.this.fSelectionState.refreshState(LineWrappingTabPage.this.fSelection);
            Category category = (Category)LineWrappingTabPage.this.fSelection.getFirstElement();
            LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_CATEGORY_INDEX, category.index);
            LineWrappingTabPage.this.fOptionsGroup.setText(this.getGroupLabel(category));
        }

        private String getGroupLabel(Category category) {
            if (LineWrappingTabPage.this.fSelection.size() == 1) {
                if (LineWrappingTabPage.this.fSelectionState.getElements().size() == 1) {
                    return Messages.format(FormatterMessages.LineWrappingTabPage_group, category.name.toLowerCase());
                }
                return Messages.format(FormatterMessages.LineWrappingTabPage_multi_group, new String[]{category.name.toLowerCase(), Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_multiple_selections, new String[]{Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
        }

        private void disableAll() {
            this.enableDefaultComponents(false);
            LineWrappingTabPage.this.fIndentStyleCombo.setEnabled(false);
            LineWrappingTabPage.this.fForceSplit.setEnabled(false);
        }

        private void enableDefaultComponents(boolean enabled) {
            LineWrappingTabPage.this.fOptionsGroup.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStyleCombo.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStylePolicy.setEnabled(enabled);
        }

        public void restoreSelection() {
            int index;
            try {
                index = LineWrappingTabPage.this.fDialogSettings.getInt(LineWrappingTabPage.PREF_CATEGORY_INDEX);
            }
            catch (NumberFormatException ex) {
                index = -1;
            }
            if (index < 0 || index > this.fCategoriesList.size() - 1) {
                index = 1;
            }
            Category category = (Category)this.fCategoriesList.get(index);
            LineWrappingTabPage.this.fCategoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new Category[]{category}));
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Category node = (Category)((IStructuredSelection)selection).getFirstElement();
                LineWrappingTabPage.this.fCategoriesViewer.setExpandedState((Object)node, !LineWrappingTabPage.this.fCategoriesViewer.getExpandedState((Object)node));
            }
        }
    }

    private class SelectionState {
        private List fElements = new ArrayList();
        private boolean fRequiresRelayout;

        private SelectionState() {
        }

        public void refreshState(IStructuredSelection selection) {
            HashMap wrappingStyleMap = new HashMap();
            HashMap indentStyleMap = new HashMap();
            HashMap forceWrappingMap = new HashMap();
            this.fRequiresRelayout = false;
            this.showSpecificControls(false);
            this.fElements.clear();
            this.evaluateElements(selection.iterator());
            this.evaluateMaps(wrappingStyleMap, indentStyleMap, forceWrappingMap);
            LineWrappingTabPage.this.setPreviewText(this.getPreviewText(wrappingStyleMap, indentStyleMap, forceWrappingMap));
            this.refreshControls(wrappingStyleMap, indentStyleMap, forceWrappingMap);
        }

        public List getElements() {
            return this.fElements;
        }

        private void evaluateElements(Iterator iterator) {
            while (iterator.hasNext()) {
                Category category = (Category)iterator.next();
                String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
                if (value != null) {
                    if (this.fElements.contains(category)) continue;
                    this.fElements.add(category);
                    continue;
                }
                this.evaluateElements(category.children.iterator());
            }
        }

        private void evaluateMaps(Map wrappingStyleMap, Map indentStyleMap, Map forceWrappingMap) {
            Iterator iterator = this.fElements.iterator();
            while (iterator.hasNext()) {
                this.insertIntoMap(wrappingStyleMap, indentStyleMap, forceWrappingMap, (Category)iterator.next());
            }
        }

        private String getPreviewText(Map wrappingMap, Map indentMap, Map forceMap) {
            Iterator iterator = this.fElements.iterator();
            StringBuilder previewText = new StringBuilder();
            while (iterator.hasNext()) {
                Category category = (Category)iterator.next();
                previewText.append(category.previewText);
                previewText.append('\n').append('\n');
            }
            return previewText.toString();
        }

        private void insertIntoMap(Map wrappingMap, Map indentMap, Map forceMap, Category category) {
            Boolean forceWrapping;
            Integer indentStyle;
            Integer wrappingStyle;
            String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
            try {
                wrappingStyle = DefaultCodeFormatterConstants.getWrappingStyle((String)value);
                indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)value);
                forceWrapping = new Boolean(DefaultCodeFormatterConstants.getForceWrapping((String)value));
            }
            catch (IllegalArgumentException e) {
                forceWrapping = new Boolean(false);
                indentStyle = 0;
                wrappingStyle = 0;
            }
            this.increaseMapEntry(wrappingMap, wrappingStyle);
            this.increaseMapEntry(indentMap, indentStyle);
            this.increaseMapEntry(forceMap, forceWrapping);
        }

        private void increaseMapEntry(Map map, Object type) {
            Integer count = (Integer)map.get(type);
            if (count == null) {
                map.put(type, 1);
            } else {
                map.put(type, count + 1);
            }
        }

        private void refreshControls(Map wrappingStyleMap, Map indentStyleMap, Map forceWrappingMap) {
            this.updateCombos(wrappingStyleMap, indentStyleMap);
            this.updateButton(forceWrappingMap);
            Integer wrappingStyleMax = this.getWrappingStyleMax(wrappingStyleMap);
            boolean isInhomogeneous = this.fElements.size() != ((Integer)wrappingStyleMap.get(wrappingStyleMax)).intValue();
            LineWrappingTabPage.this.updateControlEnablement(isInhomogeneous, wrappingStyleMax);
            this.showSpecificControls(true);
            if (this.fRequiresRelayout) {
                LineWrappingTabPage.this.fOptionsComposite.layout(true, true);
            }
            LineWrappingTabPage.this.doUpdatePreview();
            LineWrappingTabPage.this.notifyValuesModified();
        }

        private void showSpecificControls(boolean show) {
            if (this.fElements.size() != 1) {
                return;
            }
            ModifyDialogTabPage.Preference[] preferences = ((Category)this.fElements.get(0)).getSpecificPreferences();
            if (preferences.length == 0) {
                return;
            }
            this.fRequiresRelayout = true;
            int i = 0;
            while (i < preferences.length) {
                ModifyDialogTabPage.Preference preference = preferences[i];
                Control control = preference.getControl();
                control.setVisible(show);
                ((GridData)control.getLayoutData()).exclude = !show;
                ++i;
            }
        }

        private Integer getWrappingStyleMax(Map wrappingStyleMap) {
            int maxCount = 0;
            int maxStyle = 0;
            int i = 0;
            while (i < WRAPPING_NAMES.length) {
                Integer count = (Integer)wrappingStyleMap.get(i);
                if (count != null && count > maxCount) {
                    maxCount = count;
                    maxStyle = i;
                }
                ++i;
            }
            return maxStyle;
        }

        private void updateButton(Map forceWrappingMap) {
            Integer nrOfTrue = (Integer)forceWrappingMap.get(Boolean.TRUE);
            Integer nrOfFalse = (Integer)forceWrappingMap.get(Boolean.FALSE);
            if (nrOfTrue == null || nrOfFalse == null) {
                LineWrappingTabPage.this.fForceSplit.setSelection(nrOfTrue != null);
            } else {
                LineWrappingTabPage.this.fForceSplit.setSelection(nrOfTrue > nrOfFalse);
            }
            int max = this.getMax(nrOfTrue, nrOfFalse);
            String label = FormatterMessages.LineWrappingTabPage_force_split_checkbox_multi_text;
            LineWrappingTabPage.this.fForceSplit.setText(this.getLabelText(label, max, this.fElements.size()));
        }

        private String getLabelText(String label, int count, int nElements) {
            if (nElements == 1 || count == 0) {
                return label;
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_occurences, new String[]{label, Integer.toString(count), Integer.toString(nElements)});
        }

        private int getMax(Integer nrOfTrue, Integer nrOfFalse) {
            if (nrOfTrue == null) {
                return nrOfFalse;
            }
            if (nrOfFalse == null) {
                return nrOfTrue;
            }
            if (nrOfTrue.compareTo(nrOfFalse) >= 0) {
                return nrOfTrue;
            }
            return nrOfFalse;
        }

        private void updateCombos(Map wrappingStyleMap, Map indentStyleMap) {
            this.updateCombo(LineWrappingTabPage.this.fWrappingStyleCombo, wrappingStyleMap, WRAPPING_NAMES);
            this.updateCombo(LineWrappingTabPage.this.fIndentStyleCombo, indentStyleMap, INDENT_NAMES);
        }

        private void updateCombo(Combo combo, Map map, String[] items) {
            String[] newItems = new String[items.length];
            int maxCount = 0;
            int maxStyle = 0;
            int i = 0;
            while (i < items.length) {
                int val;
                Integer count = (Integer)map.get(i);
                int n = val = count == null ? 0 : count;
                if (val > maxCount) {
                    maxCount = val;
                    maxStyle = i;
                }
                newItems[i] = this.getLabelText(items[i], val, this.fElements.size());
                ++i;
            }
            combo.setItems(newItems);
            combo.setText(newItems[maxStyle]);
        }
    }
}

